/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.cover;

import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.mechanics.enderStorage.EnderFluidContainer;
import com.github.technus.tectech.mechanics.enderStorage.EnderLinkCoverMessage;
import com.github.technus.tectech.mechanics.enderStorage.EnderLinkTag;
import com.github.technus.tectech.mechanics.enderStorage.EnderWorldSavedData;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.IGuiScreen;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_TM_EnderFluidLink
extends GT_CoverBehavior {
    private static final int L_PER_TICK = 8000;
    private static final int IMPORT_EXPORT_MASK = 1;
    private static final int PUBLIC_PRIVATE_MASK = 2;
    private static EnderLinkTag tag = new EnderLinkTag("", null);
    private static TM_EnderFluidLinkCover GUI_INSTANCE;

    public static void setEnderLinkTag(EnderLinkTag inputTag) {
        if (inputTag != null) {
            tag = inputTag;
            GUI_INSTANCE.resetColorField();
        }
    }

    private void transferFluid(IFluidHandler source, byte sSide, IFluidHandler target, byte tSide, int amount) {
        FluidStack fluidStack = source.drain(ForgeDirection.getOrientation((int)sSide), amount, false);
        if (fluidStack != null) {
            int fluidTransferred = target.fill(ForgeDirection.getOrientation((int)tSide), fluidStack, true);
            source.drain(ForgeDirection.getOrientation((int)sSide), fluidTransferred, true);
        }
    }

    private boolean testBit(int aCoverVariable, int bitMask) {
        return (aCoverVariable & bitMask) != 0;
    }

    private int toggleBit(int aCoverVariable, int bitMask) {
        return aCoverVariable ^ bitMask;
    }

    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IFluidHandler) {
            IFluidHandler fluidHandlerSelf = (IFluidHandler)aTileEntity;
            EnderFluidContainer fluidHandlerEnder = EnderWorldSavedData.getEnderFluidContainer(EnderWorldSavedData.getEnderLinkTag((IFluidHandler)aTileEntity));
            if (this.testBit(aCoverVariable, 1)) {
                this.transferFluid(fluidHandlerEnder, (byte)6, fluidHandlerSelf, aSide, 8000);
            } else {
                this.transferFluid(fluidHandlerSelf, aSide, fluidHandlerEnder, (byte)6, 8000);
            }
        }
        return aCoverVariable;
    }

    public String getDescription(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return "";
    }

    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int newCoverVariable = this.toggleBit(aCoverVariable, 1);
        if (this.testBit(aCoverVariable, 1)) {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Suction Engaged!");
        } else {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Filling Engaged!");
        }
        return newCoverVariable;
    }

    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    public boolean hasCoverGUI() {
        return true;
    }

    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        TM_EnderFluidLinkCover gui = null;
        if (aTileEntity instanceof IFluidHandler) {
            gui = new TM_EnderFluidLinkCover(aSide, aCoverID, coverData, aTileEntity);
        }
        return gui;
    }

    private class TM_EnderFluidLinkCover
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private GT_GuiTextBox colorField;
        private static final int START_X = 10;
        private static final int START_Y = 25;
        private static final int SPACE_X = 18;
        private static final int SPACE_Y = 18;
        private static final int SIZE_X = 176;
        private static final int SIZE_Y = 107;
        private static final int BOX_SIZE_X = 34;
        private static final int BOX_SIZE_Y = 34;
        private static final int TEXT_FIELD_SIZE_X = 82;
        private static final int TEXT_FIELD_SIZE_Y = 12;
        private static final int TEXT_STRING_LENGTH = 9;
        private static final int FONT_COLOR = -11184811;
        private static final int BOX_BORDER_COLOR = -16777216;
        private static final int COLOR_FIELD_ID = 0;
        private static final int PUBLIC_BUTTON_ID = 1;
        private static final int PRIVATE_BUTTON_ID = 2;
        private static final int IMPORT_BUTTON_ID = 3;
        private static final int EXPORT_BUTTON_ID = 4;

        private GT_GuiIconButton newButtonWithSpacing(int id, int x, int y, GT_GuiIcon icon) {
            return new GT_GuiIconButton((IGuiScreen)this, id, 10 + 18 * x, 25 + 18 * y, icon);
        }

        private GT_GuiTextBox newTextField(int id, int x, int y) {
            GT_GuiTextBox field = new GT_GuiTextBox((IGuiScreen)this, id, 10 + 18 * x, 25 + 18 * y, 82, 12);
            field.func_146203_f(9);
            return field;
        }

        private int drawNewString(String text, int x, int y) {
            int align = 4;
            return this.field_146289_q.func_78276_b(text, 10 + 18 * x, align + 25 + 18 * y, -11184811);
        }

        public TM_EnderFluidLinkCover(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack((int)aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            NetworkDispatcher.INSTANCE.sendToServer(new EnderLinkCoverMessage.EnderLinkCoverQuery(tag, (IFluidHandler)this.tile));
            this.colorField = this.newTextField(0, 0, 0);
            GUI_INSTANCE = this;
            this.resetColorField();
            this.newButtonWithSpacing(1, 0, 2, GT_GuiIcon.WHITELIST).setTooltipText(new String[]{GT_Cover_TM_EnderFluidLink.this.trans("326", "Public")});
            this.newButtonWithSpacing(2, 1, 2, GT_GuiIcon.BLACKLIST).setTooltipText(new String[]{GT_Cover_TM_EnderFluidLink.this.trans("327", "Private")});
            this.newButtonWithSpacing(3, 0, 3, GT_GuiIcon.IMPORT).setTooltipText(new String[]{GT_Cover_TM_EnderFluidLink.this.trans("007", "Import")});
            this.newButtonWithSpacing(4, 1, 3, GT_GuiIcon.EXPORT).setTooltipText(new String[]{GT_Cover_TM_EnderFluidLink.this.trans("006", "Export")});
        }

        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.drawNewString(GT_Cover_TM_EnderFluidLink.this.trans("328", "Channel"), 5, 0);
            this.drawNewString(GT_Cover_TM_EnderFluidLink.this.trans("329", "Public/Private"), 2, 2);
            this.drawNewString(GT_Cover_TM_EnderFluidLink.this.trans("229", "Import/Export"), 2, 3);
        }

        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.field_146127_k)) {
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k);
                GT_Values.NW.sendToServer((GT_Packet)new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GuiButton b = (GuiButton)o;
                b.field_146124_l = this.getClickable(b.field_146127_k);
            }
        }

        private void switchPrivatePublic(int coverVar) {
            UUID ownerUUID = tag.getUUID();
            ownerUUID = GT_Cover_TM_EnderFluidLink.this.testBit(coverVar, 2) ? GT_Mod.gregtechproxy.getThePlayer().func_110124_au() : null;
            EnderLinkTag newTag = new EnderLinkTag(tag.getFrequency(), ownerUUID);
            NetworkDispatcher.INSTANCE.sendToServer(new EnderLinkCoverMessage.EnderLinkCoverUpdate(newTag, (IFluidHandler)this.tile));
        }

        private int getNewCoverVariable(int id) {
            int tempCoverVariable = this.coverVariable;
            switch (id) {
                case 1: 
                case 2: {
                    tempCoverVariable = GT_Cover_TM_EnderFluidLink.this.toggleBit(tempCoverVariable, 2);
                    this.switchPrivatePublic(tempCoverVariable);
                    break;
                }
                case 3: 
                case 4: {
                    tempCoverVariable = GT_Cover_TM_EnderFluidLink.this.toggleBit(tempCoverVariable, 1);
                }
            }
            return tempCoverVariable;
        }

        private boolean getClickable(int id) {
            boolean canBeClicked = false;
            switch (id) {
                case 1: {
                    canBeClicked = GT_Cover_TM_EnderFluidLink.this.testBit(this.coverVariable, 2);
                    break;
                }
                case 2: {
                    canBeClicked = !GT_Cover_TM_EnderFluidLink.this.testBit(this.coverVariable, 2);
                    break;
                }
                case 3: {
                    canBeClicked = GT_Cover_TM_EnderFluidLink.this.testBit(this.coverVariable, 1);
                    break;
                }
                case 4: {
                    canBeClicked = !GT_Cover_TM_EnderFluidLink.this.testBit(this.coverVariable, 1);
                }
            }
            return canBeClicked;
        }

        public void applyTextBox(GT_GuiIntegerTextBox box) {
            try {
                String string = box.func_146179_b();
                tag = new EnderLinkTag(string, tag.getUUID());
                NetworkDispatcher.INSTANCE.sendToServer(new EnderLinkCoverMessage.EnderLinkCoverUpdate(tag, (IFluidHandler)this.tile));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.resetColorField();
        }

        public void resetTextBox(GT_GuiIntegerTextBox box) {
            box.func_146180_a(tag.getFrequency());
        }

        public void resetColorField() {
            this.resetTextBox(this.colorField);
        }

        private class GT_GuiTextBox
        extends GT_GuiIntegerTextBox {
            public GT_GuiTextBox(IGuiScreen gui, int id, int x, int y, int width, int height) {
                super(gui, id, x, y, width, height);
            }

            public boolean validChar(char c, int key) {
                return true;
            }
        }
    }
}

