/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.single;

import com.github.technus.tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel;
import com.github.technus.tectech.thing.metaTileEntity.pipe.GT_MetaTileEntity_Pipe_Energy;
import com.github.technus.tectech.thing.metaTileEntity.single.gui.GT_Container_DebugPowerGenerator;
import com.github.technus.tectech.thing.metaTileEntity.single.gui.GT_GUIContainer_DebugPowerGenerator;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.TT_Utility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_DebugPowerGenerator
extends GT_MetaTileEntity_TieredMachineBlock
implements IConnectsToEnergyTunnel {
    private static GT_RenderedTexture GENNY;
    private boolean LASER = false;
    public int EUT = 0;
    public int AMP = 0;
    public boolean producing = true;

    public GT_MetaTileEntity_DebugPowerGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
        TT_Utility.setTier(aTier, this);
    }

    public GT_MetaTileEntity_DebugPowerGenerator(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        TT_Utility.setTier(aTier, this);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DebugPowerGenerator(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.LASER = !this.LASER;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)String.format(StatCollector.func_74838_a((String)"tt.chat.debug.generator"), this.LASER ? "ON" : "OFF"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        GENNY = new GT_RenderedTexture((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/GENNY"));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1];
        iTextureArray[1] = aSide != aFacing ? (this.LASER ? (aActive ? Textures.OVERLAYS_ENERGY_OUT_LASER_TT[this.mTier] : Textures.OVERLAYS_ENERGY_IN_LASER_TT[this.mTier]) : (aActive ? Textures.OVERLAYS_ENERGY_OUT_POWER_TT[this.mTier] : Textures.OVERLAYS_ENERGY_IN_POWER_TT[this.mTier])) : GENNY;
        return iTextureArray;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_DebugPowerGenerator(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_DebugPowerGenerator(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("eEUT", this.EUT);
        aNBT.func_74768_a("eAMP", this.AMP);
        aNBT.func_74757_a("eLaser", this.LASER);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.EUT = aNBT.func_74762_e("eEUT");
        this.AMP = aNBT.func_74762_e("eAMP");
        this.LASER = aNBT.func_74767_n("eLaser");
        this.producing = (long)this.AMP * (long)this.EUT >= 0L;
        this.getBaseMetaTileEntity().setActive(this.producing);
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(this.producing);
            if (!this.LASER) {
                if (aBaseMetaTileEntity.isActive()) {
                    this.setEUVar(this.maxEUStore());
                } else {
                    this.setEUVar(0L);
                }
            } else {
                byte Tick = (byte)(aTick % 20L);
                if (aBaseMetaTileEntity.isActive() && 16 == Tick) {
                    this.setEUVar(this.maxEUStore());
                    this.moveAround(aBaseMetaTileEntity);
                } else if (16 == Tick) {
                    this.setEUVar(0L);
                }
            }
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.3"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.genny.desc.2")};
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isEnetOutput() {
        return !this.LASER;
    }

    public boolean isEnetInput() {
        return !this.LASER;
    }

    public boolean isInputFacing(byte aSide) {
        return !this.producing && aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(byte aSide) {
        return this.producing && aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public long maxAmperesIn() {
        return this.producing ? 0L : (long)Math.abs(this.AMP);
    }

    public long maxAmperesOut() {
        return this.producing ? (long)Math.abs(this.AMP) : 0L;
    }

    public long maxEUInput() {
        return this.producing ? 0L : Integer.MAX_VALUE;
    }

    public long maxEUOutput() {
        return this.producing ? (long)Math.abs(this.EUT) : 0L;
    }

    public long maxEUStore() {
        return this.LASER ? Math.abs((long)this.EUT * (long)this.AMP * 24L) : Math.abs((long)this.EUT * (long)this.AMP) << 2;
    }

    public long getMinimumStoredEU() {
        return Math.abs((long)this.EUT * (long)this.AMP);
    }

    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    @Override
    public boolean canConnect(byte side) {
        return this.LASER && side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    private void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        for (byte face = 0; face < 6; face = (byte)(face + 1)) {
            if (face == aBaseMetaTileEntity.getFrontFacing()) continue;
            byte opposite = GT_Utility.getOppositeSide((int)face);
            for (int dist = 1; dist < 1000; dist = (int)((short)(dist + 1))) {
                IMetaTileEntity aMetaTileEntity;
                IGregTechTileEntity tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSideAndDistance(face, dist);
                if (tGTTileEntity == null || (aMetaTileEntity = tGTTileEntity.getMetaTileEntity()) == null) continue;
                if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyTunnel && opposite == tGTTileEntity.getFrontFacing()) {
                    if (this.maxEUOutput() > ((GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity).maxEUInput()) {
                        aMetaTileEntity.doExplosion(this.maxEUOutput());
                        continue;
                    }
                    long diff = Math.min((long)this.AMP * 20L * this.maxEUOutput(), Math.min(((GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity).maxEUStore() - aMetaTileEntity.getBaseMetaTileEntity().getStoredEU(), aBaseMetaTileEntity.getStoredEU()));
                    ((GT_MetaTileEntity_Hatch_EnergyTunnel)aMetaTileEntity).setEUVar(aMetaTileEntity.getBaseMetaTileEntity().getStoredEU() + diff);
                    continue;
                }
                if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Pipe_Energy) || ((GT_MetaTileEntity_Pipe_Energy)aMetaTileEntity).connectionCount < 2) continue;
                ((GT_MetaTileEntity_Pipe_Energy)aMetaTileEntity).markUsed();
            }
        }
    }
}

