/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.anomaly;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.MainLoader;
import com.github.technus.tectech.loader.NetworkDispatcher;
import com.github.technus.tectech.mechanics.data.ChunkDataHandler;
import com.github.technus.tectech.mechanics.data.ChunkDataMessage;
import com.github.technus.tectech.mechanics.data.IChunkMetaDataHandler;
import com.github.technus.tectech.mechanics.data.PlayerDataMessage;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMAtomDefinition;
import com.github.technus.tectech.util.TT_Utility;
import cpw.mods.fml.common.gameevent.TickEvent;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;

public class AnomalyHandler
implements IChunkMetaDataHandler {
    private static final double SWAP_THRESHOLD = EMAtomDefinition.getSomethingHeavy().getMass() * 1000.0 * EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED;
    private static final int COUNT_DIV = 32;
    private static final double PER_PARTICLE = SWAP_THRESHOLD / 32.0;
    private static final String INTENSITY = "intensity";
    private static final String SPACE_CANCER = "space_cancer";
    private static final String SPACE_CHARGE = "space_charge";
    private static final String SPACE_MASS = "space_mass";
    private static final int MEAN_DELAY = 50;
    private static final double CANCER_EFFECTIVENESS = 1.565133549859858E-29;
    private static final double MASS_EFFECTIVENESS = 1.565133549859858E-29;
    private static final double CHARGE_EFFECTIVENESS = 1.565133549859858E-28;
    private static final double CHARGE_EXPLOSIVENESS = 7.82566774929929E-29;
    private boolean fixMe = false;
    private final List<EntityPlayer> playersWithCharge = new ArrayList<EntityPlayer>();
    private final ArrayList<Chunk> worldDataArrayList = new ArrayList(512);

    @Override
    public String getTagName() {
        return "anomaly";
    }

    @Override
    public void mergeData(NBTTagCompound target, NBTTagCompound loadedData) {
        double intensity = target.func_74769_h(INTENSITY) + loadedData.func_74769_h(INTENSITY);
        target.func_74780_a(INTENSITY, intensity);
    }

    @Override
    public NBTTagCompound createData() {
        return new NBTTagCompound();
    }

    @Override
    public void tickWorld(HashMap<Integer, ChunkDataHandler.ChunkHashMap> data, TickEvent.WorldTickEvent aEvent) {
        if (TecTech.RANDOM.nextInt(50) == 0) {
            int dim = aEvent.world.field_73011_w.field_76574_g;
            ChunkDataHandler.ChunkHashMap chunkHashMap = data.get(dim);
            chunkHashMap.forEach((chunkCoordIntPair, compound) -> {
                if (compound.func_74769_h(INTENSITY) > SWAP_THRESHOLD) {
                    Chunk chunk = aEvent.world.func_72964_e(chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b);
                    if (chunk.field_76636_d) {
                        this.worldDataArrayList.add(chunk);
                    }
                }
            });
            if (this.worldDataArrayList.size() >= 2) {
                Chunk a = this.worldDataArrayList.remove(TecTech.RANDOM.nextInt(this.worldDataArrayList.size()));
                Chunk b = this.worldDataArrayList.get(TecTech.RANDOM.nextInt(this.worldDataArrayList.size()));
                ChunkCoordIntPair aCoords = a.func_76632_l();
                ChunkCoordIntPair bCoords = b.func_76632_l();
                double newValue = (chunkHashMap.get(aCoords).func_74769_h(INTENSITY) + chunkHashMap.get(bCoords).func_74769_h(INTENSITY)) / 2.0 - SWAP_THRESHOLD / 8.0;
                float split = TecTech.RANDOM.nextFloat();
                chunkHashMap.get(aCoords).func_74780_a(INTENSITY, newValue * (double)split);
                chunkHashMap.get(bCoords).func_74780_a(INTENSITY, newValue * (double)(1.0f - split));
                chunkHashMap.markForTransmissionToClient(aCoords);
                chunkHashMap.markForTransmissionToClient(bCoords);
                this.swapSomething(a, b, newValue);
            }
            this.worldDataArrayList.clear();
        }
        for (Object o : aEvent.world.field_73010_i) {
            if (!(o instanceof EntityPlayer) || ((EntityPlayer)o).field_71075_bZ.field_75098_d || this.getCharge((EntityPlayer)o) == 0.0) continue;
            this.playersWithCharge.add((EntityPlayer)o);
        }
        if (this.playersWithCharge.size() > 0) {
            for (EntityPlayer other : this.playersWithCharge) {
                double fieldOther = this.getCharge(other);
                for (EntityPlayer player : this.playersWithCharge) {
                    if (other == player) break;
                    double field = this.getCharge(player);
                    double absDifference = Math.abs(field - fieldOther);
                    if (absDifference == 0.0 || !(player.func_70068_e((Entity)other) < 1.0)) continue;
                    double avg = (fieldOther + field) / 2.0;
                    if (TecTech.configTecTech.BOOM_ENABLE) {
                        other.field_70170_p.func_72876_a((Entity)other, other.field_70165_t, other.field_70163_u, other.field_70161_v, (float)Math.min(7.82566774929929E-29 * absDifference, 25.0), true);
                        player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, (float)Math.min(7.82566774929929E-29 * absDifference, 25.0), true);
                    }
                    GT_Utility.sendSoundToPlayers((World)other.field_70170_p, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)((int)other.field_70165_t), (int)((int)other.field_70163_u), (int)((int)other.field_70161_v));
                    GT_Utility.sendSoundToPlayers((World)player.field_70170_p, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)((int)player.field_70165_t), (int)((int)player.field_70163_u), (int)((int)player.field_70161_v));
                    this.setCharge(player, avg);
                    this.setCharge(other, avg);
                }
            }
            this.playersWithCharge.clear();
        }
    }

    private void swapSomething(Chunk a, Chunk b, double mass) {
        float explosionPower = (float)Math.log(mass / 6.3892311304012354E28);
        for (int i = 0; i < Math.min((int)explosionPower, 64); ++i) {
            int x = TecTech.RANDOM.nextInt(16);
            int y = TecTech.RANDOM.nextInt(a.field_76637_e.func_72940_L());
            int z = TecTech.RANDOM.nextInt(16);
            Block aBlock = a.func_150810_a(x, y, z);
            Block bBlock = a.func_150810_a(x, y, z);
            int aMeta = a.func_76628_c(x, y, z);
            int bMeta = a.func_76628_c(x, y, z);
            if (a.getTileEntityUnsafe(x, y, z) == null && b.getTileEntityUnsafe(x, y, z) == null) {
                a.field_76637_e.func_147465_d((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z, bBlock, bMeta, 3);
                b.field_76637_e.func_147465_d((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z, aBlock, aMeta, 3);
            } else if (a.getTileEntityUnsafe(x, y, z) == null) {
                b.field_76637_e.func_147465_d((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z, aBlock, aMeta, 3);
                a.field_76637_e.func_147468_f((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z);
            } else if (b.getTileEntityUnsafe(x, y, z) == null) {
                a.field_76637_e.func_147465_d((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z, bBlock, bMeta, 3);
                b.field_76637_e.func_147468_f((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z);
            } else {
                a.field_76637_e.func_147468_f((a.field_76635_g << 4) + x, y, (a.field_76647_h << 4) + z);
                b.field_76637_e.func_147468_f((b.field_76635_g << 4) + x, y, (b.field_76647_h << 4) + z);
            }
            if (!TecTech.configTecTech.BOOM_ENABLE) continue;
            if (TecTech.RANDOM.nextBoolean()) {
                a.field_76637_e.func_72876_a(null, (double)((a.field_76635_g << 4) + x) + 0.5, (double)y + 0.5, (double)((a.field_76647_h << 4) + z) + 0.5, explosionPower * TecTech.RANDOM.nextFloat(), true);
            }
            GT_Utility.sendSoundToPlayers((World)a.field_76637_e, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)((a.field_76635_g << 4) + x), (int)y, (int)((a.field_76647_h << 4) + z));
            if (TecTech.RANDOM.nextBoolean()) {
                b.field_76637_e.func_72876_a(null, (double)((b.field_76635_g << 4) + x) + 0.5, (double)y + 0.5, (double)((b.field_76647_h << 4) + z) + 0.5, explosionPower * TecTech.RANDOM.nextFloat(), true);
            }
            GT_Utility.sendSoundToPlayers((World)b.field_76637_e, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)((b.field_76635_g << 4) + x), (int)y, (int)((b.field_76647_h << 4) + z));
        }
        int x = b.field_76635_g - a.field_76635_g << 4;
        int z = b.field_76635_g - a.field_76635_g << 4;
        List aE = a.field_76637_e.func_72872_a(EntityLivingBase.class, TT_Utility.fromChunk(a));
        List bE = b.field_76637_e.func_72872_a(EntityLivingBase.class, TT_Utility.fromChunk(b));
        for (EntityLivingBase entityLivingBase : aE) {
            if (!TecTech.RANDOM.nextBoolean()) continue;
            if (entityLivingBase instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLivingBase;
                if (player.field_71075_bZ.field_75098_d) continue;
                player.func_70634_a(entityLivingBase.field_70165_t + (double)x, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v + (double)z);
                player.func_70097_a(MainLoader.subspace, (float)(8 + TecTech.RANDOM.nextInt((int)(explosionPower / 4.0f))));
                player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 1200));
                player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 1000));
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 800));
                player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 600));
                player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 400));
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200));
                player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100));
                player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 60));
                this.addCharge(player, -mass * (double)TecTech.RANDOM.nextFloat());
                continue;
            }
            entityLivingBase.func_70634_a(entityLivingBase.field_70165_t + (double)x, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v + (double)z);
            entityLivingBase.func_70097_a(MainLoader.subspace, (float)(8 + TecTech.RANDOM.nextInt((int)(explosionPower / 4.0f))));
        }
        for (EntityLivingBase o : bE) {
            if (!TecTech.RANDOM.nextBoolean()) continue;
            if (o instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)o;
                if (player.field_71075_bZ.field_75098_d) continue;
                player.func_70634_a(o.field_70165_t - (double)x, o.field_70163_u, o.field_70161_v - (double)z);
                player.func_70097_a(MainLoader.subspace, (float)(8 + TecTech.RANDOM.nextInt((int)(-(explosionPower / 4.0f)))));
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 800));
                player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 600));
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 400));
                player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 200));
                player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 100));
                player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 60));
                this.addCharge(player, mass * (double)TecTech.RANDOM.nextFloat());
                continue;
            }
            o.func_70634_a(o.field_70165_t + (double)x, o.field_70163_u, o.field_70161_v + (double)z);
            o.func_70097_a(MainLoader.subspace, (float)(8 + TecTech.RANDOM.nextInt((int)(explosionPower / 4.0f))));
        }
    }

    @Override
    public void tickPlayer(HashMap<Integer, ChunkDataHandler.ChunkHashMap> data, TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isClient()) {
            EntityPlayer player = TecTech.proxy.getPlayer();
            ChunkCoordIntPair pair = new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj);
            NBTTagCompound compound = data.get(player.field_70170_p.field_73011_w.field_76574_g).get(pair);
            if (compound != null) {
                int badness = (int)Math.min(32.0, compound.func_74769_h(INTENSITY) / PER_PARTICLE);
                for (int i = 0; i < badness; ++i) {
                    TecTech.proxy.em_particle(player.field_70170_p, player.field_70165_t + TecTech.RANDOM.nextGaussian() * 64.0, player.field_70163_u + TecTech.RANDOM.nextGaussian() * 64.0, player.field_70161_v + TecTech.RANDOM.nextGaussian() * 64.0);
                }
            }
            for (Map.Entry<ChunkCoordIntPair, NBTTagCompound> entry : data.get(player.field_70170_p.field_73011_w.field_76574_g).entrySet()) {
                ChunkCoordIntPair chunkCoordIntPair = entry.getKey();
                NBTTagCompound dat = entry.getValue();
                if (!(Math.abs((double)chunkCoordIntPair.func_77273_a() - player.field_70165_t) + Math.abs((double)chunkCoordIntPair.func_77274_b() - player.field_70161_v) < 256.0)) continue;
                int pow = (int)Math.min(32.0, dat.func_74769_h(INTENSITY) / PER_PARTICLE);
                for (int i = 0; i < pow; ++i) {
                    TecTech.proxy.em_particle(player.field_70170_p, (double)chunkCoordIntPair.func_77273_a() + TecTech.RANDOM.nextGaussian() * 32.0, player.field_70163_u + (double)TecTech.RANDOM.nextFloat() * 128.0 - 64.0, (double)chunkCoordIntPair.func_77274_b() + TecTech.RANDOM.nextGaussian() * 32.0);
                }
            }
        } else if (TecTech.RANDOM.nextInt(50) == 0) {
            EntityPlayer player = aEvent.player;
            ChunkCoordIntPair pair = new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj);
            NBTTagCompound compound = data.get(player.field_70170_p.field_73011_w.field_76574_g).get(pair);
            NBTTagCompound playerTag = TecTech.playerPersistence.getDataOrSetToNewTag(player);
            boolean saveRequired = false;
            if (!player.field_71075_bZ.field_75098_d) {
                double cancer = this.getCancer(player);
                if (compound != null) {
                    int badness = (int)Math.min(32.0, compound.func_74769_h(INTENSITY) / PER_PARTICLE);
                    if (badness > 0) {
                        playerTag.func_74780_a(SPACE_CANCER, Math.min(2.0, cancer + (double)(9.765625E-4f * (float)badness)));
                        player.func_70097_a(MainLoader.subspace, Math.max(1.0f, (float)badness / 8.0f));
                        saveRequired = true;
                    }
                } else if (playerTag.func_74769_h(SPACE_CANCER) > 0.0 && !player.field_70128_L && player.field_70173_aa % 10 == 0) {
                    playerTag.func_74780_a(SPACE_CANCER, Math.max(0.0, cancer - 7.62939453125E-5));
                    saveRequired = true;
                }
            }
            if (saveRequired) {
                TecTech.playerPersistence.saveData(player);
                NetworkDispatcher.INSTANCE.sendTo(new PlayerDataMessage.PlayerDataData(player), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public void tickRender(HashMap<Integer, ChunkDataHandler.ChunkHashMap> data, TickEvent.RenderTickEvent aEvent) {
        EntityPlayer player = TecTech.proxy.getPlayer();
        if (player != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                double mass;
                double charge;
                double cancer = this.getCancer(player) * 1.565133549859858E-29;
                if (cancer > 0.0) {
                    this.fixMe = (double)(TecTech.RANDOM.nextFloat() * 2.0f) < cancer;
                    player.func_82142_c(this.fixMe);
                    player.func_70082_c((TecTech.RANDOM.nextFloat() - 0.5f) * 36.0f * (float)cancer, (TecTech.RANDOM.nextFloat() - 0.5f) * 36.0f * (float)cancer);
                    cancer *= cancer / 2.0;
                    if (cancer > 1.75) {
                        player.func_70016_h((double)(TecTech.RANDOM.nextFloat() - 0.5f) * cancer, (double)(TecTech.RANDOM.nextFloat() - 0.5f) * cancer, (double)(TecTech.RANDOM.nextFloat() - 0.5f) * cancer);
                    } else {
                        player.func_70024_g((double)(TecTech.RANDOM.nextFloat() - 0.5f) * cancer, (double)(TecTech.RANDOM.nextFloat() - 0.5f) * cancer, (double)(TecTech.RANDOM.nextFloat() - 0.5f) * cancer);
                    }
                }
                if ((charge = this.getCharge(player)) != 0.0) {
                    for (Object o : player.field_70170_p.field_73010_i) {
                        double distanceSq;
                        double reaction;
                        EntityPlayer otherPlayer;
                        double chargeOther;
                        if (!(o instanceof EntityPlayer) || ((EntityPlayer)o).field_71075_bZ.field_75098_d || (chargeOther = this.getCharge(otherPlayer = (EntityPlayer)o)) == 0.0 || player == o || (reaction = chargeOther * charge) == 0.0 || !((distanceSq = otherPlayer.func_70068_e((Entity)player)) >= 1.0)) continue;
                        double effect = 1.565133549859858E-28 * reaction / (distanceSq * distanceSq * distanceSq);
                        double dX = (player.field_70165_t - otherPlayer.field_70165_t) * effect;
                        double dY = (player.field_70163_u - otherPlayer.field_70163_u) * effect;
                        double dZ = (player.field_70161_v - otherPlayer.field_70161_v) * effect;
                        player.func_70024_g(dX, dY, dZ);
                        otherPlayer.func_70024_g(-dX, -dY, -dZ);
                    }
                }
                if ((mass = this.getMass(player)) != 0.0) {
                    for (Object o : player.field_70170_p.field_73010_i) {
                        double distanceSq;
                        double reaction;
                        EntityPlayer otherPlayer;
                        double massOther;
                        if (!(o instanceof EntityPlayer) || ((EntityPlayer)o).field_71075_bZ.field_75098_d || (massOther = this.getMass(otherPlayer = (EntityPlayer)o)) == 0.0 || player == o || (reaction = massOther * mass) == 0.0 || !((distanceSq = otherPlayer.func_70068_e((Entity)player)) >= 1.0)) continue;
                        double effect = 1.565133549859858E-29 * reaction / (distanceSq * distanceSq * distanceSq);
                        double effect1 = effect / mass;
                        double effect2 = effect / massOther;
                        double[] dPos = new double[]{player.field_70165_t - otherPlayer.field_70165_t, player.field_70163_u - otherPlayer.field_70163_u, player.field_70161_v - otherPlayer.field_70161_v};
                        double[] vel = new double[]{player.field_70159_w, player.field_70181_x, player.field_70179_y};
                        double[] out = new double[3];
                        TT_Utility.crossProduct3D(dPos, vel, out);
                        TT_Utility.crossProduct3D(out, dPos, vel);
                        TT_Utility.normalize3D(vel, out);
                        player.func_70024_g(effect1 * out[0], effect1 * out[1], effect1 * out[2]);
                        otherPlayer.func_70024_g(effect2 * -out[0], effect2 * -out[1], effect2 * -out[2]);
                    }
                }
            }
            if (this.fixMe) {
                player.func_82142_c(false);
                this.fixMe = false;
            }
        }
    }

    @Override
    public void pullData(ChunkEvent.Load aEvent) {
        NetworkDispatcher.INSTANCE.sendToServer(new ChunkDataMessage.ChunkDataQuery(aEvent, this));
    }

    @Override
    public void pushData(World world, ChunkCoordIntPair chunk) {
        NetworkDispatcher.INSTANCE.sendToDimension(new ChunkDataMessage.ChunkDataData(world.field_73011_w.field_76574_g, chunk, this), world.field_73011_w.field_76574_g);
    }

    @Override
    public int pushPayloadSpreadPeriod() {
        return 100;
    }

    public void addAnomaly(IGregTechTileEntity gtTile, double amount) {
        this.addAnomaly(gtTile.getWorld(), gtTile.getXCoord(), gtTile.getZCoord(), amount);
    }

    public void addAnomaly(TileEntity tileEntity, double amount) {
        this.addAnomaly(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145849_e, amount);
    }

    public void addAnomaly(World w, int x, int z, double amount) {
        if (!w.field_72995_K) {
            this.addAnomaly(w.field_73011_w.field_76574_g, new ChunkCoordIntPair(x >> 4, z >> 4), amount);
        }
    }

    public void addAnomaly(int world, ChunkCoordIntPair chunk, double amount) {
        NBTTagCompound old = TecTech.chunkDataHandler.getChunkData(this, world, chunk);
        if (old == null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74780_a(INTENSITY, amount);
            TecTech.chunkDataHandler.putChunkData(this, world, chunk, data);
        } else {
            old.func_74780_a(INTENSITY, old.func_74769_h(INTENSITY) + amount);
        }
        TecTech.chunkDataHandler.getChunkData(this, world).markForTransmissionToClient(chunk);
    }

    public double getCharge(EntityPlayer player) {
        return this.getDouble(player, SPACE_CHARGE);
    }

    public void setCharge(EntityPlayer player, double amount) {
        this.setDouble(player, SPACE_CHARGE, amount);
    }

    public void addCharge(EntityPlayer player, double amount) {
        this.addDouble(player, SPACE_CHARGE, amount);
    }

    public double getMass(EntityPlayer player) {
        return this.getDouble(player, SPACE_MASS);
    }

    public void setMass(EntityPlayer player, double amount) {
        this.setDouble(player, SPACE_MASS, amount);
    }

    public void addMass(EntityPlayer player, double amount) {
        this.addDouble(player, SPACE_MASS, amount);
    }

    public double getCancer(EntityPlayer player) {
        return this.getDouble(player, SPACE_CANCER);
    }

    public void setCancer(EntityPlayer player, double amount) {
        this.setDouble(player, SPACE_CANCER, amount);
    }

    public void addCancer(EntityPlayer player, double amount) {
        this.addDouble(player, SPACE_CANCER, amount);
    }

    public double getDouble(EntityPlayer player, String name) {
        return TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74769_h(name);
    }

    public void setDouble(EntityPlayer player, String name, double amount) {
        TecTech.playerPersistence.getDataOrSetToNewTag(player).func_74780_a(name, amount);
        TecTech.playerPersistence.saveData(player);
        NetworkDispatcher.INSTANCE.sendToAll(new PlayerDataMessage.PlayerDataData(player));
    }

    public void addDouble(EntityPlayer player, String name, double amount) {
        NBTTagCompound data = TecTech.playerPersistence.getDataOrSetToNewTag(player);
        data.func_74780_a(name, amount + data.func_74769_h(name));
        TecTech.playerPersistence.saveData(player);
        NetworkDispatcher.INSTANCE.sendToAll(new PlayerDataMessage.PlayerDataData(player));
    }
}

