/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.maps;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapRead;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

abstract class EMStackMap<T extends IEMStack>
implements IEMMapRead<T> {
    private final NavigableMap<IEMDefinition, T> backingMap;

    protected EMStackMap() {
        this(new TreeMap());
    }

    protected EMStackMap(NavigableMap<IEMDefinition, T> map) {
        this.backingMap = map;
    }

    @Override
    public NavigableMap<IEMDefinition, T> getBackingMap() {
        return this.backingMap;
    }

    @Override
    public abstract EMStackMap<T> clone();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IEMMapRead) {
            return this.compareTo((IEMMapRead)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = -(this.size() << 4);
        for (Map.Entry entry : this.entrySet()) {
            hash += ((IEMStack)entry.getValue()).getDefinition().hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(IEMMapRead<? extends IEMStack> o) {
        return IEMMapRead.super.compareTo(o);
    }
}

