/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.definitions.complex;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.EMException;
import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.EMComplexTemplate;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMIndirectType;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMOredictQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.OreDictionaryStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMGaugeBosonDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMQuarkDefinition;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class EMHadronDefinition
extends EMComplexTemplate {
    private final int hash;
    private static final String nbtType = "h";
    public static final Map<EMHadronDefinition, String> SYMBOL_MAP = new HashMap<EMHadronDefinition, String>();
    public static final Map<EMHadronDefinition, String> UNLOCALIZED_NAME_MAP = new HashMap<EMHadronDefinition, String>();
    public static EMHadronDefinition hadron_p;
    public static EMHadronDefinition hadron_n;
    public static EMHadronDefinition hadron_p_;
    public static EMHadronDefinition hadron_n_;
    public static EMDefinitionStack hadron_p1;
    public static EMDefinitionStack hadron_n1;
    public static EMDefinitionStack hadron_p2;
    public static EMDefinitionStack hadron_n2;
    public static EMDefinitionStack hadron_p3;
    public static EMDefinitionStack hadron_n3;
    public static EMDefinitionStack hadron_p5;
    private static double protonMass;
    private static double neutronMass;
    private static final double actualProtonMass = 9.382720813E8;
    private static final double actualNeutronMass = 9.395654133E8;
    private final double mass;
    private final int charge;
    private final double rawLifeTime;
    private final int amount;
    private final byte type;
    private final EMConstantStackMap quarkStacks;

    public EMHadronDefinition(EMDefinitionStack ... quarks) throws EMException {
        this(true, new EMConstantStackMap(quarks));
    }

    private EMHadronDefinition(boolean check, EMDefinitionStack ... quarks) throws EMException {
        this(check, new EMConstantStackMap(quarks));
    }

    public EMHadronDefinition(EMConstantStackMap quarks) throws EMException {
        this(true, quarks);
    }

    private EMHadronDefinition(boolean check, EMConstantStackMap quarks) throws EMException {
        if (check && !EMHadronDefinition.canTheyBeTogether(quarks)) {
            throw new EMException("Hadron Definition error");
        }
        this.quarkStacks = quarks;
        int amount = 0;
        int charge = 0;
        int type = 0;
        boolean containsAnti = false;
        double mass = 0.0;
        for (EMDefinitionStack quarkStack : (EMDefinitionStack[])this.quarkStacks.valuesToArray()) {
            amount = (int)((double)amount + quarkStack.getAmount());
            if ((double)((int)quarkStack.getAmount()) != quarkStack.getAmount()) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            mass += quarkStack.getMass();
            charge = (int)((double)charge + quarkStack.getCharge());
            type = Math.max(Math.abs(quarkStack.getDefinition().getGeneration()), type);
            if (quarkStack.getDefinition().getGeneration() >= 0) continue;
            containsAnti = true;
        }
        this.amount = amount;
        this.charge = charge;
        this.type = containsAnti ? (byte)(-type) : (byte)type;
        long mult = (long)this.getAmount() * (long)this.getAmount() * (long)(this.getAmount() - 1);
        if ((mass = mass * 5.543 * (double)mult) == protonMass && this.getAmount() == 3) {
            this.rawLifeTime = 1.5E36;
            mass = 9.382720813E8;
        } else if (mass == neutronMass && this.getAmount() == 3) {
            this.rawLifeTime = 882.0;
            mass = 9.395654133E8;
        } else {
            this.rawLifeTime = this.getAmount() == 3 ? 1.34 / mass * Math.pow(9.81, charge) : (this.getAmount() == 2 ? 1.21 / mass / Math.pow(19.8, charge) : 1.21 / mass / Math.pow(9.8, charge));
        }
        this.mass = mass;
        this.hash = super.hashCode();
    }

    private static boolean canTheyBeTogether(EMConstantStackMap stacks) {
        long amount = 0L;
        for (EMDefinitionStack quarks : (EMDefinitionStack[])stacks.valuesToArray()) {
            if (!(quarks.getDefinition() instanceof EMQuarkDefinition)) {
                return false;
            }
            if ((double)((int)quarks.getAmount()) != quarks.getAmount()) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            amount = (long)((double)amount + quarks.getAmount());
        }
        return amount >= 2L && amount <= 12L;
    }

    @Override
    public String getShortLocalizedName() {
        StringBuilder name = new StringBuilder();
        String sym = StatCollector.func_74838_a((String)UNLOCALIZED_NAME_MAP.get(this));
        if (sym != null) {
            name.append(' ').append(sym);
        } else {
            for (EMDefinitionStack quark : (EMDefinitionStack[])this.quarkStacks.valuesToArray()) {
                name.append(' ').append(quark.getDefinition().getSymbol()).append((int)quark.getAmount());
            }
        }
        return name.toString();
    }

    @Override
    public String getLocalizedTypeName() {
        switch (this.getAmount()) {
            case 2: {
                return StatCollector.func_74838_a((String)"tt.keyword.Meson");
            }
            case 3: {
                return StatCollector.func_74838_a((String)"tt.keyword.Baryon");
            }
            case 4: {
                return StatCollector.func_74838_a((String)"tt.keyword.Tetraquark");
            }
            case 5: {
                return StatCollector.func_74838_a((String)"tt.keyword.Pentaquark");
            }
            case 6: {
                return StatCollector.func_74838_a((String)"tt.keyword.Hexaquark");
            }
        }
        return StatCollector.func_74838_a((String)"tt.keyword.Hadron");
    }

    @Override
    public String getSymbol() {
        String sym = SYMBOL_MAP.get(this);
        if (sym != null) {
            return sym;
        }
        StringBuilder symbol = new StringBuilder(8);
        for (EMDefinitionStack quark : (EMDefinitionStack[])this.quarkStacks.valuesToArray()) {
            int i = 0;
            while ((double)i < quark.getAmount()) {
                symbol.append(quark.getDefinition().getSymbol());
                ++i;
            }
        }
        return symbol.toString();
    }

    @Override
    public String getShortSymbol() {
        String sym = SYMBOL_MAP.get(this);
        if (sym != null) {
            return sym;
        }
        StringBuilder symbol = new StringBuilder(8);
        for (EMDefinitionStack quark : (EMDefinitionStack[])this.quarkStacks.valuesToArray()) {
            int i = 0;
            while ((double)i < quark.getAmount()) {
                symbol.append(quark.getDefinition().getShortSymbol());
                ++i;
            }
        }
        return symbol.toString();
    }

    @Override
    public int getMaxColors() {
        return -7;
    }

    @Override
    public EMConstantStackMap getSubParticles() {
        return this.quarkStacks;
    }

    @Override
    public EMDecay[] getNaturalDecayInstant() {
        EMDefinitionStack[] quarkStacks = (EMDefinitionStack[])this.quarkStacks.valuesToArray();
        if (this.getAmount() == 2 && quarkStacks.length == 2 && quarkStacks[0].getDefinition().getMass() == quarkStacks[1].getDefinition().getMass() && quarkStacks[0].getDefinition().getGeneration() == -quarkStacks[1].getDefinition().getGeneration()) {
            return EMDecay.NO_PRODUCT;
        }
        ArrayList<EMDefinitionStack> decaysInto = new ArrayList<EMDefinitionStack>();
        for (EMDefinitionStack quarks : quarkStacks) {
            if (quarks.getDefinition().getGeneration() == 1 || quarks.getDefinition().getGeneration() == -1) {
                decaysInto.add(quarks);
                continue;
            }
            decaysInto.add(new EMDefinitionStack(EMGaugeBosonDefinition.boson_Y__, 2.0));
        }
        return new EMDecay[]{new EMDecay(0.75, decaysInto.toArray(new EMDefinitionStack[0])), EMGaugeBosonDefinition.deadEnd};
    }

    @Override
    public EMDecay[] getEnergyInducedDecay(long energyLevel) {
        EMDefinitionStack[] quarkStacks = (EMDefinitionStack[])this.quarkStacks.valuesToArray();
        if (this.getAmount() == 2 && quarkStacks.length == 2 && quarkStacks[0].getDefinition().getMass() == quarkStacks[1].getDefinition().getMass() && quarkStacks[0].getDefinition().getGeneration() == -quarkStacks[1].getDefinition().getGeneration()) {
            return EMDecay.NO_PRODUCT;
        }
        return new EMDecay[]{new EMDecay(0.75, quarkStacks), EMGaugeBosonDefinition.deadEnd};
    }

    @Override
    public double getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return false;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public EMDecay[] getDecayArray() {
        EMDefinitionStack[] quarkStacks = (EMDefinitionStack[])this.quarkStacks.valuesToArray();
        if (this.getAmount() == 2 && quarkStacks.length == 2 && quarkStacks[0].getDefinition().getMass() == quarkStacks[1].getDefinition().getMass() && quarkStacks[0].getDefinition().getGeneration() == -quarkStacks[1].getDefinition().getGeneration()) {
            return EMDecay.NO_PRODUCT;
        }
        if (this.getAmount() != 3) {
            return new EMDecay[]{new EMDecay(0.95, quarkStacks), EMGaugeBosonDefinition.deadEnd};
        }
        ArrayList<EMQuarkDefinition> newBaryon = new ArrayList<EMQuarkDefinition>();
        IEMDefinition[] Particles = new IEMDefinition[2];
        for (EMDefinitionStack quarks : quarkStacks) {
            int i = 0;
            while ((double)i < quarks.getAmount()) {
                newBaryon.add((EMQuarkDefinition)quarks.getDefinition());
                ++i;
            }
        }
        EMQuarkDefinition lastQuark = (EMQuarkDefinition)newBaryon.remove(2);
        EMDefinitionStack[] decay = Math.abs(lastQuark.getGeneration()) > 1 ? (EMDefinitionStack[])lastQuark.getDecayArray()[1].getOutputStacks().valuesToArray() : (EMDefinitionStack[])lastQuark.getDecayArray()[2].getOutputStacks().valuesToArray();
        newBaryon.add((EMQuarkDefinition)decay[0].getDefinition());
        Particles[0] = decay[1].getDefinition();
        Particles[1] = decay[2].getDefinition();
        EMDefinitionStack[] contentOfBaryon = (EMDefinitionStack[])newBaryon.stream().map(eQuarkDefinition -> new EMDefinitionStack((IEMDefinition)eQuarkDefinition, 1.0)).toArray(EMDefinitionStack[]::new);
        try {
            return new EMDecay[]{new EMDecay(0.001, new EMHadronDefinition(false, contentOfBaryon), Particles[0], Particles[1], EMGaugeBosonDefinition.boson_Y__), new EMDecay(0.99, new EMHadronDefinition(false, contentOfBaryon), Particles[0], Particles[1]), EMGaugeBosonDefinition.deadEnd};
        }
        catch (EMException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return new EMDecay[]{EMGaugeBosonDefinition.deadEnd};
        }
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    @Override
    public double getRawTimeSpan(long currentEnergy) {
        return this.getRawLifeTime();
    }

    @Override
    public boolean isTimeSpanHalfLife() {
        return true;
    }

    @Override
    public int getGeneration() {
        return this.type;
    }

    @Override
    public IEMDefinition getAnti() {
        EMDefinitionStackMap anti = new EMDefinitionStackMap();
        for (EMDefinitionStack stack : (EMDefinitionStack[])this.quarkStacks.valuesToArray()) {
            anti.putReplace(new EMDefinitionStack(stack.getDefinition().getAnti(), stack.getAmount()));
        }
        try {
            return new EMHadronDefinition(anti.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
        }
        catch (EMException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    protected String getTagValue() {
        return nbtType;
    }

    public static void run(EMDefinitionsRegistry registry) {
        registry.registerDefinitionClass(nbtType, new EMIndirectType((definitionsRegistry, nbt) -> new EMHadronDefinition(EMConstantStackMap.fromNBT(definitionsRegistry, nbt)), EMHadronDefinition.class, "tt.keyword.Hadron"));
        try {
            hadron_p = new EMHadronDefinition(new EMConstantStackMap(EMQuarkDefinition.quark_u.getStackForm(2.0), EMQuarkDefinition.quark_d.getStackForm(1.0)));
            protonMass = hadron_p.getMass();
            hadron_p = new EMHadronDefinition(new EMConstantStackMap(EMQuarkDefinition.quark_u.getStackForm(2.0), EMQuarkDefinition.quark_d.getStackForm(1.0)));
            SYMBOL_MAP.put(hadron_p, "p");
            UNLOCALIZED_NAME_MAP.put(hadron_p, "tt.keyword.Proton");
            registry.registerForDisplay(hadron_p);
            registry.registerDirectDefinition("p", hadron_p);
            hadron_p_ = (EMHadronDefinition)hadron_p.getAnti();
            SYMBOL_MAP.put(hadron_p_, "~p");
            UNLOCALIZED_NAME_MAP.put(hadron_p_, "tt.keyword.AntiProton");
            registry.registerForDisplay(hadron_p_);
            registry.registerDirectDefinition("~p", hadron_p_);
            hadron_n = new EMHadronDefinition(new EMConstantStackMap(EMQuarkDefinition.quark_u.getStackForm(1.0), EMQuarkDefinition.quark_d.getStackForm(2.0)));
            neutronMass = hadron_n.getMass();
            hadron_n = new EMHadronDefinition(new EMConstantStackMap(EMQuarkDefinition.quark_u.getStackForm(1.0), EMQuarkDefinition.quark_d.getStackForm(2.0)));
            SYMBOL_MAP.put(hadron_n, "n");
            UNLOCALIZED_NAME_MAP.put(hadron_n, "tt.keyword.Neutron");
            registry.registerForDisplay(hadron_n);
            registry.registerDirectDefinition("n", hadron_n);
            hadron_n_ = (EMHadronDefinition)hadron_n.getAnti();
            SYMBOL_MAP.put(hadron_n_, "~n");
            UNLOCALIZED_NAME_MAP.put(hadron_n_, "tt.keyword.AntiNeutron");
            registry.registerForDisplay(hadron_n_);
            registry.registerDirectDefinition("~n", hadron_n_);
            TecTech.LOGGER.info((Object)("Old Neutron Mass: " + neutronMass));
            TecTech.LOGGER.info((Object)("Old Proton Mass: " + protonMass));
            TecTech.LOGGER.info((Object)("New Neutron Mass: " + hadron_n.getMass()));
            TecTech.LOGGER.info((Object)("New Proton Mass: " + hadron_p.getMass()));
        }
        catch (EMException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            protonMass = -1.0;
            neutronMass = -1.0;
        }
        hadron_p1 = new EMDefinitionStack(hadron_p, 1.0);
        hadron_n1 = new EMDefinitionStack(hadron_n, 1.0);
        hadron_p2 = new EMDefinitionStack(hadron_p, 2.0);
        hadron_n2 = new EMDefinitionStack(hadron_n, 2.0);
        hadron_p3 = new EMDefinitionStack(hadron_p, 3.0);
        hadron_n3 = new EMDefinitionStack(hadron_n, 3.0);
        hadron_p5 = new EMDefinitionStack(hadron_p, 5.0);
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)("Registered Elemental Matter Class: Hadron h " + EMHadronDefinition.getClassTypeStatic()));
        }
    }

    public static void setTransformations(EMTransformationRegistry transformationInfo) {
        EMDefinitionStack neutrons = new EMDefinitionStack(hadron_n, 1000.0 * EMTransformationRegistry.EM_COUNT_PER_MATERIAL_AMOUNT_DIMINISHED);
        EMDequantizationInfo emDequantizationInfo = new EMDequantizationInfo(neutrons);
        emDequantizationInfo.setOre(new OreDictionaryStack(1, OreDictionary.getOreID((String)(OrePrefixes.dust.name() + Materials.Neutronium.mName))));
        transformationInfo.getInfoMap().put(neutrons.getDefinition(), emDequantizationInfo);
        transformationInfo.getOredictQuantization().put(OreDictionary.getOreID((String)(OrePrefixes.ingotHot.name() + Materials.Neutronium.mName)), new EMOredictQuantizationInfo(OrePrefixes.ingotHot, Materials.Neutronium, 1, (IEMStack)neutrons));
    }

    @Override
    public int getMatterMassType() {
        return EMHadronDefinition.getClassTypeStatic();
    }

    public static int getClassTypeStatic() {
        return -64;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    public double getRawLifeTime() {
        return this.rawLifeTime;
    }

    public int getAmount() {
        return this.amount;
    }

    static {
        protonMass = 0.0;
        neutronMass = 0.0;
    }
}

