/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.EMPrimalAspectDefinition;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.transformations.AspectDefinitionCompat;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.EMException;
import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.EMComplexTemplate;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMIndirectType;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMGaugeBosonDefinition;
import net.minecraft.util.StatCollector;

public final class EMComplexAspectDefinition
extends EMComplexTemplate {
    private final int hash;
    private final double mass;
    private static final String nbtType = "`";
    private final EMConstantStackMap aspectStacks;

    public EMComplexAspectDefinition(EMDefinitionStack ... aspects) throws EMException {
        this(true, new EMConstantStackMap(aspects));
    }

    private EMComplexAspectDefinition(boolean check, EMDefinitionStack ... aspects) throws EMException {
        this(check, new EMConstantStackMap(aspects));
    }

    public EMComplexAspectDefinition(EMConstantStackMap aspects) throws EMException {
        this(true, aspects);
    }

    private EMComplexAspectDefinition(boolean check, EMConstantStackMap aspects) throws EMException {
        if (check && !EMComplexAspectDefinition.canTheyBeTogether(aspects)) {
            throw new EMException("Complex Aspect Definition error");
        }
        this.aspectStacks = aspects;
        float mass = 0.0f;
        for (EMDefinitionStack stack : (EMDefinitionStack[])aspects.valuesToArray()) {
            mass = (float)((double)mass + stack.getMass());
        }
        this.mass = mass;
        this.hash = super.hashCode();
    }

    private static boolean canTheyBeTogether(EMConstantStackMap stacks) {
        long amount = 0L;
        for (EMDefinitionStack aspects : (EMDefinitionStack[])stacks.valuesToArray()) {
            if (!(aspects.getDefinition() instanceof EMComplexAspectDefinition) && !(aspects.getDefinition() instanceof EMPrimalAspectDefinition)) {
                return false;
            }
            if ((double)((int)aspects.getAmount()) != aspects.getAmount()) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            amount = (long)((double)amount + aspects.getAmount());
        }
        return amount == 2L;
    }

    @Override
    public String getLocalizedTypeName() {
        return StatCollector.func_74838_a((String)"tt.keyword.Aspect");
    }

    @Override
    public String getShortLocalizedName() {
        String name = AspectDefinitionCompat.aspectDefinitionCompat.getAspectLocalizedName(this);
        if (name != null) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return this.getSymbol();
    }

    @Override
    public String getSymbol() {
        StringBuilder symbol = new StringBuilder(8);
        for (EMDefinitionStack aspect : (EMDefinitionStack[])this.aspectStacks.valuesToArray()) {
            int i;
            if (aspect.getDefinition() instanceof EMPrimalAspectDefinition) {
                i = 0;
                while ((double)i < aspect.getAmount()) {
                    symbol.append(aspect.getDefinition().getSymbol());
                    ++i;
                }
                continue;
            }
            symbol.append('(');
            i = 0;
            while ((double)i < aspect.getAmount()) {
                symbol.append(aspect.getDefinition().getSymbol());
                ++i;
            }
            symbol.append(')');
        }
        return symbol.toString();
    }

    @Override
    public String getShortSymbol() {
        StringBuilder symbol = new StringBuilder(8);
        for (EMDefinitionStack aspect : (EMDefinitionStack[])this.aspectStacks.valuesToArray()) {
            int i;
            if (aspect.getDefinition() instanceof EMPrimalAspectDefinition) {
                i = 0;
                while ((double)i < aspect.getAmount()) {
                    symbol.append(aspect.getDefinition().getShortSymbol());
                    ++i;
                }
                continue;
            }
            symbol.append('(');
            i = 0;
            while ((double)i < aspect.getAmount()) {
                symbol.append(aspect.getDefinition().getShortSymbol());
                ++i;
            }
            symbol.append(')');
        }
        return symbol.toString();
    }

    @Override
    protected String getTagValue() {
        return nbtType;
    }

    @Override
    public double getRawTimeSpan(long currentEnergy) {
        return -1.0;
    }

    @Override
    public boolean isTimeSpanHalfLife() {
        return false;
    }

    @Override
    public int getCharge() {
        return 0;
    }

    @Override
    public int getGeneration() {
        return 0;
    }

    @Override
    public int getMaxColors() {
        return -1;
    }

    @Override
    public EMConstantStackMap getSubParticles() {
        return this.aspectStacks;
    }

    @Override
    public EMDecay[] getEnergyInducedDecay(long energyLevel) {
        return new EMDecay[]{new EMDecay(0.75, this.aspectStacks), EMGaugeBosonDefinition.deadEnd};
    }

    @Override
    public double getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return false;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public EMDecay[] getNaturalDecayInstant() {
        return EMDecay.NO_DECAY;
    }

    @Override
    public EMDecay[] getDecayArray() {
        return EMDecay.NO_DECAY;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public IEMDefinition getAnti() {
        return null;
    }

    public static void run(EMDefinitionsRegistry registry) {
        registry.registerDefinitionClass(nbtType, new EMIndirectType((definitionsRegistry, nbt) -> new EMComplexAspectDefinition(EMConstantStackMap.fromNBT(definitionsRegistry, nbt)), EMComplexAspectDefinition.class, "tt.keyword.Aspect"));
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)("Registered Elemental Matter Class: ComplexAspect ` " + EMComplexAspectDefinition.getClassTypeStatic()));
        }
    }

    @Override
    public int getMatterMassType() {
        return EMComplexAspectDefinition.getClassTypeStatic();
    }

    public static int getClassTypeStatic() {
        return -96;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }
}

