/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.stacks;

import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.IEMDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import net.minecraft.nbt.NBTTagCompound;

public interface IEMStack
extends Comparable<IEMStack>,
Cloneable {
    public static boolean isValidAmount(double amount) {
        return amount >= 1.2076647761264339E-32;
    }

    public static boolean isInvalidAmount(double amount) {
        return amount < 1.2076647761264339E-32;
    }

    default public boolean isValidAmount() {
        return IEMStack.isValidAmount(this.getAmount());
    }

    default public boolean isInvalidAmount() {
        return IEMStack.isInvalidAmount(this.getAmount());
    }

    public IEMDefinition getDefinition();

    public double getAmount();

    default public double getCharge() {
        return (double)this.getDefinition().getCharge() * this.getAmount();
    }

    default public double getMass() {
        return this.getDefinition().getMass() * this.getAmount();
    }

    public IEMStack clone();

    public IEMStack mutateAmount(double var1);

    public NBTTagCompound toNBT(EMDefinitionsRegistry var1);

    @Override
    default public int compareTo(IEMStack o) {
        return this.getDefinition().compareTo(o.getDefinition());
    }
}

