/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules;

import com.github.technus.tectech.loader.recipe.Godforge;
import com.github.technus.tectech.recipe.TecTechRecipeMaps;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.thing.metaTileEntity.multi.godforge_modules.GT_MetaTileEntity_EM_BaseModule;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.GodforgeMath;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBuilder;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GT_MetaTileEntity_EM_ExoticModule
extends GT_MetaTileEntity_EM_BaseModule {
    private int numberOfFluids = 0;
    private int numberOfItems = 0;
    private int currentParallel = 0;
    private long wirelessEUt = 0L;
    private long EUt = 0L;
    private boolean recipeInProgress = false;
    private boolean magmatterCapable = true;
    private boolean magmatterMode = false;
    private FluidStack[] randomizedFluidInput = new FluidStack[0];
    private ItemStack[] randomizedItemInput = new ItemStack[0];
    List<FluidStack> inputPlasmas = new ArrayList<FluidStack>();
    private GT_Recipe plasmaRecipe = null;
    private static RecipeMap<RecipeMapBackend> tempRecipeMap = RecipeMapBuilder.of((String)"bye").maxIO(0, 0, 7, 2).disableRegisterNEI().build();
    private static final RecipeMap<RecipeMapBackend> emptyRecipeMap = RecipeMapBuilder.of((String)"hey").maxIO(0, 0, 7, 2).disableRegisterNEI().build();
    private static final int NUMBER_OF_INPUTS = 7;

    public GT_MetaTileEntity_EM_ExoticModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_ExoticModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_ExoticModule(this.mName);
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected Stream<GT_Recipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                if (!GT_MetaTileEntity_EM_ExoticModule.this.recipeInProgress) {
                    HashMap<FluidStack, Integer> fluidMap = Godforge.exoticModulePlasmaFluidMap;
                    HashMap<ItemStack, Integer> itemMap = Godforge.exoticModulePlasmaItemMap;
                    FluidStack outputFluid = MaterialsUEVplus.QuarkGluonPlasma.getFluid(1000L);
                    if (GT_MetaTileEntity_EM_ExoticModule.this.magmatterMode) {
                        fluidMap = Godforge.exoticModuleMagmatterFluidMap;
                        itemMap = Godforge.exoticModuleMagmatterItemMap;
                        outputFluid = MaterialsUEVplus.MagMatter.getMolten(144L);
                    }
                    tempRecipeMap = emptyRecipeMap;
                    GT_MetaTileEntity_EM_ExoticModule.this.numberOfFluids = GodforgeMath.getRandomIntInRange(0, 7);
                    GT_MetaTileEntity_EM_ExoticModule.this.numberOfItems = 7 - GT_MetaTileEntity_EM_ExoticModule.this.numberOfFluids;
                    GT_MetaTileEntity_EM_ExoticModule.access$602(GT_MetaTileEntity_EM_ExoticModule.this, GT_MetaTileEntity_EM_ExoticModule.this.getRandomFluidInputs(fluidMap, GT_MetaTileEntity_EM_ExoticModule.this.numberOfFluids));
                    GT_MetaTileEntity_EM_ExoticModule.access$802(GT_MetaTileEntity_EM_ExoticModule.this, GT_MetaTileEntity_EM_ExoticModule.this.getRandomItemInputs(itemMap, GT_MetaTileEntity_EM_ExoticModule.this.numberOfItems));
                    if (GT_MetaTileEntity_EM_ExoticModule.this.numberOfFluids != 0) {
                        for (FluidStack fluidStack : GT_MetaTileEntity_EM_ExoticModule.this.randomizedFluidInput) {
                            fluidStack.amount = 1000 * GodforgeMath.getRandomIntInRange(1, 64);
                        }
                    }
                    if (GT_MetaTileEntity_EM_ExoticModule.this.numberOfItems != 0) {
                        for (FluidStack fluidStack : GT_MetaTileEntity_EM_ExoticModule.this.randomizedItemInput) {
                            fluidStack.field_77994_a = GodforgeMath.getRandomIntInRange(1, 64);
                        }
                    }
                    GT_MetaTileEntity_EM_ExoticModule.this.inputPlasmas = new ArrayList<FluidStack>(Arrays.asList(GT_MetaTileEntity_EM_ExoticModule.this.convertItemToPlasma(GT_MetaTileEntity_EM_ExoticModule.this.randomizedItemInput, 1L)));
                    GT_MetaTileEntity_EM_ExoticModule.this.inputPlasmas.addAll(Arrays.asList(GT_MetaTileEntity_EM_ExoticModule.this.convertFluidToPlasma(GT_MetaTileEntity_EM_ExoticModule.this.randomizedFluidInput, 1L)));
                    GT_MetaTileEntity_EM_ExoticModule.this.plasmaRecipe = new GT_Recipe(false, null, null, null, null, GT_MetaTileEntity_EM_ExoticModule.this.inputPlasmas.toArray(new FluidStack[0]), new FluidStack[]{outputFluid}, 200, (int)TierEU.RECIPE_MAX, 0);
                    tempRecipeMap.add(GT_MetaTileEntity_EM_ExoticModule.this.plasmaRecipe);
                }
                return tempRecipeMap.getAllRecipes().parallelStream();
            }

            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                if (!GT_MetaTileEntity_EM_ExoticModule.this.recipeInProgress) {
                    this.maxParallel = 1;
                    GT_MetaTileEntity_EM_ExoticModule.this.wirelessEUt = (long)recipe.mEUt * (long)this.maxParallel;
                    if (WirelessNetworkManager.getUserEU((UUID)GT_MetaTileEntity_EM_ExoticModule.this.userUUID).compareTo(BigInteger.valueOf(GT_MetaTileEntity_EM_ExoticModule.this.wirelessEUt * (long)recipe.mDuration)) < 0) {
                        tempRecipeMap = emptyRecipeMap;
                        return CheckRecipeResultRegistry.insufficientPower((long)(GT_MetaTileEntity_EM_ExoticModule.this.wirelessEUt * (long)recipe.mDuration));
                    }
                    if (GT_MetaTileEntity_EM_ExoticModule.this.numberOfFluids != 0) {
                        for (FluidStack fluidStack : GT_MetaTileEntity_EM_ExoticModule.this.randomizedFluidInput) {
                            GT_MetaTileEntity_EM_ExoticModule.dumpFluid((List)GT_MetaTileEntity_EM_ExoticModule.this.mOutputHatches, (FluidStack)new FluidStack(fluidStack.getFluid(), fluidStack.amount / 1000), (boolean)false);
                        }
                    }
                    if (GT_MetaTileEntity_EM_ExoticModule.this.numberOfItems != 0) {
                        for (FluidStack fluidStack : GT_MetaTileEntity_EM_ExoticModule.this.randomizedItemInput) {
                            GT_MetaTileEntity_EM_ExoticModule.this.addOutput((ItemStack)fluidStack);
                        }
                    }
                    GT_MetaTileEntity_EM_ExoticModule.this.recipeInProgress = true;
                }
                if (new HashSet<FluidStack>(Arrays.asList(this.inputFluids)).containsAll(GT_MetaTileEntity_EM_ExoticModule.this.inputPlasmas)) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                return SimpleCheckRecipeResult.ofFailure((String)"waiting_for_inputs");
            }

            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GT_Recipe recipe) {
                GT_MetaTileEntity_EM_ExoticModule.this.wirelessEUt = (long)recipe.mEUt * (long)this.maxParallel;
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)GT_MetaTileEntity_EM_ExoticModule.this.userUUID, (long)(-this.calculatedEut * (long)this.duration))) {
                    return CheckRecipeResultRegistry.insufficientPower((long)(GT_MetaTileEntity_EM_ExoticModule.this.wirelessEUt * (long)recipe.mDuration));
                }
                GT_MetaTileEntity_EM_ExoticModule.this.currentParallel = this.calculatedParallels;
                GT_MetaTileEntity_EM_ExoticModule.this.EUt = this.calculatedEut;
                this.setCalculatedEut(0L);
                tempRecipeMap = emptyRecipeMap;
                GT_MetaTileEntity_EM_ExoticModule.this.recipeInProgress = false;
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(TierEU.MAX).setNoOverclock(true);
            }
        };
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1024), new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1024)};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.godforgeExoticMatterRecipes;
    }

    /*
     * WARNING - void declaration
     */
    private FluidStack[] getRandomFluidInputs(HashMap<FluidStack, Integer> fluidMap, int numberOfFluids) {
        void var7_9;
        int cumulativeWeight = 0;
        ArrayList<Map.Entry<FluidStack, Integer>> fluidEntryList = new ArrayList<Map.Entry<FluidStack, Integer>>(fluidMap.entrySet());
        ArrayList<Integer> cumulativeWeights = new ArrayList<Integer>();
        for (Map.Entry entry : fluidEntryList) {
            cumulativeWeights.add(cumulativeWeight += ((Integer)entry.getValue()).intValue());
        }
        ArrayList<FluidStack> pickedFluids = new ArrayList<FluidStack>();
        boolean bl = false;
        while (var7_9 < numberOfFluids) {
            int randomWeight = GodforgeMath.getRandomIntInRange(1, cumulativeWeight);
            for (int j = 0; j < cumulativeWeights.size(); ++j) {
                if (randomWeight > (Integer)cumulativeWeights.get(j)) continue;
                FluidStack pickedFluid = (FluidStack)((Map.Entry)fluidEntryList.get(j)).getKey();
                if (pickedFluids.contains(pickedFluid)) {
                    --var7_9;
                    break;
                }
                pickedFluids.add(pickedFluid);
                break;
            }
            ++var7_9;
        }
        return pickedFluids.toArray(new FluidStack[0]);
    }

    /*
     * WARNING - void declaration
     */
    private ItemStack[] getRandomItemInputs(HashMap<ItemStack, Integer> itemMap, int numberOfItems) {
        void var7_9;
        int cumulativeWeight = 0;
        ArrayList<Map.Entry<ItemStack, Integer>> itemEntryList = new ArrayList<Map.Entry<ItemStack, Integer>>(itemMap.entrySet());
        ArrayList<Integer> cumulativeWeights = new ArrayList<Integer>();
        for (Map.Entry entry : itemEntryList) {
            cumulativeWeights.add(cumulativeWeight += ((Integer)entry.getValue()).intValue());
        }
        ArrayList<ItemStack> pickedItems = new ArrayList<ItemStack>();
        boolean bl = false;
        while (var7_9 < numberOfItems) {
            int randomWeight = GodforgeMath.getRandomIntInRange(1, cumulativeWeight);
            for (int j = 0; j < cumulativeWeights.size(); ++j) {
                if (randomWeight > (Integer)cumulativeWeights.get(j)) continue;
                ItemStack pickedItem = (ItemStack)((Map.Entry)itemEntryList.get(j)).getKey();
                if (pickedItems.contains(pickedItem)) {
                    --var7_9;
                    break;
                }
                pickedItems.add(pickedItem);
                break;
            }
            ++var7_9;
        }
        return pickedItems.toArray(new ItemStack[0]);
    }

    private FluidStack[] convertItemToPlasma(ItemStack[] items, long multiplier) {
        ArrayList<FluidStack> plasmas = new ArrayList<FluidStack>();
        for (ItemStack itemStack : items) {
            String dict = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)itemStack)[0]);
            String strippedOreDict = dict.substring(8);
            plasmas.add(FluidRegistry.getFluidStack((String)("plasma." + strippedOreDict.toLowerCase()), (int)((int)(144L * multiplier * (long)itemStack.field_77994_a))));
        }
        return plasmas.toArray(new FluidStack[0]);
    }

    private FluidStack[] convertFluidToPlasma(FluidStack[] fluids, long multiplier) {
        ArrayList<FluidStack> plasmas = new ArrayList<FluidStack>();
        for (FluidStack fluidStack : fluids) {
            String[] fluidName = fluidStack.getUnlocalizedName().split("\\.");
            plasmas.add(FluidRegistry.getFluidStack((String)("plasma." + fluidName[fluidName.length - 1]), (int)((int)(multiplier * (long)fluidStack.amount))));
        }
        return plasmas.toArray(new FluidStack[0]);
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound NBT2) {
        NBT2.func_74757_a("recipeInProgress", this.recipeInProgress);
        NBT2.func_74757_a("magmatterMode", this.magmatterMode);
        NBTTagCompound fluidStackListNBTTag = new NBTTagCompound();
        fluidStackListNBTTag.func_74772_a("numberOfPlasmas", (long)this.inputPlasmas.size());
        int indexFluids = 0;
        for (FluidStack fluidStack : this.inputPlasmas) {
            fluidStackListNBTTag.func_74772_a(indexFluids + "fluidAmount", (long)fluidStack.amount);
            NBT2.func_74782_a(indexFluids + "fluidStack", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            ++indexFluids;
        }
        NBT2.func_74782_a("inputPlasmas", (NBTBase)fluidStackListNBTTag);
        super.saveNBTData(NBT2);
    }

    @Override
    public void loadNBTData(NBTTagCompound NBT2) {
        this.recipeInProgress = NBT2.func_74767_n("recipeInProgress");
        this.magmatterMode = NBT2.func_74767_n("magmatterMode");
        NBTTagCompound tempFluidTag = NBT2.func_74775_l("inputPlasmas");
        int indexFluids = 0;
        while ((long)indexFluids < tempFluidTag.func_74763_f("numberOfPlasmas")) {
            int fluidAmount = tempFluidTag.func_74762_e(indexFluids + "fluidAmount");
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)NBT2.func_74775_l(indexFluids + "fluidStack"));
            this.inputPlasmas.add(new FluidStack(fluidStack, fluidAmount));
            ++indexFluids;
        }
        FluidStack outputFluid = MaterialsUEVplus.QuarkGluonPlasma.getFluid(1000L);
        if (this.magmatterMode) {
            outputFluid = MaterialsUEVplus.MagMatter.getMolten(144L);
        }
        tempRecipeMap.add(new GT_Recipe(false, null, null, null, null, this.inputPlasmas.toArray(new FluidStack[0]), new FluidStack[]{outputFluid}, 200, (int)TierEU.RECIPE_MAX, 0));
        super.loadNBTData(NBT2);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)this.magmatterSwitch((IWidgetBuilder<?>)builder));
    }

    protected ButtonWidget magmatterSwitch(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.magmatterCapable) {
                this.magmatterMode = !this.magmatterMode;
            }
        }).setPlayClickSound(this.isMagmatterModeOn()).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.isMagmatterModeOn()) {
                ret.add(GT_UITextures.BUTTON_STANDARD_PRESSED);
                if (this.magmatterCapable) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_CHECKMARK);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_DISABLE);
                }
            } else {
                ret.add(GT_UITextures.BUTTON_STANDARD);
                if (this.magmatterCapable) {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_CROSS);
                } else {
                    ret.add(GT_UITextures.OVERLAY_BUTTON_DISABLE);
                }
            }
            if (!this.magmatterCapable) {
                ret.add(GT_UITextures.OVERLAY_BUTTON_DISABLE);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isMagmatterModeOn, this::setMagmatterMode), builder).addTooltip(StatCollector.func_74838_a((String)"fog.button.magmattermode.tooltip.01")).setTooltipShowUpDelay(5).setPos(174, 91).setSize(16, 16);
        if (!this.magmatterCapable) {
            button.addTooltip(StatCollector.func_74838_a((String)"fog.button.magmattermode.tooltip.02"));
        }
        return (ButtonWidget)button;
    }

    private boolean isMagmatterModeOn() {
        return this.magmatterMode;
    }

    private void setMagmatterMode(boolean enabled) {
        this.magmatterMode = enabled;
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Quark Gluon Plasma Module").addInfo("Controller block of the Quark Gluon Plasma Module").addInfo("Uses a Star to to turn Items into Quark Gluon Plasma").addSeparator().beginStructureBlock(1, 4, 2, false).addEnergyHatch("Any Infinite Spacetime Casing", new int[]{1}).addMaintenanceHatch("Any Infinite Spacetime Casing", new int[]{1}).toolTipFinisher(CommonValues.TEC_MARK_EM);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add("Progress: " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s");
        str.add("Currently using: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.EUt) + EnumChatFormatting.RESET + " EU/t");
        str.add(EnumChatFormatting.YELLOW + "Max Parallel: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.getMaxParallel().intValue()));
        str.add(EnumChatFormatting.YELLOW + "Current Parallel: " + EnumChatFormatting.RESET + GT_Utility.formatNumbers((long)this.currentParallel));
        return str.toArray(new String[0]);
    }

    static /* synthetic */ FluidStack[] access$602(GT_MetaTileEntity_EM_ExoticModule x0, FluidStack[] x1) {
        x0.randomizedFluidInput = x1;
        return x1;
    }

    static /* synthetic */ ItemStack[] access$802(GT_MetaTileEntity_EM_ExoticModule x0, ItemStack[] x1) {
        x0.randomizedItemInput = x1;
        return x1;
    }
}

