/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.client;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import ru.timeconqueror.tcneiadditions.TCNEIAdditions;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.common.lib.crafting.ArcaneSceptreRecipe;
import thaumcraft.common.lib.crafting.ArcaneWandRecipe;

public class TCNAClient {
    public static final int NEI_TEXT_COLOR = 0x404040;
    public static final int NEI_RECIPE_HEIGHT = 65;
    public static final int NEI_GUI_WIDTH = 166;
    public static final int NEI_GUI_HEIGHT = 131;
    private static final TCNAClient instance = new TCNAClient();
    private final Queue<FutureTask<?>> tasks = Queues.newArrayDeque();
    private Boolean wandRecipesDeleted = null;

    public static TCNAClient getInstance() {
        return instance;
    }

    @SubscribeEvent
    public void onPlayerEntered(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.wandRecipesDeleted = true;
        for (Object craftingRecipe : ThaumcraftApi.getCraftingRecipes()) {
            if (!(craftingRecipe instanceof ArcaneWandRecipe) && !(craftingRecipe instanceof ArcaneSceptreRecipe)) continue;
            this.wandRecipesDeleted = false;
            break;
        }
        if (this.wandRecipesDeleted.booleanValue()) {
            TCNEIAdditions.LOGGER.info("Detected removing of ArcaneWandRecipe and ArcaneSceptreRecipe by another mod. Applying NEI Wand Recipe searching by ShapedArcaneRecipes...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Queue<FutureTask<?>> queue = this.tasks;
            synchronized (queue) {
                while (!this.tasks.isEmpty()) {
                    FutureTask<?> task = this.tasks.poll();
                    task.run();
                    try {
                        task.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Object> addScheduledTask(@NotNull Runnable runnable) {
        Callable<Object> callable = Executors.callable(runnable);
        if (!this.isMainThread()) {
            ListenableFutureTask futureTask = ListenableFutureTask.create(callable);
            Queue<FutureTask<?>> queue = this.tasks;
            synchronized (queue) {
                this.tasks.add((FutureTask<?>)futureTask);
                return futureTask;
            }
        }
        try {
            return Futures.immediateFuture((Object)callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public boolean isMainThread() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    public boolean areWandRecipesDeleted() {
        return this.wandRecipesDeleted;
    }
}

