/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei.arcaneworkbench;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.ArcaneShapedRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;
import ru.timeconqueror.tcneiadditions.nei.arcaneworkbench.IArcaneOverlayProvider;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ArcaneCraftingShapedHandler
extends ArcaneShapedRecipeHandler {
    private String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)result.func_77973_b();
            WandRod rod = wand.getRod(result);
            WandCap cap = wand.getCap(result);
            if ((!wand.isSceptre(result) || ThaumcraftApiHelper.isResearchComplete((String)this.userName, (String)"SCEPTRE")) && ThaumcraftApiHelper.isResearchComplete((String)this.userName, (String)cap.getResearch()) && ThaumcraftApiHelper.isResearchComplete((String)this.userName, (String)rod.getResearch())) {
                if (!TCNAClient.getInstance().areWandRecipesDeleted()) {
                    ArcaneWandCachedRecipe recipe = new ArcaneWandCachedRecipe(rod, cap, result, wand.isSceptre(result));
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                    this.aspectsAmount.add(NEIHelper.getWandAspectsWandCost((ItemStack)result));
                }
                this.loadShapedRecipesForWands(result);
            }
        } else {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                ShapedArcaneRecipe shapedArcaneRecipe;
                ArcaneShapedCachedRecipe recipe;
                if (!(o instanceof ShapedArcaneRecipe) || !(recipe = new ArcaneShapedCachedRecipe(shapedArcaneRecipe = (ShapedArcaneRecipe)o)).isValid() || !ThaumcraftApiHelper.isResearchComplete((String)this.userName, (String)shapedArcaneRecipe.getResearch()) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)shapedArcaneRecipe.getRecipeOutput(), (ItemStack)result)) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)shapedArcaneRecipe));
            }
        }
    }

    public void loadShapedRecipesForWands(ItemStack wandStack) {
        if (!(wandStack.func_77973_b() instanceof ItemWandCasting)) {
            throw new RuntimeException("This method works only for Thaumcraft Wands! Provided: " + wandStack);
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        WandRod rod = wand.getRod(wandStack);
        WandCap cap = wand.getCap(wandStack);
        boolean isSceptre = wand.isSceptre(wandStack);
        ThaumcraftApi.getCraftingRecipes().stream().filter(o -> o instanceof ShapedArcaneRecipe && ThaumcraftApiHelper.isResearchComplete((String)this.userName, (String)((ShapedArcaneRecipe)o).getResearch())).filter(r -> {
            ItemStack output = ((ShapedArcaneRecipe)r).output;
            if (!(output.func_77973_b() instanceof ItemWandCasting)) {
                return false;
            }
            if (isSceptre != wand.isSceptre(output)) {
                return false;
            }
            if (output.func_77973_b().getClass() != wandStack.func_77973_b().getClass()) {
                return false;
            }
            WandRod outputRod = wand.getRod(output);
            WandCap outputCap = wand.getCap(output);
            return outputRod.getTag().equals(rod.getTag()) && outputCap.getTag().equals(cap.getTag());
        }).forEach(o -> {
            ShapedArcaneRecipe arcaneRecipe = (ShapedArcaneRecipe)o;
            ArcaneShapedCachedRecipe recipe = new ArcaneShapedCachedRecipe(arcaneRecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)arcaneRecipe));
        });
    }

    public List<PositionedStack> getIngredientStacksForOverlay(int recipeIndex) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        return recipe instanceof IArcaneOverlayProvider ? ((IArcaneOverlayProvider)recipe).getPositionedStacksForOverlay() : null;
    }

    private class ArcaneWandCachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe
    implements IArcaneOverlayProvider {
        protected AspectList aspects;
        protected Object[] overlay;

        public ArcaneWandCachedRecipe(WandRod rod, WandCap cap, ItemStack result, boolean isScepter) {
            super((ShapedRecipeHandler)ArcaneCraftingShapedHandler.this, 3, 3, isScepter ? NEIHelper.buildScepterInput((WandRod)rod, (WandCap)cap) : NEIHelper.buildWandInput((WandRod)rod, (WandCap)cap), result);
            this.overlay = isScepter ? NEIHelper.buildScepterInput((WandRod)rod, (WandCap)cap) : NEIHelper.buildWandInput((WandRod)rod, (WandCap)cap);
            this.result = new PositionedStack((Object)result, 74, 2);
            this.aspects = NEIHelper.getPrimalAspectListFromAmounts((int[])NEIHelper.getWandAspectsWandCost((ItemStack)result));
            NEIHelper.addAspectsToIngredients((AspectList)this.aspects, (List)this.ingredients, (int)0);
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int[][] positions = new int[][]{{48, 32}, {75, 33}, {103, 33}, {49, 60}, {76, 60}, {103, 60}, {49, 87}, {76, 87}, {103, 87}};
                int[][] positions2 = new int[][]{{48, 32}, {75, 33}, {49, 60}, {76, 60}};
                int shiftX = 0;
                int shiftY = 0;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        Object object = items[y * width + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && !(object instanceof List) || object instanceof List && ((List)object).isEmpty()) continue;
                        if (width == 2 && height == 2) {
                            positions = positions2;
                        }
                        PositionedStack stack = new PositionedStack(object, positions[y * width + x][0] + shiftX, positions[y * width + x][1] + shiftY, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        Object object = this.overlay[y * 3 + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                        stacks.add(new PositionedStack(object, 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }
    }

    private class ArcaneShapedCachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe
    implements IArcaneOverlayProvider {
        protected AspectList aspects;
        protected Object[] overlay;
        protected int width;
        protected int height;

        public ArcaneShapedCachedRecipe(ShapedArcaneRecipe recipe) {
            super((ShapedRecipeHandler)ArcaneCraftingShapedHandler.this, recipe.width, recipe.height, recipe.getInput(), recipe.getRecipeOutput());
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 74, 2);
            this.aspects = recipe.getAspects();
            this.overlay = recipe.getInput();
            this.width = recipe.width;
            this.height = recipe.height;
            NEIHelper.addAspectsToIngredients((AspectList)this.aspects, (List)this.ingredients, (int)0);
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int y;
                int x;
                int[][][] positions2 = new int[width][height][2];
                int shiftX = 0;
                int shiftY = 0;
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        positions2[x][y][0] = ArcaneShapedRecipeHandler.positions[y][x][0];
                        positions2[x][y][1] = ArcaneShapedRecipeHandler.positions[y][x][1];
                    }
                }
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        if (items[y * width + x] == null || !(items[y * width + x] instanceof ItemStack) && !(items[y * width + x] instanceof ItemStack[]) && !(items[y * width + x] instanceof String) && !(items[y * width + x] instanceof List) || items[y * width + x] instanceof List && ((List)items[y * width + x]).isEmpty()) continue;
                        PositionedStack stack = new PositionedStack(items[y * width + x], positions2[x][y][0] + shiftX, positions2[x][y][1] + shiftY, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        Object object = this.overlay[y * this.width + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                        stacks.add(new PositionedStack(object, 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }
    }
}

