/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import java.util.Arrays;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class ASMUtils {
    private static final Object configHodgePodge;

    private ASMUtils() {
    }

    public static void writeMethodDeflected(String targetClass, String targetName, MethodVisitor mv, String clazz, String desc) {
        String targetDesc;
        int base;
        if (clazz == null) {
            base = 0;
            targetDesc = desc;
        } else {
            mv.visitVarInsn(25, 0);
            base = 1;
            targetDesc = '(' + Type.getObjectType((String)clazz).getDescriptor() + desc.substring(1);
        }
        mv.visitCode();
        Type methodType = Type.getMethodType((String)desc);
        for (Type argumentType : methodType.getArgumentTypes()) {
            mv.visitVarInsn(argumentType.getOpcode(21), base++);
        }
        mv.visitMethodInsn(184, targetClass, targetName, targetDesc, false);
        mv.visitInsn(methodType.getReturnType().getOpcode(172));
        mv.visitMaxs(base, Type.VOID_TYPE.equals((Object)methodType.getReturnType()) ? base : Math.max(1, base));
        mv.visitEnd();
    }

    static <T> T[] arrayAppend(T[] arr, T newLast) {
        T[] out = Arrays.copyOf(arr, arr.length + 1);
        out[arr.length] = newLast;
        return out;
    }

    static boolean isHodgepodgeFixActive(String configName) {
        if (configHodgePodge == null) {
            return false;
        }
        try {
            return (Boolean)configHodgePodge.getClass().getField(configName).get(configHodgePodge);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            TC4Transformer.log.error("Unforeseen changes in hodgepodge. Disabling conflicting patches just in case.");
            return false;
        }
    }

    static {
        Object cfg;
        try {
            Class<?> common = Class.forName("com.mitchej123.hodgepodge.Common", true, ASMUtils.class.getClassLoader());
            cfg = common.getField("config").get(null);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            cfg = null;
        }
        catch (IllegalAccessException e) {
            TC4Transformer.log.error("Unforeseen changes in hodgepodge. Nothing will be disabled automatically!");
            cfg = null;
        }
        configHodgePodge = cfg;
    }
}

