/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.TC4Transformer;
import net.glease.tc4tweak.asm.TransformerFactory;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ReadMarkerNoCastVisitor
extends ClassVisitor {
    static final boolean hodgepodge = ASMUtils.isHodgepodgeFixActive("fixThaumcraftGolemMarkerLoading");
    private final String targetMethod;
    private final String targetDesc;

    public ReadMarkerNoCastVisitor(int api, ClassVisitor cv, String targetMethod, String targetDesc) {
        super(api, cv);
        this.targetMethod = targetMethod;
        this.targetDesc = targetDesc;
    }

    public static TransformerFactory createFactory(String targetMethod, String targetDesc) {
        return new TransformerFactory((api, cv) -> new ReadMarkerNoCastVisitor((int)api, (ClassVisitor)cv, targetMethod, targetDesc)){

            @Override
            public boolean isInactive() {
                if (super.isInactive()) {
                    return true;
                }
                if (hodgepodge) {
                    TC4Transformer.log.warn("Disabling TC4Tweaks's golem marker patch to prevent conflict with hodgepodge.");
                }
                return hodgepodge;
            }
        };
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.targetMethod.equals(name) && this.targetDesc.equals(desc)) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new MarkerInstantiateFixVisitor(this.api, mv);
        }
        return mv;
    }

    private static class MarkerInstantiateFixVisitor
    extends MethodVisitor {
        private boolean active;

        public MarkerInstantiateFixVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitInsn(int opcode) {
            if (this.active && opcode == 145) {
                TC4Transformer.log.trace("Dropped I2B");
                return;
            }
            super.visitInsn(opcode);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187 && "thaumcraft/common/entities/golems/Marker".equals(type)) {
                TC4Transformer.log.trace("Start looking for I2B");
                this.active = true;
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.active && opcode == 183 && "thaumcraft/common/entities/golems/Marker".equals(owner) && "<init>".equals(name)) {
                TC4Transformer.log.trace("Stop looking for I2B");
                this.active = false;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

