/*
 * Decompiled with CFR 0.152.
 */
package tb.common.item.foci;

import DummyCore.Utils.MiscUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tb.init.TBFociUpgrades;
import tb.init.TBThaumonomicon;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.codechicken.lib.math.MathHelper;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemCrystalEssence;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class FociExperience
extends ItemFocusBasic {
    public int getFocusColor(ItemStack focusstack) {
        return 16318428;
    }

    public String getSortingHelper(ItemStack focusstack) {
        String out = "XP";
        for (short id : this.getAppliedUpgrades(focusstack)) {
            out = out + id;
        }
        return out;
    }

    public boolean isVisCostPerTick(ItemStack focusstack) {
        return true;
    }

    public AspectList getVisCost(ItemStack focusstack) {
        return new AspectList().add(Aspect.ORDER, 500).add(Aspect.ENTROPY, 500);
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack focusstack) {
        return ItemFocusBasic.WandFocusAnimation.CHARGE;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        switch (rank) {
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.potency, FocusUpgradeType.frugal, TBFociUpgrades.vaporizing, TBFociUpgrades.decomposing};
            }
            case 5: {
                if (this.getUpgradeLevel(focusstack, TBFociUpgrades.decomposing) > 0) {
                    return new FocusUpgradeType[]{FocusUpgradeType.potency, FocusUpgradeType.frugal, TBFociUpgrades.decomposing};
                }
                if (this.getUpgradeLevel(focusstack, TBFociUpgrades.vaporizing) > 0) {
                    return new FocusUpgradeType[]{FocusUpgradeType.potency, FocusUpgradeType.frugal, TBFociUpgrades.vaporizing};
                }
                return new FocusUpgradeType[]{FocusUpgradeType.potency, FocusUpgradeType.frugal, TBFociUpgrades.vaporizing, TBFociUpgrades.decomposing};
            }
        }
        return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
    }

    public ItemStack onFocusRightClick(ItemStack wandstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        ItemStack foci = ItemStack.func_77949_a((NBTTagCompound)MiscUtils.getStackTag((ItemStack)wandstack).func_74775_l("focus"));
        int vaporisingLevel = this.getUpgradeLevel(foci, TBFociUpgrades.vaporizing);
        int decomposingLevel = this.getUpgradeLevel(foci, TBFociUpgrades.decomposing);
        if (decomposingLevel > 0) {
            Entity e;
            Vec3 vec = player.func_70040_Z();
            ArrayList mobs = (ArrayList)world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)(player.field_70165_t + vec.field_72450_a - 0.3), (double)(player.field_70163_u + (double)player.func_70047_e() + vec.field_72448_b - 0.3), (double)(player.field_70161_v + vec.field_72449_c - 0.3), (double)(player.field_70165_t + vec.field_72450_a + 0.3), (double)(player.field_70163_u + (double)player.func_70047_e() + vec.field_72448_b + 0.3), (double)(player.field_70161_v + vec.field_72449_c + 0.3)));
            if (mobs != null && !mobs.isEmpty() && (e = (Entity)mobs.get(world.field_73012_v.nextInt(mobs.size()))) instanceof EntityLivingBase) {
                EntityLivingBase eaten = (EntityLivingBase)e;
                if (e instanceof EntityPlayer) {
                    return wandstack;
                }
                if (e instanceof IBossDisplayData) {
                    return wandstack;
                }
                double hp = eaten.func_110143_aJ();
                if (WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)TBThaumonomicon.primals(MathHelper.floor_double((double)(hp * 100.0 / (double)decomposingLevel))))) {
                    eaten.func_70097_a(DamageSource.field_76380_i, 2.1474836E9f);
                    int xp = MathHelper.floor_double((double)(hp * 3.0));
                    EntityXPOrb orb = new EntityXPOrb(world, eaten.field_70165_t, eaten.field_70163_u, eaten.field_70161_v, xp);
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)orb);
                    }
                    return wandstack;
                }
            }
        }
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int meta;
            Block b = world.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d);
            int xp = b.getExpDrop((IBlockAccess)world, meta = world.func_72805_g(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d), this.getUpgradeLevel(foci, FocusUpgradeType.potency));
            if (xp <= 0) {
                xp = this.getUpgradeLevel(foci, FocusUpgradeType.potency) + 1;
            }
            MovingObjectPosition pos = movingobjectposition;
            if (b.func_149712_f(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) <= 0.0f) {
                return wandstack;
            }
            if (!WandManager.consumeVisFromInventory((EntityPlayer)player, (AspectList)TBThaumonomicon.primals(MathHelper.floor_double((double)(b.func_149712_f(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) * 100.0f))))) {
                return wandstack;
            }
            if (vaporisingLevel > 0) {
                AspectList aspects;
                boolean doWork;
                boolean bl = doWork = vaporisingLevel == 1 ? world.field_73012_v.nextBoolean() : true;
                if (doWork && ThaumcraftApi.exists((Item)Item.func_150898_a((Block)b), (int)meta) && (aspects = ThaumcraftCraftingManager.getObjectTags((ItemStack)new ItemStack(Item.func_150898_a((Block)b), 1, meta))) != null && aspects.size() > 0) {
                    for (int i = 0; i < aspects.getAspects().length; ++i) {
                        Aspect a = aspects.getAspects()[i];
                        int amount = aspects.getAmount(a);
                        ItemStack crystalStack = new ItemStack(ConfigItems.itemCrystalEssence, 1, 0);
                        ItemCrystalEssence cEssence = (ItemCrystalEssence)crystalStack.func_77973_b();
                        cEssence.setAspects(crystalStack, new AspectList().add(a, amount));
                        EntityItem crystal = new EntityItem(player.field_70170_p, (double)pos.field_72311_b + 0.5, (double)pos.field_72312_c + 0.5, (double)pos.field_72309_d + 0.5, crystalStack);
                        if (player.field_70170_p.field_72995_K) continue;
                        player.field_70170_p.func_72838_d((Entity)crystal);
                    }
                }
            }
            b.func_149664_b(player.field_70170_p, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, player.field_70170_p.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d));
            player.field_70170_p.func_147465_d(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, Blocks.field_150350_a, 0, 3);
            player.field_70170_p.func_72980_b((double)pos.field_72311_b + 0.5, (double)pos.field_72312_c + 0.5, (double)pos.field_72309_d + 0.5, b.field_149762_H.func_150495_a(), 1.0f, 1.0f, false);
            for (int i = 0; i < 100; ++i) {
                player.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)b) + "_" + meta, (double)pos.field_72311_b + player.field_70170_p.field_73012_v.nextDouble(), (double)pos.field_72312_c + player.field_70170_p.field_73012_v.nextDouble(), (double)pos.field_72309_d + player.field_70170_p.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
            }
            EntityXPOrb orb = new EntityXPOrb(world, (double)pos.field_72311_b + 0.5, (double)pos.field_72312_c + 0.5, (double)pos.field_72309_d + 0.5, xp *= 2);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)orb);
            }
            player.func_71038_i();
        }
        return wandstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.icon = reg.func_94245_a(this.func_111208_A());
    }
}

