/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.lib;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;

public class SelfInfusionRecipe {
    protected AspectList aspects;
    protected String research;
    private ItemStack[] components;
    protected int instability;
    protected int id;

    public SelfInfusionRecipe(String research, int inst, AspectList aspects2, ItemStack[] recipe, int id) {
        this.research = research;
        this.instability = inst;
        this.aspects = aspects2.copy();
        this.components = recipe;
        this.id = id;
    }

    public boolean matches(ArrayList<ItemStack> input, World world, EntityPlayer player) {
        if (this.research.length() > 0 && !ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.research)) {
            return false;
        }
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.func_77946_l());
        }
        for (ItemStack comp : this.getComponents()) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                ItemStack i2 = ((ItemStack)ii.get(a)).func_77946_l();
                if (comp.func_77960_j() == Short.MAX_VALUE) {
                    i2.func_77964_b(Short.MAX_VALUE);
                }
                if (!SelfInfusionRecipe.areItemStacksEqual(i2, comp, true)) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return ii.size() == 0;
    }

    public static boolean areItemStacksEqual(ItemStack stack0, ItemStack stack1, boolean fuzzy) {
        ItemStack[] ores;
        int od;
        if (stack0 == null && stack1 != null) {
            return false;
        }
        if (stack0 != null && stack1 == null) {
            return false;
        }
        if (stack0 == null && stack1 == null) {
            return true;
        }
        boolean t1 = ThaumcraftApiHelper.areItemStackTagsEqualForCrafting((ItemStack)stack0, (ItemStack)stack1);
        if (!t1) {
            return false;
        }
        if (fuzzy && (od = OreDictionary.getOreID((ItemStack)stack0)) != -1 && ThaumcraftApiHelper.containsMatch((boolean)false, (ItemStack[])new ItemStack[]{stack1}, (ItemStack[])(ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0])))) {
            return true;
        }
        boolean damage = stack0.func_77960_j() == stack1.func_77960_j() || stack1.func_77960_j() == Short.MAX_VALUE;
        return stack0.func_77973_b() == stack1.func_77973_b() && damage && stack0.field_77994_a <= stack0.func_77976_d();
    }

    public AspectList getAspects() {
        return this.aspects;
    }

    public int getInstability() {
        return this.instability;
    }

    public String getResearch() {
        return this.research;
    }

    public ItemStack[] getComponents() {
        return this.components;
    }

    public int getID() {
        return this.id;
    }
}

