/*
 * Decompiled with CFR 0.152.
 */
package thaumic.tinkerer.common.block.fire;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumic.tinkerer.client.core.helper.IconHelper;
import thaumic.tinkerer.common.ThaumicTinkerer;
import thaumic.tinkerer.common.block.fire.BlockFireAir;
import thaumic.tinkerer.common.block.fire.BlockFireChaos;
import thaumic.tinkerer.common.block.fire.BlockFireEarth;
import thaumic.tinkerer.common.block.fire.BlockFireIgnis;
import thaumic.tinkerer.common.block.fire.BlockFireOrder;
import thaumic.tinkerer.common.block.fire.BlockFireWater;
import thaumic.tinkerer.common.core.handler.ConfigHandler;
import thaumic.tinkerer.common.item.ItemBlockFire;
import thaumic.tinkerer.common.registry.ITTinkererBlock;

public abstract class BlockFireBase
extends BlockFire
implements ITTinkererBlock {
    public static final String LARGESMOKE = "largesmoke";
    private IIcon[] icons;
    private IIcon itemIcon;
    private static final Random random = new Random();

    public abstract HashMap<Block, Block> getBlockTransformation();

    public boolean isTransmutationTarget(Block block, IBlockAccess w, int x, int y, int z) {
        return this.getBlockTransformation(w, x, y, z).containsKey(block);
    }

    public boolean isTransmutationResult(Block block, IBlockAccess w, int x, int y, int z) {
        return this.getBlockTransformation(w, x, y, z).containsValue(block);
    }

    public abstract HashMap<Block, Block> getBlockTransformation(IBlockAccess var1, int var2, int var3, int var4);

    public boolean isNeighborTarget(World w, int x, int y, int z) {
        for (ForgeDirection f : ForgeDirection.VALID_DIRECTIONS) {
            int xTar = x + f.offsetX;
            int yTar = y + f.offsetY;
            int zTar = z + f.offsetZ;
            if (!w.func_72899_e(xTar, yTar, zTar) || !this.isTransmutationTarget(w.func_147439_a(xTar, yTar, zTar), (IBlockAccess)w, xTar, yTar, zTar)) continue;
            return true;
        }
        return false;
    }

    public int func_149738_a(World p_149738_1_) {
        return ConfigHandler.enableFireMechanics ? 200 : 0x7FFFFFF0;
    }

    public void setBlockWithTransmutationTarget(World world, int x, int y, int z, int meta, Block block) {
        Block targetBlock = world.func_147439_a(x, y, z);
        if (this.isTransmutationTarget(targetBlock, (IBlockAccess)world, x, y, z)) {
            Block targetTransform = this.getBlockTransformation((IBlockAccess)world, x, y, z).get(targetBlock);
            world.func_147465_d(x, y, z, targetTransform, 0, 3);
        } else {
            world.func_147465_d(x, y, z, block, meta, 3);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!(world.func_82736_K().func_82766_b("doFireTick") && ConfigHandler.enableFire && ConfigHandler.enableFireMechanics)) {
            return;
        }
        if (world.func_72896_J() && (world.func_72951_B(x, y, z) || world.func_72951_B(x - 1, y, z) || world.func_72951_B(x + 1, y, z) || world.func_72951_B(x, y, z - 1) || world.func_72951_B(x, y, z + 1))) {
            world.func_147468_f(x, y, z);
            return;
        }
        int blockMeta = world.func_72805_g(x, y, z);
        if (blockMeta != 0 && !this.isNeighborTarget(world, x, y, z)) {
            world.func_147468_f(x, y, z);
            return;
        }
        if (rand.nextInt(20) == 0 && this.isNeighborTarget(world, x, y, z)) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int xT = x + dir.offsetX;
                int yT = y + dir.offsetY;
                int zT = z + dir.offsetZ;
                Block targetBlock = world.func_147439_a(xT, yT, zT);
                Block targetTransform = this.getBlockTransformation((IBlockAccess)world, xT, yT, zT).get(targetBlock);
                if (targetTransform == null) continue;
                world.func_147465_d(xT, yT, zT, targetTransform, 0, 3);
            }
        }
        if (blockMeta < 15 && blockMeta > 0) {
            int newMeta = Math.min(blockMeta + rand.nextInt(3) / 2, 15);
            if (newMeta > blockMeta) {
                world.func_72921_c(x, y, z, newMeta, 4);
            }
        } else if (blockMeta >= 15) {
            return;
        }
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world) + rand.nextInt(3));
        boolean highHumidity = world.func_72958_C(x, y, z);
        int strMod = 0;
        if (highHumidity) {
            strMod = -50;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.tryCatchFire(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, 300 + strMod, rand, blockMeta, dir);
        }
        for (int xt = x - 1; xt <= x + 1; ++xt) {
            for (int zt = z - 1; zt <= z + 1; ++zt) {
                for (int yt = y - 1; yt <= y + 2; ++yt) {
                    int fireChance;
                    if (xt == x && yt == y && zt == z || (fireChance = this.getChanceOfNeighborsEncouragingFire(world, xt, yt, zt)) <= 0) continue;
                    fireChance = (fireChance + 70) / (blockMeta + 30) + 70;
                    if (highHumidity) {
                        fireChance /= 2;
                    }
                    if (fireChance <= 0 || rand.nextInt(100) > fireChance || world.func_72896_J() && world.func_72951_B(xt, yt, zt) || world.func_72951_B(xt - 1, yt, z) || world.func_72951_B(xt + 1, yt, zt) || world.func_72951_B(xt, yt, zt - 1) || world.func_72951_B(xt, yt, zt + 1)) continue;
                    int targetMeta = Math.min(blockMeta + 1, 15);
                    this.setBlockWithTransmutationTarget(world, xt, yt, zt, targetMeta, (Block)this);
                }
            }
        }
    }

    public int getBlockFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        Block block = world.func_147439_a(x, y, z);
        if (this.isTransmutationTarget(block, world, x, y, z)) {
            return 100;
        }
        if (this.isTransmutationResult(block, world, x, y, z)) {
            return 0;
        }
        return world.func_147439_a(x, y, z).getFlammability(world, x, y, z, face);
    }

    private void tryCatchFire(World world, int x, int y, int z, int strength, Random rand, int meta, ForgeDirection dir) {
        boolean isTnt;
        int blockFlammability = this.getBlockFlammability((IBlockAccess)world, x, y, z, dir);
        if (rand.nextInt(strength) >= blockFlammability) {
            return;
        }
        boolean bl = isTnt = world.func_147439_a(x, y, z) == Blocks.field_150335_W;
        if (rand.nextInt(meta + 10) < 5 && !world.func_72951_B(x, y, z)) {
            int nextMeta = Math.max(Math.min(meta + rand.nextInt(5) / 4, 15), 1);
            this.setBlockWithTransmutationTarget(world, x, y, z, nextMeta, (Block)this);
        } else {
            this.setBlockWithTransmutationTarget(world, x, y, z, 0, Blocks.field_150350_a);
        }
        if (isTnt) {
            Blocks.field_150335_W.func_149664_b(world, x, y, z, 1);
        }
    }

    private boolean canNeighborBurn(World world, int x, int y, int z) {
        return this.isNeighborTarget(world, x, y, z);
    }

    private int getChanceOfNeighborsEncouragingFire(World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z)) {
            return 0;
        }
        if (this.isNeighborTarget(world, x, y, z)) {
            return 100;
        }
        return 0;
    }

    @Deprecated
    public boolean func_149844_e(IBlockAccess w, int x, int y, int z) {
        return this.canCatchFire(w, x, y, z, ForgeDirection.UP);
    }

    @Deprecated
    public int func_149846_a(World w, int x, int y, int z, int chance) {
        return this.getChanceToEncourageFire((IBlockAccess)w, x, y, z, chance, ForgeDirection.UP);
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        if (entity instanceof EntityPlayer) {
            ThaumicTinkerer.log.info("Player: " + ((EntityPlayer)entity).getDisplayName() + " placed TT Fire");
        }
    }

    public boolean func_149742_c(World w, int x, int y, int z) {
        return true;
    }

    public boolean canCatchFire(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.getBlockFlammability(world, x, y, z, face) > 0;
    }

    public int getChanceToEncourageFire(IBlockAccess world, int x, int y, int z, int oldChance, ForgeDirection face) {
        int newChance = world.func_147439_a(x, y, z).getFireSpreadSpeed(world, x, y, z, face);
        return Math.max(newChance, oldChance);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !this.canNeighborBurn(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g > 0 || !Blocks.field_150427_aO.func_150000_e(world, x, y, z)) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(10));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        block12: {
            block11: {
                float f2;
                float f1;
                float f;
                int l;
                if (rand.nextInt(24) == 0) {
                    world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "fire.fire", 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP)) break block11;
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)x + rand.nextFloat() * 0.1f;
                        f1 = (float)y + rand.nextFloat();
                        f2 = (float)z + rand.nextFloat();
                        world.func_72869_a(LARGESMOKE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)(x + 1) - rand.nextFloat() * 0.1f;
                        f1 = (float)y + rand.nextFloat();
                        f2 = (float)z + rand.nextFloat();
                        world.func_72869_a(LARGESMOKE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)x + rand.nextFloat();
                        f1 = (float)y + rand.nextFloat();
                        f2 = (float)z + rand.nextFloat() * 0.1f;
                        world.func_72869_a(LARGESMOKE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)x + rand.nextFloat();
                        f1 = (float)y + rand.nextFloat();
                        f2 = (float)(z + 1) - rand.nextFloat() * 0.1f;
                        world.func_72869_a(LARGESMOKE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (!Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN)) break block12;
                for (l = 0; l < 2; ++l) {
                    f = (float)x + rand.nextFloat();
                    f1 = (float)(y + 1) - rand.nextFloat() * 0.1f;
                    f2 = (float)z + rand.nextFloat();
                    world.func_72869_a(LARGESMOKE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int l = 0; l < 3; ++l) {
                float f = (float)x + rand.nextFloat();
                float f1 = (float)y + rand.nextFloat() * 0.5f + 0.5f;
                float f2 = (float)z + rand.nextFloat();
                world.func_72869_a(LARGESMOKE, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
            }
        }
    }

    public MapColor func_149728_f(int p_149728_1_) {
        return MapColor.field_151656_f;
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        return null;
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public Class<? extends TileEntity> getTileEntity() {
        return null;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlock() {
        return ItemBlockFire.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[]{IconHelper.forName(iconRegister, this.getBlockName() + "_layer_0"), IconHelper.forName(iconRegister, this.getBlockName() + "_layer_1")};
        String s = "";
        if (this instanceof BlockFireAir) {
            s = "aer";
        }
        if (this instanceof BlockFireEarth) {
            s = "terra";
        }
        if (this instanceof BlockFireWater) {
            s = "aqua";
        }
        if (this instanceof BlockFireIgnis) {
            s = "ignis";
        }
        if (this instanceof BlockFireOrder) {
            s = "ordo";
        }
        if (this instanceof BlockFireChaos) {
            s = "perditio";
        }
        s = s + "Fire";
        this.itemIcon = IconHelper.forName(iconRegister, s);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149840_c(int p_149840_1_) {
        return this.icons[p_149840_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.itemIcon;
    }
}

