/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.inventory;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import travellersgear.common.util.ModCompatability;

public class SlotRestricted
extends Slot {
    public int slotLimit = 1;
    public SlotType type;
    EntityPlayer player;

    public SlotRestricted(IInventory inv, int id, int x, int y, EntityPlayer player, SlotType type) {
        super(inv, id, x, y);
        this.player = player;
        this.type = type;
        if (this.type.equals((Object)SlotType.TINKERS_HEART_R) || this.type.equals((Object)SlotType.TINKERS_HEART_G) || this.type.equals((Object)SlotType.TINKERS_HEART_Y)) {
            this.slotLimit = 10;
        }
    }

    public boolean func_75214_a(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        switch (this.type) {
            case VANILLA_HELM: 
            case VANILLA_CHEST: 
            case VANILLA_LEGS: 
            case VANILLA_BOOTS: {
                return stack.func_77973_b().isValidArmor(stack, this.type.ordinal(), (Entity)this.player);
            }
            case TRAVEL_CLOAK: 
            case TRAVEL_SHOULDER: 
            case TRAVEL_VAMBRACE: 
            case TRAVEL_TITLE: {
                return ModCompatability.getTravellersGearSlot(stack) == this.type.ordinal() - 4;
            }
            case BAUBLE_BELT: {
                return stack.func_77973_b() instanceof IBauble && ((IBauble)stack.func_77973_b()).getBaubleType(stack) == BaubleType.BELT && ((IBauble)stack.func_77973_b()).canEquip(stack, (EntityLivingBase)this.player);
            }
            case BAUBLE_NECK: {
                return stack.func_77973_b() instanceof IBauble && ((IBauble)stack.func_77973_b()).getBaubleType(stack) == BaubleType.AMULET && ((IBauble)stack.func_77973_b()).canEquip(stack, (EntityLivingBase)this.player);
            }
            case BAUBLE_RING: {
                return stack.func_77973_b() instanceof IBauble && ((IBauble)stack.func_77973_b()).getBaubleType(stack) == BaubleType.RING && ((IBauble)stack.func_77973_b()).canEquip(stack, (EntityLivingBase)this.player);
            }
            case MARI_BRACELET: 
            case MARI_NECKLACE: 
            case MARI_RING: {
                String jewelType = ModCompatability.getMariJeweleryType(stack);
                return jewelType != null && jewelType.equalsIgnoreCase(this.type.name().substring(5));
            }
            case TINKERS_GLOVE: {
                return ModCompatability.canEquipTConAccessory(stack, 1);
            }
            case TINKERS_BAG: {
                return ModCompatability.canEquipTConAccessory(stack, 2);
            }
            case TINKERS_BELT: {
                return ModCompatability.canEquipTConAccessory(stack, 3);
            }
            case TINKERS_MASK: {
                return ModCompatability.canEquipTConAccessory(stack, 0);
            }
            case TINKERS_HEART_R: {
                return ModCompatability.canEquipTConAccessory(stack, 6);
            }
            case TINKERS_HEART_Y: {
                return ModCompatability.canEquipTConAccessory(stack, 5);
            }
            case TINKERS_HEART_G: {
                return ModCompatability.canEquipTConAccessory(stack, 4);
            }
        }
        return false;
    }

    public boolean isBaubleSlot() {
        return this.type == SlotType.BAUBLE_NECK || this.type == SlotType.BAUBLE_RING || this.type == SlotType.BAUBLE_BELT;
    }

    public boolean func_82869_a(EntityPlayer player) {
        if (this.func_75211_c() == null) {
            return false;
        }
        switch (this.type) {
            case BAUBLE_BELT: {
                return this.func_75211_c().func_77973_b() instanceof IBauble && ((IBauble)this.func_75211_c().func_77973_b()).getBaubleType(this.func_75211_c()) == BaubleType.BELT && ((IBauble)this.func_75211_c().func_77973_b()).canUnequip(this.func_75211_c(), (EntityLivingBase)this.player);
            }
            case BAUBLE_NECK: {
                return this.func_75211_c().func_77973_b() instanceof IBauble && ((IBauble)this.func_75211_c().func_77973_b()).getBaubleType(this.func_75211_c()) == BaubleType.AMULET && ((IBauble)this.func_75211_c().func_77973_b()).canUnequip(this.func_75211_c(), (EntityLivingBase)this.player);
            }
            case BAUBLE_RING: {
                return this.func_75211_c().func_77973_b() instanceof IBauble && ((IBauble)this.func_75211_c().func_77973_b()).getBaubleType(this.func_75211_c()) == BaubleType.RING && ((IBauble)this.func_75211_c().func_77973_b()).canUnequip(this.func_75211_c(), (EntityLivingBase)this.player);
            }
        }
        return true;
    }

    public int func_75219_a() {
        return this.slotLimit;
    }

    public static enum SlotType {
        VANILLA_HELM,
        VANILLA_CHEST,
        VANILLA_LEGS,
        VANILLA_BOOTS,
        TRAVEL_CLOAK,
        TRAVEL_SHOULDER,
        TRAVEL_VAMBRACE,
        TRAVEL_TITLE,
        BAUBLE_NECK,
        BAUBLE_RING,
        BAUBLE_BELT,
        MARI_NECKLACE,
        MARI_BRACELET,
        MARI_RING,
        TINKERS_GLOVE,
        TINKERS_BAG,
        TINKERS_BELT,
        TINKERS_MASK,
        TINKERS_HEART_R,
        TINKERS_HEART_Y,
        TINKERS_HEART_G;

    }
}

