/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBellTower21;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBridge;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleDamagedTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleEntranceTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleFoundation13;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleRoof13Conical;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleRoof13Crenellated;
import twilightforest.structures.lichtower.ComponentTFTowerWing;

public class ComponentTFFinalCastleMazeTower13
extends ComponentTFTowerWing {
    public static final int LOWEST_DOOR = 144;
    public static final int HIGHEST_DOOR = 222;
    public int type;

    public ComponentTFFinalCastleMazeTower13() {
    }

    public ComponentTFFinalCastleMazeTower13(Random rand, int i, int x, int y, int z, int type, int direction) {
        super(i);
        this.setCoordBaseMode(direction);
        this.type = type;
        this.size = 13;
        int floors = rand.nextInt(3) + 2;
        this.height = floors * 8 + 1;
        int entranceFloor = rand.nextInt(floors);
        if (y - entranceFloor * 8 < 144) {
            entranceFloor = 0;
        }
        if (y + (floors - entranceFloor) * 8 > 222) {
            entranceFloor = floors - 1;
        }
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -6, 0 - entranceFloor * 8, -6, this.size - 1, this.height, this.size - 1, 0);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, 2);
    }

    public ComponentTFFinalCastleMazeTower13(Random rand, int i, int x, int y, int z, int floors, int entranceFloor, int type, int direction) {
        super(i);
        this.setCoordBaseMode(direction);
        this.type = type;
        this.size = 13;
        this.height = floors * 8 + 1;
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -6, 0 - entranceFloor * 8, -6, this.size - 1, this.height, this.size - 1, 0);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, 2);
    }

    @Override
    public void func_74861_a(StructureComponent parent, List list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        ComponentTFFinalCastleFoundation13 foundation = new ComponentTFFinalCastleFoundation13(rand, 4, this);
        list.add(foundation);
        foundation.func_74861_a(this, list, rand);
        StructureTFComponent roof = rand.nextBoolean() ? new ComponentTFFinalCastleRoof13Conical(rand, 4, this) : new ComponentTFFinalCastleRoof13Crenellated(rand, 4, this);
        list.add(roof);
        roof.func_74861_a(this, list, rand);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void buildTowards(StructureComponent parent, List list, Random rand, ChunkCoordinates dest) {
        this.func_74861_a(parent, list, rand);
        if (this.func_74877_c() < 20) {
            if (this.isWithinRange(dest.field_71574_a, dest.field_71573_c, this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78896_c + 6, 30)) {
                int howFar = 20;
                if (!this.buildEndTowerTowards(list, rand, dest, this.findBestDirectionTowards(dest), howFar) && !this.buildEndTowerTowards(list, rand, dest, this.findSecondDirectionTowards(dest), howFar) && this.buildEndTowerTowards(list, rand, dest, this.findThirdDirectionTowards(dest), howFar)) {
                    // empty if block
                }
            } else {
                int howFar = 14 + rand.nextInt(24);
                int direction = this.findBestDirectionTowards(dest);
                if (direction != 0 && this.buildContinueTowerTowards(list, rand, dest, direction, howFar) || (direction = this.findSecondDirectionTowards(dest)) != 0 && this.buildContinueTowerTowards(list, rand, dest, direction, howFar) || (direction = this.findThirdDirectionTowards(dest)) != 0 && this.buildContinueTowerTowards(list, rand, dest, direction, howFar) || !this.buildContinueTowerTowards(list, rand, dest, 0, howFar)) {
                    // empty if block
                }
            }
        }
        this.buildNonCriticalTowers(parent, list, rand);
    }

    protected void buildNonCriticalTowers(StructureComponent parent, List list, Random rand) {
        int dir = rand.nextInt(4);
        if (this.openingTowards[dir] || this.buildDamagedTower(list, rand, dir) || !this.buildDamagedTower(list, rand, dir = (dir + rand.nextInt(4)) % 4)) {
            // empty if block
        }
    }

    private int findBestDirectionTowards(ChunkCoordinates dest) {
        int cx = this.field_74887_e.field_78897_a + 6;
        int cz = this.field_74887_e.field_78896_c + 6;
        int dx = cx - dest.field_71574_a;
        int dz = cz - dest.field_71573_c;
        int absoluteDir = 0;
        absoluteDir = Math.abs(dx) > Math.abs(dz) ? (dx >= 0 ? 2 : 0) : (dz >= 0 ? 3 : 1);
        int relativeDir = (absoluteDir + 4 - this.field_74885_f) % 4;
        return relativeDir;
    }

    private int findSecondDirectionTowards(ChunkCoordinates dest) {
        int cx = this.field_74887_e.field_78897_a + 6;
        int cz = this.field_74887_e.field_78896_c + 6;
        int dx = cx - dest.field_71574_a;
        int dz = cz - dest.field_71573_c;
        int absoluteDir = 0;
        absoluteDir = Math.abs(dx) < Math.abs(dz) ? (dx >= 0 ? 2 : 0) : (dz >= 0 ? 3 : 1);
        int relativeDir = (absoluteDir + 4 - this.field_74885_f) % 4;
        return relativeDir;
    }

    private int findThirdDirectionTowards(ChunkCoordinates dest) {
        int first = this.findBestDirectionTowards(dest);
        int second = this.findSecondDirectionTowards(dest);
        if (first == 0 && second == 1) {
            return 3;
        }
        if (first == 1 && second == 3) {
            return 0;
        }
        return 1;
    }

    private boolean buildContinueTowerTowards(List list, Random rand, ChunkCoordinates dest, int direction, int howFar) {
        ChunkCoordinates opening = this.getValidOpeningCC(rand, direction);
        int adjustmentRange = 60;
        if (this.isWithinRange(dest.field_71574_a, dest.field_71573_c, this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78896_c + 6, adjustmentRange)) {
            opening.field_71572_b = this.adjustOpening(opening.field_71572_b, dest);
        }
        direction += this.field_74885_f;
        ChunkCoordinates tc = this.offsetTowerCCoords(opening.field_71574_a, opening.field_71572_b, opening.field_71573_c, howFar, direction %= 4);
        StructureComponent start = (StructureComponent)list.get(0);
        int centerX = start.func_74874_b().field_78897_a + 128 >> 8 << 8;
        int centerZ = start.func_74874_b().field_78896_c + 128 >> 8 << 8;
        if (this.isWithinRange(centerX, centerZ, tc.field_71574_a, tc.field_71573_c, 128)) {
            ComponentTFFinalCastleMazeTower13 sTower = new ComponentTFFinalCastleMazeTower13(rand, this.func_74877_c() + 1, tc.field_71574_a, tc.field_71572_b, tc.field_71573_c, this.type, direction);
            StructureBoundingBox largerBB = new StructureBoundingBox(sTower.func_74874_b());
            largerBB.field_78897_a -= 6;
            largerBB.field_78896_c -= 6;
            largerBB.field_78893_d += 6;
            largerBB.field_78892_f += 6;
            largerBB.field_78895_b = 0;
            largerBB.field_78894_e = 255;
            StructureComponent intersect = StructureComponent.func_74883_a((List)list, (StructureBoundingBox)largerBB);
            if (intersect == null) {
                list.add(sTower);
                sTower.buildTowards(this, list, rand, dest);
                ChunkCoordinates bc = this.offsetTowerCCoords(opening.field_71574_a, opening.field_71572_b, opening.field_71573_c, 1, direction);
                ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.func_74877_c() + 1, bc.field_71574_a, bc.field_71572_b, bc.field_71573_c, howFar - 7, direction);
                list.add(bridge);
                bridge.func_74861_a(this, list, rand);
                this.addOpening(opening.field_71574_a, opening.field_71572_b + 1, opening.field_71573_c, direction);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean buildDamagedTower(List list, Random rand, int direction) {
        ChunkCoordinates opening = this.getValidOpeningCC(rand, direction);
        direction += this.field_74885_f;
        int howFar = 14 + rand.nextInt(24);
        ChunkCoordinates tc = this.offsetTowerCCoords(opening.field_71574_a, opening.field_71572_b, opening.field_71573_c, howFar, direction %= 4);
        ComponentTFFinalCastleMazeTower13 eTower = this.makeNewDamagedTower(rand, direction, tc);
        StructureBoundingBox largerBB = new StructureBoundingBox(eTower.func_74874_b());
        largerBB.field_78897_a -= 6;
        largerBB.field_78896_c -= 6;
        largerBB.field_78893_d += 6;
        largerBB.field_78892_f += 6;
        StructureComponent intersect = StructureComponent.func_74883_a((List)list, (StructureBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.func_74861_a(this, list, rand);
            ChunkCoordinates bc = this.offsetTowerCCoords(opening.field_71574_a, opening.field_71572_b, opening.field_71573_c, 1, direction);
            ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.func_74877_c() + 1, bc.field_71574_a, bc.field_71572_b, bc.field_71573_c, howFar - 7, direction);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(opening.field_71574_a, opening.field_71572_b + 1, opening.field_71573_c, direction);
            return true;
        }
        return false;
    }

    protected ComponentTFFinalCastleMazeTower13 makeNewDamagedTower(Random rand, int direction, ChunkCoordinates tc) {
        return new ComponentTFFinalCastleDamagedTower(rand, this.func_74877_c() + 1, tc.field_71574_a, tc.field_71572_b, tc.field_71573_c, direction);
    }

    private int adjustOpening(int posY, ChunkCoordinates dest) {
        int openY = posY;
        int realOpeningY = this.func_74862_a(openY);
        if (realOpeningY - dest.field_71572_b < 12) {
            openY = this.height - 9;
        } else if (dest.field_71572_b - realOpeningY < 12) {
            openY = 0;
        }
        return openY;
    }

    private boolean buildEndTowerTowards(List list, Random rand, ChunkCoordinates dest, int direction, int howFar) {
        ChunkCoordinates opening = this.getValidOpeningCC(rand, direction);
        opening.field_71572_b = this.adjustOpening(opening.field_71572_b, dest);
        direction += this.field_74885_f;
        ChunkCoordinates tc = this.offsetTowerCCoords(opening.field_71574_a, opening.field_71572_b, opening.field_71573_c, howFar, direction %= 4);
        ComponentTFFinalCastleMazeTower13 eTower = this.type == 0 ? new ComponentTFFinalCastleEntranceTower(rand, this.func_74877_c() + 1, tc.field_71574_a, tc.field_71572_b, tc.field_71573_c, direction) : new ComponentTFFinalCastleBellTower21(rand, this.func_74877_c() + 1, tc.field_71574_a, tc.field_71572_b, tc.field_71573_c, direction);
        StructureBoundingBox largerBB = new StructureBoundingBox(eTower.func_74874_b());
        largerBB.field_78897_a -= 6;
        largerBB.field_78896_c -= 6;
        largerBB.field_78893_d += 6;
        largerBB.field_78892_f += 6;
        StructureComponent intersect = StructureComponent.func_74883_a((List)list, (StructureBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.func_74861_a(this, list, rand);
            ChunkCoordinates bc = this.offsetTowerCCoords(opening.field_71574_a, opening.field_71572_b, opening.field_71573_c, 1, direction);
            ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.func_74877_c() + 1, bc.field_71574_a, bc.field_71572_b, bc.field_71573_c, howFar - 7, direction);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(opening.field_71574_a, opening.field_71572_b + 1, opening.field_71573_c, direction);
            return true;
        }
        return false;
    }

    private boolean isWithinRange(int centerX, int centerZ, int posX, int posZ, int range) {
        boolean inRange;
        boolean bl = inRange = Math.abs(centerX - posX) < range && Math.abs(centerZ - posZ) < range;
        if (!inRange) {
            // empty if block
        }
        return inRange;
    }

    public ChunkCoordinates getValidOpeningCC(Random rand, int direction) {
        int floors = this.height / 8;
        if (direction == 0 || direction == 2) {
            int rx = direction == 0 ? 12 : 0;
            int rz = 6;
            int ry = rand.nextInt(floors) * 8;
            return new ChunkCoordinates(rx, ry, rz);
        }
        if (direction == 1 || direction == 3) {
            int rx = 6;
            int rz = direction == 1 ? 12 : 0;
            int ry = rand.nextInt(floors) * 8;
            return new ChunkCoordinates(rx, ry, rz);
        }
        return new ChunkCoordinates(0, 0, 0);
    }

    @Override
    protected ChunkCoordinates offsetTowerCCoords(int x, int y, int z, int howFar, int direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        switch (direction) {
            case 0: {
                dx += howFar;
                break;
            }
            case 1: {
                dz += howFar;
                break;
            }
            case 2: {
                dx -= howFar;
                break;
            }
            case 3: {
                dz -= howFar;
            }
        }
        return new ChunkCoordinates(dx, dy, dz);
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.func_74882_a(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, this.deco.randomBlocks);
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.func_151554_b(world, this.deco.blockID, this.deco.blockMeta, x, -1, z, sbb);
            }
        }
        int numBranches = 2 + decoRNG.nextInt(4) + decoRNG.nextInt(3);
        for (int i = 0; i < numBranches; ++i) {
            this.makeGlyphBranches(world, decoRNG, this.getGlyphMeta(), sbb);
        }
        this.addFloors(world, decoRNG, sbb);
        this.makeOpenings(world, sbb);
        return true;
    }

    public int getGlyphMeta() {
        return this.type;
    }

    private void addFloors(World world, Random rand, StructureBoundingBox sbb) {
        int floors = this.highestOpening / 8 + 1;
        for (int i = 1; i < floors; ++i) {
            this.func_151556_a(world, sbb, 1, i * 8, 1, 11, i * 8, 11, this.deco.blockID, this.deco.blockMeta, this.deco.blockID, this.deco.blockMeta, false);
            this.addStairsDown(world, sbb, (i + 2) % 4, i * 8);
        }
        if (this.hasAccessibleRoof()) {
            this.addStairsDown(world, sbb, (floors + 2) % 4, this.height - 1);
        }
    }

    protected boolean hasAccessibleRoof() {
        return this.height - this.highestOpening < 9;
    }

    private void addStairsDown(World world, StructureBoundingBox sbb, int rotation, int y) {
        int sz;
        int sy;
        int sx;
        int i;
        for (i = 0; i < 4; ++i) {
            sx = 8 - i;
            sy = y - i;
            sz = 9;
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation), sx, sy, sz, rotation, sbb);
            this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, sx, sy - 1, sz, rotation, sbb);
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation), sx, sy, sz - 1, rotation, sbb);
            this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, sx, sy - 1, sz - 1, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz - 1, sx, sy + 3, sz, rotation);
        }
        this.fillBlocksRotated(world, sbb, 3, y - 4, 8, 4, y - 4, 9, this.deco.blockID, this.deco.blockMeta, rotation);
        for (i = 0; i < 4; ++i) {
            sx = 4;
            sy = y - i - 4;
            sz = 7 - i;
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation), sx, sy, sz, rotation, sbb);
            this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, sx, sy - 1, sz, rotation, sbb);
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation), sx - 1, sy, sz, rotation, sbb);
            this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, sx - 1, sy - 1, sz, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz, sx - 1, sy + 3, sz, rotation);
        }
    }

    @Override
    protected void makeDoorOpening(World world, int dx, int dy, int dz, StructureBoundingBox sbb) {
        if (dx == 0 || dx == this.size - 1) {
            this.func_151556_a(world, sbb, dx, dy - 1, dz - 2, dx, dy + 4, dz + 2, this.deco.accentID, this.deco.accentMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, sbb, dx, dy, dz - 1, dx, dy + 3, dz + 1, TFBlocks.castleDoor, this.getGlyphMeta(), Blocks.field_150350_a, 0, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.func_151556_a(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 4, dz, this.deco.accentID, this.deco.accentMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, sbb, dx - 1, dy, dz, dx + 1, dy + 3, dz, TFBlocks.castleDoor, this.getGlyphMeta(), Blocks.field_150350_a, 0, false);
        }
    }
}

