/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleDungeonEntrance;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleDungeonExit;
import twilightforest.structures.lichtower.ComponentTFTowerWing;

public class ComponentTFFinalCastleDungeonRoom31
extends ComponentTFTowerWing {
    public int level;

    public ComponentTFFinalCastleDungeonRoom31() {
    }

    public ComponentTFFinalCastleDungeonRoom31(Random rand, int i, int x, int y, int z, int direction, int level) {
        super(i);
        this.setCoordBaseMode(direction);
        this.spawnListIndex = 2;
        this.size = 31;
        this.height = 7;
        this.level = level;
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -15, 0, -15, this.size - 1, this.height - 1, this.size - 1, 0);
    }

    @Override
    public void func_74861_a(StructureComponent parent, List list, Random rand) {
        int i;
        int direction;
        int maxSpread;
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        int mySpread = this.func_74877_c() - parent.func_74877_c();
        int n = maxSpread = this.level == 1 ? 2 : 3;
        if (mySpread == maxSpread && !this.isExitBuildForLevel(parent)) {
            direction = rand.nextInt(4);
            for (i = 0; i < 8 && !this.isExitBuildForLevel(parent); ++i) {
                if (!this.addDungeonExit(parent, list, rand, direction = (direction + i) % 4)) continue;
                this.setExitBuiltForLevel(parent, true);
            }
        }
        if (mySpread < maxSpread) {
            direction = rand.nextInt(4);
            for (i = 0; i < 12; ++i) {
                direction = (direction + i) % 4;
                this.addDungeonRoom(parent, list, rand, direction, this.level);
            }
        }
    }

    private boolean isExitBuildForLevel(StructureComponent parent) {
        if (parent instanceof ComponentTFFinalCastleDungeonEntrance) {
            return ((ComponentTFFinalCastleDungeonEntrance)parent).hasExit;
        }
        return false;
    }

    private void setExitBuiltForLevel(StructureComponent parent, boolean exit) {
        if (parent instanceof ComponentTFFinalCastleDungeonEntrance) {
            ((ComponentTFFinalCastleDungeonEntrance)parent).hasExit = exit;
        }
    }

    protected boolean addDungeonRoom(StructureComponent parent, List list, Random rand, int rotation, int level) {
        rotation = (this.field_74885_f + rotation) % 4;
        ChunkCoordinates rc = this.getNewRoomCoords(rand, rotation);
        ComponentTFFinalCastleDungeonRoom31 dRoom = new ComponentTFFinalCastleDungeonRoom31(rand, this.field_74886_g + 1, rc.field_71574_a, rc.field_71572_b, rc.field_71573_c, rotation, level);
        StructureBoundingBox largerBB = new StructureBoundingBox(dRoom.func_74874_b());
        int expand = 0;
        largerBB.field_78897_a -= expand;
        largerBB.field_78896_c -= expand;
        largerBB.field_78893_d += expand;
        largerBB.field_78892_f += expand;
        StructureComponent intersect = StructureTFComponent.findIntersectingExcluding(list, largerBB, this);
        if (intersect == null) {
            list.add(dRoom);
            dRoom.func_74861_a(parent, list, rand);
            return true;
        }
        return false;
    }

    protected boolean addDungeonExit(StructureComponent parent, List list, Random rand, int rotation) {
        rotation = (this.field_74885_f + rotation) % 4;
        ChunkCoordinates rc = this.getNewRoomCoords(rand, rotation);
        ComponentTFFinalCastleDungeonExit dRoom = new ComponentTFFinalCastleDungeonExit(rand, this.field_74886_g + 1, rc.field_71574_a, rc.field_71572_b, rc.field_71573_c, rotation, this.level);
        StructureComponent intersect = StructureTFComponent.findIntersectingExcluding(list, dRoom.func_74874_b(), this);
        if (intersect == null) {
            list.add(dRoom);
            dRoom.func_74861_a(this, list, rand);
            return true;
        }
        return false;
    }

    private ChunkCoordinates getNewRoomCoords(Random rand, int rotation) {
        int offset = rand.nextInt(15) - 9;
        if (rand.nextBoolean()) {
            offset += this.size;
        }
        switch (rotation) {
            default: {
                return new ChunkCoordinates(this.field_74887_e.field_78893_d + 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + offset);
            }
            case 1: {
                return new ChunkCoordinates(this.field_74887_e.field_78897_a + offset, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 9);
            }
            case 2: {
                return new ChunkCoordinates(this.field_74887_e.field_78897_a - 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + offset);
            }
            case 3: 
        }
        return new ChunkCoordinates(this.field_74887_e.field_78897_a + offset, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 9);
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        if (this.isBoundingBoxOutOfPlateau(world, sbb)) {
            return false;
        }
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.func_74878_a(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        int forceFieldMeta = this.getForceFieldMeta(decoRNG);
        int runeMeta = this.getRuneMeta(forceFieldMeta);
        for (int rotation = 0; rotation < 4; ++rotation) {
            int cs = 7;
            this.fillBlocksRotated(world, sbb, cs, 0, cs + 1, cs, this.height - 1, this.size - 2 - cs, TFBlocks.forceField, forceFieldMeta, rotation);
            for (int z = cs; z < this.size - 1 - cs; z += 4) {
                this.fillBlocksRotated(world, sbb, cs, 0, z, cs, this.height - 1, z, TFBlocks.castleMagic, runeMeta, rotation);
                int y = (z - cs) % 8 == 0 ? decoRNG.nextInt(3) + 0 : decoRNG.nextInt(3) + 4;
                this.fillBlocksRotated(world, sbb, cs, y, z + 1, cs, y, z + 3, TFBlocks.castleMagic, runeMeta, rotation);
            }
        }
        return true;
    }

    private boolean isBoundingBoxOutOfPlateau(World world, StructureBoundingBox sbb) {
        int minX = this.field_74887_e.field_78897_a - 1;
        int minZ = this.field_74887_e.field_78896_c - 1;
        int maxX = this.field_74887_e.field_78893_d + 1;
        int maxZ = this.field_74887_e.field_78892_f + 1;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (world.func_72807_a(x, z) == TFBiomeBase.highlandsCenter || world.func_72807_a(x, z) == TFBiomeBase.thornlands) continue;
                return true;
            }
        }
        return false;
    }

    protected int getRuneMeta(int forceFieldMeta) {
        return forceFieldMeta == 4 ? 1 : 2;
    }

    protected int getForceFieldMeta(Random decoRNG) {
        return decoRNG.nextInt(2) + 3;
    }
}

