/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import twilightforest.block.TFBlocks;

public class TileEntityTFNagastone
extends TileEntity {
    public Direction direction;
    public Facing facing;
    public Boolean neighbourDown;
    public Boolean neighbourUp;
    public Boolean neighbourEast;
    public Boolean neighbourWest;
    public Boolean neighbourNorth;
    public Boolean neighbourSouth;
    public Boolean isOutdated = true;
    public int neighbourCount;

    public TileEntityTFNagastone() {
        this.direction = Direction.SIDE;
        this.facing = Facing.EAST;
        this.field_145854_h = TFBlocks.nagastone;
        this.NoNeighbours();
    }

    public TileEntityTFNagastone(Direction dir, Facing face) {
        this.direction = dir;
        this.facing = face;
        this.isOutdated = false;
        this.field_145854_h = TFBlocks.nagastone;
        this.NoNeighbours();
    }

    public TileEntityTFNagastone(int side) {
        this.direction = this.GetDirection(side);
        this.facing = this.direction == Direction.SIDE ? this.GetFacing(side - 2) : Facing.EAST;
        this.isOutdated = false;
        this.field_145854_h = TFBlocks.nagastone;
        this.NoNeighbours();
    }

    public TileEntityTFNagastone(int side, int x, int z, float hitX, float hitZ, boolean invertFacing) {
        double vecZ;
        double vecX;
        double angle;
        this.direction = this.GetDirection(side);
        this.facing = this.direction == Direction.SIDE ? this.GetFacing(side - 2) : ((angle = Math.atan2(vecX = (double)(hitX - ((float)x + 0.5f)), vecZ = (double)(hitZ - ((float)z + 0.5f)))) >= 0.7853981633974483 && angle < 2.356194490192345 ? Facing.EAST : (angle >= 2.356194490192345 || angle < -2.356194490192345 ? Facing.NORTH : (angle >= -2.356194490192345 && angle < -0.7853981633974483 ? Facing.WEST : Facing.SOUTH)));
        if (invertFacing) {
            switch (this.facing) {
                default: {
                    this.facing = Facing.WEST;
                    break;
                }
                case WEST: {
                    this.facing = Facing.EAST;
                    break;
                }
                case SOUTH: {
                    this.facing = Facing.NORTH;
                    break;
                }
                case NORTH: {
                    this.facing = Facing.SOUTH;
                }
            }
        }
        this.isOutdated = false;
        this.field_145854_h = TFBlocks.nagastone;
        this.NoNeighbours();
    }

    public TileEntityTFNagastone(int side, float hitX, float hitZ) {
        double vecZ;
        double vecX;
        double angle;
        this.direction = this.GetDirection(side);
        this.facing = this.direction == Direction.SIDE ? this.GetFacing(side - 2) : ((angle = Math.atan2(vecX = (double)(hitX - 0.5f), vecZ = (double)(hitZ - 0.5f))) >= 0.7853981633974483 && angle < 2.356194490192345 ? Facing.EAST : (angle >= 2.356194490192345 || angle < -2.356194490192345 ? Facing.NORTH : (angle >= -2.356194490192345 && angle < -0.7853981633974483 ? Facing.WEST : Facing.SOUTH)));
        this.isOutdated = false;
        this.field_145854_h = TFBlocks.nagastone;
        this.NoNeighbours();
    }

    public void SetDirections(Direction dir, Facing face) {
        this.direction = dir;
        this.facing = face;
        this.isOutdated = false;
    }

    private Direction GetDirection(int d) {
        switch (d) {
            case 0: {
                return Direction.DOWN;
            }
            case 1: {
                return Direction.UP;
            }
        }
        return Direction.SIDE;
    }

    private Facing GetFacing(int f) {
        switch (f) {
            default: {
                return Facing.EAST;
            }
            case 1: {
                return Facing.WEST;
            }
            case 2: {
                return Facing.NORTH;
            }
            case 3: 
        }
        return Facing.SOUTH;
    }

    public void NoNeighbours() {
        this.neighbourDown = false;
        this.neighbourUp = false;
        this.neighbourEast = false;
        this.neighbourWest = false;
        this.neighbourNorth = false;
        this.neighbourSouth = false;
        this.neighbourCount = 0;
    }

    public int UpdateNeighbourCount() {
        this.neighbourCount = (this.neighbourDown != false ? 1 : 0) + (this.neighbourUp != false ? 1 : 0) + (this.neighbourEast != false ? 1 : 0) + (this.neighbourWest != false ? 1 : 0) + (this.neighbourNorth != false ? 1 : 0) + (this.neighbourSouth != false ? 1 : 0);
        return this.neighbourCount;
    }

    public ConnectionType GetConnectionType(int side) {
        ConnectionType ct = ConnectionType.NO;
        int x = -1;
        block0 : switch (side) {
            default: {
                break;
            }
            case 0: 
            case 1: {
                x = this.UpdateNeighbourCount() - (this.neighbourDown != false ? 1 : 0) - (this.neighbourUp != false ? 1 : 0);
                switch (x) {
                    default: {
                        break;
                    }
                    case 1: {
                        if (this.neighbourEast.booleanValue()) {
                            ct = ConnectionType.E;
                            break;
                        }
                        if (this.neighbourWest.booleanValue()) {
                            ct = ConnectionType.W;
                            break;
                        }
                        if (this.neighbourNorth.booleanValue()) {
                            ct = ConnectionType.N;
                            break;
                        }
                        if (!this.neighbourSouth.booleanValue()) break block0;
                        ct = ConnectionType.S;
                        break;
                    }
                    case 2: {
                        if (this.neighbourEast.booleanValue()) {
                            if (this.neighbourNorth.booleanValue()) {
                                ct = ConnectionType.EN;
                                break;
                            }
                            if (this.neighbourWest.booleanValue()) {
                                ct = ConnectionType.EW;
                                break;
                            }
                            ct = ConnectionType.ES;
                            break;
                        }
                        if (this.neighbourWest.booleanValue()) {
                            if (this.neighbourNorth.booleanValue()) {
                                ct = ConnectionType.WN;
                                break;
                            }
                            ct = ConnectionType.WS;
                            break;
                        }
                        ct = ConnectionType.NS;
                        break;
                    }
                    case 3: {
                        if (!this.neighbourEast.booleanValue()) {
                            ct = ConnectionType.triE;
                            break;
                        }
                        if (!this.neighbourWest.booleanValue()) {
                            ct = ConnectionType.triW;
                            break;
                        }
                        if (!this.neighbourNorth.booleanValue()) {
                            ct = ConnectionType.triN;
                            break;
                        }
                        ct = ConnectionType.triS;
                        break;
                    }
                    case 4: {
                        ct = ConnectionType.CROSS;
                        break;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                x = this.UpdateNeighbourCount() - (this.neighbourEast != false ? 1 : 0) - (this.neighbourWest != false ? 1 : 0);
                switch (x) {
                    default: {
                        break;
                    }
                    case 1: {
                        if (this.neighbourDown.booleanValue()) {
                            ct = ConnectionType.D;
                            break;
                        }
                        if (this.neighbourUp.booleanValue()) {
                            ct = ConnectionType.U;
                            break;
                        }
                        if (this.neighbourNorth.booleanValue()) {
                            ct = ConnectionType.N;
                            break;
                        }
                        if (!this.neighbourSouth.booleanValue()) break block0;
                        ct = ConnectionType.S;
                        break;
                    }
                    case 2: {
                        if (this.neighbourDown.booleanValue()) {
                            if (this.neighbourNorth.booleanValue()) {
                                ct = ConnectionType.DN;
                                break;
                            }
                            if (this.neighbourUp.booleanValue()) {
                                ct = ConnectionType.UD;
                                break;
                            }
                            ct = ConnectionType.DS;
                            break;
                        }
                        if (this.neighbourUp.booleanValue()) {
                            if (this.neighbourNorth.booleanValue()) {
                                ct = ConnectionType.UN;
                                break;
                            }
                            ct = ConnectionType.US;
                            break;
                        }
                        ct = ConnectionType.NS;
                        break;
                    }
                    case 3: {
                        if (!this.neighbourUp.booleanValue()) {
                            ct = ConnectionType.triU;
                            break;
                        }
                        if (!this.neighbourDown.booleanValue()) {
                            ct = ConnectionType.triD;
                            break;
                        }
                        if (!this.neighbourNorth.booleanValue()) {
                            ct = ConnectionType.triN;
                            break;
                        }
                        ct = ConnectionType.triS;
                        break;
                    }
                    case 4: {
                        ct = ConnectionType.CROSS;
                        break;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                x = this.UpdateNeighbourCount() - (this.neighbourNorth != false ? 1 : 0) - (this.neighbourSouth != false ? 1 : 0);
                switch (x) {
                    default: {
                        break block0;
                    }
                    case 1: {
                        if (this.neighbourDown.booleanValue()) {
                            ct = ConnectionType.D;
                            break block0;
                        }
                        if (this.neighbourUp.booleanValue()) {
                            ct = ConnectionType.U;
                            break block0;
                        }
                        if (this.neighbourEast.booleanValue()) {
                            ct = ConnectionType.E;
                            break block0;
                        }
                        if (!this.neighbourWest.booleanValue()) break block0;
                        ct = ConnectionType.W;
                        break block0;
                    }
                    case 2: {
                        if (this.neighbourDown.booleanValue()) {
                            if (this.neighbourEast.booleanValue()) {
                                ct = ConnectionType.DE;
                                break block0;
                            }
                            if (this.neighbourUp.booleanValue()) {
                                ct = ConnectionType.UD;
                                break block0;
                            }
                            ct = ConnectionType.DW;
                            break block0;
                        }
                        if (this.neighbourUp.booleanValue()) {
                            if (this.neighbourEast.booleanValue()) {
                                ct = ConnectionType.UE;
                                break block0;
                            }
                            ct = ConnectionType.UW;
                            break block0;
                        }
                        ct = ConnectionType.EW;
                        break block0;
                    }
                    case 3: {
                        if (!this.neighbourUp.booleanValue()) {
                            ct = ConnectionType.triU;
                            break block0;
                        }
                        if (!this.neighbourDown.booleanValue()) {
                            ct = ConnectionType.triD;
                            break block0;
                        }
                        if (!this.neighbourEast.booleanValue()) {
                            ct = ConnectionType.triE;
                            break block0;
                        }
                        ct = ConnectionType.triW;
                        break block0;
                    }
                    case 4: {
                        ct = ConnectionType.CROSS;
                    }
                }
            }
        }
        return ct;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("Direction")) {
            this.direction = this.GetDirection(par1NBTTagCompound.func_74762_e("Direction"));
        }
        if (par1NBTTagCompound.func_74764_b("Facing")) {
            this.facing = this.GetFacing(par1NBTTagCompound.func_74762_e("Facing"));
        }
        if (par1NBTTagCompound.func_74764_b("NeighDown")) {
            this.neighbourDown = par1NBTTagCompound.func_74767_n("NeighDown");
        }
        if (par1NBTTagCompound.func_74764_b("NeighUp")) {
            this.neighbourUp = par1NBTTagCompound.func_74767_n("NeighUp");
        }
        if (par1NBTTagCompound.func_74764_b("NeighEast")) {
            this.neighbourEast = par1NBTTagCompound.func_74767_n("NeighEast");
        }
        if (par1NBTTagCompound.func_74764_b("NeighWest")) {
            this.neighbourWest = par1NBTTagCompound.func_74767_n("NeighWest");
        }
        if (par1NBTTagCompound.func_74764_b("NeighNorth")) {
            this.neighbourNorth = par1NBTTagCompound.func_74767_n("NeighNorth");
        }
        if (par1NBTTagCompound.func_74764_b("NeighSouth")) {
            this.neighbourSouth = par1NBTTagCompound.func_74767_n("NeighSouth");
        }
        if (par1NBTTagCompound.func_74764_b("IsOutdated")) {
            this.isOutdated = par1NBTTagCompound.func_74767_n("IsOutdated");
        }
        if (par1NBTTagCompound.func_74764_b("NeighbourCount")) {
            this.neighbourCount = par1NBTTagCompound.func_74762_e("NeighbourCount");
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        if (this.direction != null) {
            par1NBTTagCompound.func_74768_a("Direction", this.direction.ordinal());
        }
        if (this.facing != null) {
            par1NBTTagCompound.func_74768_a("Facing", this.facing.ordinal());
        }
        par1NBTTagCompound.func_74757_a("NeighDown", this.neighbourDown.booleanValue());
        par1NBTTagCompound.func_74757_a("NeighUp", this.neighbourUp.booleanValue());
        par1NBTTagCompound.func_74757_a("NeighEast", this.neighbourEast.booleanValue());
        par1NBTTagCompound.func_74757_a("NeighWest", this.neighbourWest.booleanValue());
        par1NBTTagCompound.func_74757_a("NeighNorth", this.neighbourNorth.booleanValue());
        par1NBTTagCompound.func_74757_a("NeighSouth", this.neighbourSouth.booleanValue());
        par1NBTTagCompound.func_74757_a("IsOutdated", this.isOutdated.booleanValue());
        par1NBTTagCompound.func_74768_a("NeighbourCount", this.neighbourCount);
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
    }

    public static enum Direction {
        DOWN,
        UP,
        SIDE;

    }

    public static enum Facing {
        EAST,
        WEST,
        NORTH,
        SOUTH;

    }

    public static enum ConnectionType {
        NO,
        D,
        U,
        E,
        W,
        N,
        S,
        DE,
        DW,
        DN,
        DS,
        UE,
        UW,
        UN,
        US,
        UD,
        EW,
        EN,
        ES,
        WN,
        WS,
        NS,
        triD,
        triU,
        triE,
        triW,
        triN,
        triS,
        CROSS;

    }
}

