/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressed;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.renderer.BetterIconFlipped;
import twilightforest.item.TFItems;

public class BlockTFCompressed
extends BlockCompressed {
    public BlockType type;
    public IIcon[] fieryPattern;
    public IIcon[] fieryCore;

    protected BlockTFCompressed(BlockType blockType) {
        super(BlockTFCompressed.typeToMapColor(blockType));
        this.type = blockType;
        float hardness = 0.0f;
        float resistance = 0.0f;
        Block.SoundType stepSound = null;
        String textureName = "";
        switch (this.type) {
            case ARCTIC_FUR: {
                hardness = 0.8f;
                stepSound = field_149775_l;
                textureName = "arctic_fur_block";
                break;
            }
            case CARMINITE: {
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149777_j;
                textureName = "carminite_block";
                break;
            }
            case FIERY_METAL: {
                this.func_149715_a(0.5f);
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149777_j;
                textureName = "fiery_block";
                break;
            }
            default: {
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149777_j;
                textureName = "ironwood_block";
                break;
            }
            case STEELEAF: {
                hardness = 5.0f;
                resistance = 10.0f;
                stepSound = field_149779_h;
                textureName = "steeleaf_block";
            }
        }
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(stepSound);
        this.func_149658_d("TwilightForest:" + textureName);
        this.func_149647_a(TFItems.creativeTab);
    }

    private static MapColor typeToMapColor(BlockType blockType) {
        MapColor mapColor = null;
        switch (blockType) {
            case ARCTIC_FUR: {
                mapColor = MapColor.field_151659_e;
                break;
            }
            case CARMINITE: {
                mapColor = MapColor.field_151656_f;
                break;
            }
            case FIERY_METAL: {
                mapColor = MapColor.field_151655_K;
                break;
            }
            case IRONWOOD: {
                mapColor = MapColor.field_151668_h;
                break;
            }
            case STEELEAF: {
                mapColor = MapColor.field_151669_i;
            }
        }
        return mapColor;
    }

    public AxisAlignedBB func_149668_a(World worldIn, int x, int y, int z) {
        if (this.type == BlockType.FIERY_METAL) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + 0.99f), (double)(z + 1));
        }
        return super.func_149668_a(worldIn, x, y, z);
    }

    public void func_149670_a(World worldIn, int x, int y, int z, Entity entityIn) {
        if (this.type == BlockType.FIERY_METAL) {
            if (entityIn.func_70093_af()) {
                return;
            }
            if (entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71071_by.field_70460_b[0] != null && ((EntityPlayer)entityIn).field_71071_by.field_70460_b[0].func_77973_b() == TFItems.fieryBoots) {
                return;
            }
            if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_71124_b(1) != null && ((EntityLivingBase)entityIn).func_71124_b(1).func_77973_b() == TFItems.fieryBoots) {
                return;
            }
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
    }

    public void func_149746_a(World worldIn, int x, int y, int z, Entity entityIn, float fallDistance) {
        switch (this.type) {
            case ARCTIC_FUR: {
                entityIn.field_70143_R = (float)((double)entityIn.field_70143_R * 0.25);
                break;
            }
            case STEELEAF: {
                entityIn.field_70143_R = (float)((double)entityIn.field_70143_R * 0.75);
                break;
            }
        }
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return true;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.type == BlockType.FIERY_METAL && side == ForgeDirection.UP;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149677_c(IBlockAccess worldIn, int x, int y, int z) {
        if (this.type == BlockType.FIERY_METAL) {
            return 255;
        }
        return super.func_149677_c(worldIn, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess worldIn, int x, int y, int z) {
        if (this.type == BlockType.FIERY_METAL) {
            return 0xFFFFFF;
        }
        return super.func_149720_d(worldIn, x, y, z);
    }

    public boolean canConnectFieryTo(IBlockAccess worldIn, int x, int y, int z) {
        return worldIn.func_147439_a(x, y, z) == TFBlocks.fieryMetalStorage;
    }

    public boolean func_149686_d() {
        return this.type != BlockType.FIERY_METAL;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (this.type == BlockType.FIERY_METAL) {
            return side == ForgeDirection.UP;
        }
        return true;
    }

    public int func_149645_b() {
        if (this.type == BlockType.FIERY_METAL) {
            return TwilightForestMod.proxy.getFieryMetalBlockRenderID();
        }
        return super.func_149645_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.fieryPattern = new IIcon[4];
        this.fieryPattern[0] = reg.func_94245_a("TwilightForest:fiery_pattern");
        this.fieryPattern[1] = new BetterIconFlipped(this.fieryPattern[0], true, false);
        this.fieryPattern[2] = new BetterIconFlipped(this.fieryPattern[0], false, true);
        this.fieryPattern[3] = new BetterIconFlipped(this.fieryPattern[0], true, true);
        this.fieryCore = new IIcon[5];
        this.fieryCore[0] = reg.func_94245_a("TwilightForest:fiery_block_inner");
        this.fieryCore[1] = reg.func_94245_a("TwilightForest:fiery_block_inner_horizontal");
        this.fieryCore[2] = reg.func_94245_a("TwilightForest:fiery_block_inner_vertical");
        this.fieryCore[3] = reg.func_94245_a("TwilightForest:fiery_block_inner_cross");
        this.fieryCore[4] = reg.func_94245_a("TwilightForest:fiery_block_inner_full");
        super.func_149651_a(reg);
    }

    public static enum BlockType {
        ARCTIC_FUR,
        CARMINITE,
        FIERY_METAL,
        IRONWOOD,
        STEELEAF;

    }
}

