/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import java.util.stream.IntStream;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

final class WaterTankRateCalculator {
    private final float ONE = 1.0f;
    private final float BASE_HUMIDITY_RATE = 10.0f;
    private final float OUTSIDE_RATE = 0.5f;
    private final float SNOW_RATE = 0.5f;
    private final float RAIN_RATE = 3.0f;
    private static final float RATE_TICK_RATIO = 0.125f;
    private World world;
    private int x;
    private int y;
    private int z;
    private float rate;
    private float humidityRate;
    private float outsideRate;
    private float snowingOrRainingRate;

    WaterTankRateCalculator(TileMultiBlock multiBlock) {
        this.world = multiBlock.getWorld();
        this.x = multiBlock.getMasterBlock().field_145851_c;
        this.y = multiBlock.getMasterBlock().field_145848_d;
        this.z = multiBlock.getMasterBlock().field_145849_e;
    }

    public static float convertRateToLitersPerSecond(float rate) {
        return rate * 0.125f * 20.0f;
    }

    public WaterTankRateCalculator init() {
        this.humidityRate = this.calculateHumidityRate();
        this.outsideRate = this.calculateOutsideRate();
        this.snowingOrRainingRate = this.calculateSnowingOrRainingRate();
        this.rate = Math.max((float)MathHelper.func_76141_d((float)(this.humidityRate * this.outsideRate * this.snowingOrRainingRate)), 1.0f);
        return this;
    }

    private float calculateHumidityRate() {
        return 10.0f * this.world.func_72807_a((int)this.x, (int)this.z).field_76751_G;
    }

    private float calculateOutsideRate() {
        IntStream streamX = IntStream.rangeClosed(this.x - 1, this.x + 1);
        return streamX.anyMatch(eachX -> {
            IntStream streamZ = IntStream.rangeClosed(this.z - 1, this.z + 1);
            return streamZ.anyMatch(eachZ -> !this.world.func_72937_j(eachX, this.y + 3, eachZ));
        }) ? 0.5f : 1.0f;
    }

    private float calculateSnowingOrRainingRate() {
        if (!this.world.func_72896_J()) {
            return 1.0f;
        }
        return this.world.func_72807_a(this.x, this.z).func_76746_c() ? 0.5f : 3.0f;
    }

    public float getRate() {
        return this.rate;
    }

    public float getHumidityRate() {
        return this.humidityRate;
    }

    public float getOutsideRate() {
        return this.outsideRate;
    }

    public float getSnowingOrRainingRate() {
        return this.snowingOrRainingRate;
    }

    public boolean getIsSnowing() {
        return this.snowingOrRainingRate == 0.5f;
    }

    public boolean getIsRaining() {
        return this.snowingOrRainingRate == 3.0f;
    }

    public boolean getIsOutside() {
        return this.outsideRate == 0.5f;
    }
}

