/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import tterrag.wailaplugins.WailaPlugins;
import tterrag.wailaplugins.api.IPlugin;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.config.WPConfigHandler;

public enum PluginRegistrar {
    INSTANCE;

    public List<IPlugin> allPlugins = Lists.newArrayList();

    public void preInit(FMLPreInitializationEvent event) {
        Set datas = event.getAsmData().getAll(Plugin.class.getName());
        ConfigHandler cfg = ConfigHandler.instance();
        WailaPlugins.logger.info("Beginning plugin registration: {} candidates found.", new Object[]{datas.size()});
        for (ASMDataTable.ASMData data : datas) {
            List deps;
            Map annotationInfo = data.getAnnotationInfo();
            String name = (String)annotationInfo.get("name");
            if (Strings.isNullOrEmpty((String)name)) {
                name = null;
            }
            if (this.allModsLoaded(deps = (List)annotationInfo.get("deps"))) {
                if (name == null) {
                    if (deps.isEmpty()) {
                        throw new IllegalArgumentException("Name and deps cannot both be null! Culprit: " + data.getClassName());
                    }
                    name = PluginRegistrar.getModContainerFromID((String)deps.get(0)).getName();
                }
                boolean failed = false;
                if (WPConfigHandler.INSTANCE.isPluginEnabled(name)) {
                    WailaPlugins.logger.info("Attempting to create plugin {}.", new Object[]{name});
                    try {
                        Class<?> clazz = Class.forName(data.getClassName());
                        if (IPlugin.class.isAssignableFrom(clazz)) {
                            try {
                                IPlugin inst = (IPlugin)clazz.newInstance();
                                cfg.addConfig("WAILA Plugins", name, name);
                                this.allPlugins.add(inst);
                            }
                            catch (IllegalAccessException e) {
                                WailaPlugins.logger.error("Construtor for class " + clazz.getName() + " could not be accessed.");
                                failed = true;
                            }
                            catch (InstantiationException e) {
                                WailaPlugins.logger.error("Class " + clazz.getName() + " does not have a default constructor");
                                failed = true;
                            }
                        } else {
                            WailaPlugins.logger.error("Class " + clazz.getName() + " does not implement IPlugin and could not be loaded.");
                        }
                    }
                    catch (Throwable e) {
                        WailaPlugins.logger.fatal("Plugin {} threw an error on classload. Skipping...", new Object[]{name});
                        e.printStackTrace();
                        failed = true;
                    }
                    if (failed) {
                        WailaPlugins.logger.fatal("Failed to create plugin {}.", new Object[]{name});
                        continue;
                    }
                    WailaPlugins.logger.info("Successfully created plugin {}.", new Object[]{name});
                    continue;
                }
                WailaPlugins.logger.info("Skipping over plugin {} as it was disabled.", new Object[]{name});
                continue;
            }
            if (name == null) {
                name = (String)deps.get(0);
            }
            String[] unfound = this.getUnfoundDeps(deps);
            WailaPlugins.logger.info("Skipping over plugin {} as its dependencies {} were not found.", new Object[]{name, unfound});
        }
        WailaPlugins.logger.info("Sorting plugins. Before: {}", new Object[]{this.allPlugins});
        Collections.sort(this.allPlugins, new Comparator<IPlugin>(){

            @Override
            public int compare(IPlugin o1, IPlugin o2) {
                Plugin order1 = o1.getClass().getAnnotation(Plugin.class);
                Plugin order2 = o2.getClass().getAnnotation(Plugin.class);
                int i1 = order1 == null ? 0 : order1.order();
                int i2 = order2 == null ? 0 : order2.order();
                return Double.compare(i1, i2);
            }
        });
        WailaPlugins.logger.info("Sorting plugins. After:  {}", new Object[]{this.allPlugins});
        for (IPlugin p : this.allPlugins) {
            String name = PluginRegistrar.getPluginName(p.getClass());
            try {
                p.load((IWailaRegistrar)ModuleRegistrar.instance());
                WailaPlugins.logger.info("Successfully loaded plugin {}.", new Object[]{name});
            }
            catch (Throwable e) {
                WailaPlugins.logger.fatal("Plugin {} threw an error on init. Skipping...", new Object[]{name});
                e.printStackTrace();
            }
        }
        WailaPlugins.logger.info("Completed plugin registration. {} plugins registered.", new Object[]{this.allPlugins.size()});
    }

    private boolean allModsLoaded(Iterable<String> mods) {
        if (mods == null) {
            return true;
        }
        for (String s : mods) {
            if (Loader.isModLoaded((String)s)) continue;
            return false;
        }
        return true;
    }

    private String[] getUnfoundDeps(Iterable<String> mods) {
        if (mods == null) {
            return new String[0];
        }
        ArrayList ret = Lists.newArrayList();
        for (String s : mods) {
            if (Loader.isModLoaded((String)s)) continue;
            ret.add(s);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public void postInit() {
        for (IPlugin p : this.allPlugins) {
            p.postLoad();
        }
    }

    public static String getPluginName(Class<?> c) {
        Plugin p = c.getAnnotation(Plugin.class);
        if (p == null) {
            return null;
        }
        String name = p.name();
        if (name.isEmpty() && p.deps().length > 0) {
            name = p.deps()[0];
        }
        return name;
    }

    public static ModContainer getModContainerFromID(String modid) {
        for (ModContainer c : Loader.instance().getModList()) {
            if (!c.getModId().equals(modid)) continue;
            return c;
        }
        return null;
    }
}

