/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.ClientUtils;
import codechicken.wirelessredstone.addons.ClientMapInfo;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WirelessMapNodeStorage;
import codechicken.wirelessredstone.addons.WirelessRedstoneAddons;
import codechicken.wirelessredstone.core.FreqCoord;
import codechicken.wirelessredstone.core.RedstoneEther;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class WirelessMapRenderer
implements IItemRenderer {
    private void renderPass(int xCenter, int zCenter, int scale, WirelessMapNodeStorage mapstorage, long worldTime, float size, float alpha, float light) {
        float zrot;
        float xrot;
        float rot;
        float b;
        float g;
        float r;
        int colour;
        float relz;
        float relx;
        Tessellator tessellator = Tessellator.field_78398_a;
        float blockscale = 1 << scale;
        for (FreqCoord node : mapstorage.nodes) {
            relx = (float)node.x / blockscale + 64.0f;
            relz = (float)node.z / blockscale + 64.0f;
            colour = RedstoneEther.client().getFreqColour(node.freq);
            if (colour == -1) {
                colour = -65536;
            }
            r = (float)(colour >> 16 & 0xFF) / 255.0f * light;
            g = (float)(colour >> 8 & 0xFF) / 255.0f * light;
            b = (float)(colour & 0xFF) / 255.0f * light;
            tessellator.func_78369_a(r, g, b, alpha);
            rot = RedstoneEther.getRotation(ClientUtils.getRenderTime(), node.freq);
            xrot = (float)(Math.sin(rot) * (double)size);
            zrot = (float)(Math.cos(rot) * (double)size);
            tessellator.func_78377_a((double)(relx - zrot), (double)(relz + xrot), -0.01);
            tessellator.func_78377_a((double)(relx + xrot), (double)(relz + zrot), -0.01);
            tessellator.func_78377_a((double)(relx + zrot), (double)(relz - xrot), -0.01);
            tessellator.func_78377_a((double)(relx - xrot), (double)(relz - zrot), -0.01);
        }
        for (FreqCoord node : mapstorage.devices) {
            relx = (float)(node.x - xCenter) / blockscale + 64.0f;
            relz = (float)(node.z - zCenter) / blockscale + 64.0f;
            colour = RedstoneEther.client().getFreqColour(node.freq);
            if (colour == -1) {
                colour = -65536;
            }
            r = (float)(colour >> 16 & 0xFF) / 255.0f * light;
            g = (float)(colour >> 8 & 0xFF) / 255.0f * light;
            b = (float)(colour & 0xFF) / 255.0f * light;
            tessellator.func_78369_a(r, g, b, alpha);
            rot = RedstoneEther.getRotation(ClientUtils.getRenderTime(), node.freq);
            xrot = (float)(Math.sin(rot) * (double)size);
            zrot = (float)(Math.cos(rot) * (double)size);
            tessellator.func_78377_a((double)(relx - zrot), (double)(relz + xrot), -0.01);
            tessellator.func_78377_a((double)(relx + xrot), (double)(relz + zrot), -0.01);
            tessellator.func_78377_a((double)(relx + zrot), (double)(relz - xrot), -0.01);
            tessellator.func_78377_a((double)(relx - xrot), (double)(relz - zrot), -0.01);
        }
    }

    public void renderMap(EntityPlayer player, MapData mapData, boolean inFrame) {
        Minecraft.func_71410_x().field_71460_t.func_147701_i().func_148250_a(mapData, inFrame);
        WirelessMapNodeStorage mapstorage = RedstoneEtherAddons.client().getMapNodes();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        float light = 1.0f;
        long worldTime = player.field_70170_p.func_82737_E();
        ItemStack currentitem = player.field_71071_by.func_70448_g();
        if (currentitem == null || currentitem.func_77973_b() != WirelessRedstoneAddons.wirelessMap) {
            return;
        }
        ClientMapInfo mapinfo = RedstoneEtherAddons.client().getMPMapInfo((short)currentitem.func_77960_j());
        if (mapinfo == null) {
            return;
        }
        int xCenter = mapinfo.xCenter;
        int zCenter = mapinfo.zCenter;
        byte scale = mapinfo.scale;
        tessellator.func_78382_b();
        this.renderPass(xCenter, zCenter, scale, mapstorage, worldTime, 0.75f, 1.0f, light * 0.5f);
        this.renderPass(xCenter, zCenter, scale, mapstorage, worldTime, 0.6f, 1.0f, light);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderMap((EntityPlayer)data[0], (MapData)data[2], false);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }
}

