/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import squeek.wailaharvestability.Config;
import squeek.wailaharvestability.helpers.BlockHelper;
import squeek.wailaharvestability.helpers.ColorHelper;
import squeek.wailaharvestability.helpers.OreHelper;
import squeek.wailaharvestability.helpers.StringHelper;
import squeek.wailaharvestability.helpers.ToolHelper;
import squeek.wailaharvestability.proxy.ProxyCreativeBlocks;
import squeek.wailaharvestability.proxy.ProxyGregTech;

public class WailaHandler
implements IWailaDataProvider {
    public static HashMap<String, Boolean> configOptions = new HashMap();

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> toolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return toolTip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> toolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int meta;
        Block block = accessor.getBlock();
        if (ProxyCreativeBlocks.isCreativeBlock(block, meta = accessor.getMetadata())) {
            return toolTip;
        }
        EntityPlayer player = accessor.getPlayer();
        if (itemStack.func_77973_b() instanceof ItemBlock && !ProxyGregTech.isOreBlock(block) && !ProxyGregTech.isCasing(block) && !ProxyGregTech.isMachine(block)) {
            block = Block.func_149634_a((Item)itemStack.func_77973_b());
            meta = itemStack.func_77960_j();
        }
        boolean minimalLayout = config.getConfig("harvestability.minimal", false);
        ArrayList<String> stringParts = new ArrayList<String>();
        this.getHarvestability(stringParts, player, block, meta, accessor.getPosition(), config, minimalLayout);
        if (!stringParts.isEmpty()) {
            if (minimalLayout) {
                toolTip.add(StringHelper.concatenateStringList(stringParts, EnumChatFormatting.RESET + Config.MINIMAL_SEPARATOR_STRING));
            } else {
                toolTip.addAll(stringParts);
            }
        }
        return toolTip;
    }

    public void getHarvestability(List<String> stringList, EntityPlayer player, Block block, int meta, MovingObjectPosition position, IWailaConfigHandler config, boolean minimalLayout) {
        boolean isSneaking = player.func_70093_af();
        boolean showHarvestLevel = config.getConfig("harvestability.harvestlevel") && (!config.getConfig("harvestability.harvestlevel.sneakingonly") || isSneaking);
        boolean showHarvestLevelNum = config.getConfig("harvestability.harvestlevelnum") && (!config.getConfig("harvestability.harvestlevelnum.sneakingonly") || isSneaking);
        boolean showEffectiveTool = config.getConfig("harvestability.effectivetool") && (!config.getConfig("harvestability.effectivetool.sneakingonly") || isSneaking);
        boolean showCurrentlyHarvestable = config.getConfig("harvestability.currentlyharvestable") && (!config.getConfig("harvestability.currentlyharvestable.sneakingonly") || isSneaking);
        boolean hideWhileHarvestable = config.getConfig("harvestability.unharvestableonly", false);
        boolean showOresOnly = config.getConfig("harvestability.oresonly", false);
        boolean toolRequiredOnly = config.getConfig("harvestability.toolrequiredonly");
        if (showHarvestLevel || showEffectiveTool || showCurrentlyHarvestable) {
            String currentlyHarvestable;
            boolean isCurrentlyHarvestable;
            if (showOresOnly && !OreHelper.isBlockAnOre(block, meta)) {
                return;
            }
            if (!player.func_82246_f(position.field_72311_b, position.field_72312_c, position.field_72309_d) || BlockHelper.isBlockUnbreakable(block, player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d)) {
                String unbreakableString = ColorHelper.getBooleanColor(false) + Config.NOT_CURRENTLY_HARVESTABLE_STRING + (!minimalLayout ? EnumChatFormatting.RESET + StatCollector.func_74838_a((String)"wailaharvestability.harvestable") : "");
                stringList.add(unbreakableString);
                return;
            }
            if (meta >= 16) {
                meta = 0;
            }
            int harvestLevel = block.getHarvestLevel(meta);
            String effectiveTool = BlockHelper.getEffectiveToolOf(player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d, block, meta);
            if (effectiveTool != null && harvestLevel < 0) {
                harvestLevel = 0;
            }
            boolean blockHasEffectiveTools = harvestLevel >= 0 && effectiveTool != null;
            String shearability = this.getShearabilityString(player, block, meta, position, config);
            String silkTouchability = this.getSilkTouchabilityString(player, block, meta, position, config);
            if (toolRequiredOnly && block.func_149688_o().func_76229_l() && !blockHasEffectiveTools && shearability.isEmpty() && silkTouchability.isEmpty()) {
                return;
            }
            boolean canHarvest = false;
            boolean isEffective = false;
            boolean isAboveMinHarvestLevel = false;
            boolean isHoldingTinkersTool = false;
            ItemStack itemHeld = player.func_70694_bm();
            if (itemHeld != null) {
                isHoldingTinkersTool = ToolHelper.hasToolTag(itemHeld);
                canHarvest = ToolHelper.canToolHarvestBlock(itemHeld, block, meta) || !isHoldingTinkersTool && block.canHarvestBlock(player, meta);
                isAboveMinHarvestLevel = (showCurrentlyHarvestable || showHarvestLevel) && ToolHelper.canToolHarvestLevel(itemHeld, block, meta, harvestLevel);
                isEffective = showEffectiveTool && ToolHelper.isToolEffectiveAgainst(itemHeld, block, meta, effectiveTool);
            }
            boolean bl = isCurrentlyHarvestable = canHarvest && isAboveMinHarvestLevel || !isHoldingTinkersTool && ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta);
            if (hideWhileHarvestable && isCurrentlyHarvestable) {
                return;
            }
            String string = showCurrentlyHarvestable ? ColorHelper.getBooleanColor(isCurrentlyHarvestable) + (isCurrentlyHarvestable ? Config.CURRENTLY_HARVESTABLE_STRING : Config.NOT_CURRENTLY_HARVESTABLE_STRING) + (!minimalLayout ? EnumChatFormatting.RESET + StatCollector.func_74838_a((String)"wailaharvestability.currentlyharvestable") : "") : (currentlyHarvestable = "");
            if (!(currentlyHarvestable.isEmpty() && shearability.isEmpty() && silkTouchability.isEmpty())) {
                String separator = !shearability.isEmpty() || !silkTouchability.isEmpty() ? " " : "";
                stringList.add(currentlyHarvestable + separator + silkTouchability + (!silkTouchability.isEmpty() ? separator : "") + shearability);
            }
            if (harvestLevel != -1 && showEffectiveTool && effectiveTool != null) {
                String effectiveToolString = StatCollector.func_94522_b((String)("wailaharvestability.toolclass." + effectiveTool)) ? StatCollector.func_74838_a((String)("wailaharvestability.toolclass." + effectiveTool)) : effectiveTool.substring(0, 1).toUpperCase() + effectiveTool.substring(1);
                stringList.add((!minimalLayout ? StatCollector.func_74838_a((String)"wailaharvestability.effectivetool") : "") + ColorHelper.getBooleanColor(isEffective && (!isHoldingTinkersTool || canHarvest), isHoldingTinkersTool && isEffective && !canHarvest) + effectiveToolString);
            }
            if (harvestLevel >= 1 && (showHarvestLevel || showHarvestLevelNum)) {
                String harvestLevelString = "";
                String harvestLevelName = StringHelper.stripFormatting(StringHelper.getHarvestLevelName(harvestLevel));
                String harvestLevelNum = String.valueOf(harvestLevel);
                boolean bl2 = showHarvestLevelNum = showHarvestLevelNum && (!showHarvestLevel || !harvestLevelName.equals(harvestLevelNum));
                if (showHarvestLevel) {
                    harvestLevelString = harvestLevelName + (showHarvestLevelNum ? String.format(" (%d)", harvestLevel) : "");
                } else if (showHarvestLevelNum) {
                    harvestLevelString = harvestLevelNum;
                }
                stringList.add((!minimalLayout ? StatCollector.func_74838_a((String)"wailaharvestability.harvestlevel") : "") + ColorHelper.getBooleanColor(isAboveMinHarvestLevel && canHarvest) + harvestLevelString);
            }
        }
    }

    public String getShearabilityString(EntityPlayer player, Block block, int meta, MovingObjectPosition position, IWailaConfigHandler config) {
        boolean showShearability;
        boolean isSneaking = player.func_70093_af();
        boolean bl = showShearability = config.getConfig("harvestability.shearability") && (!config.getConfig("harvestability.shearability.sneakingonly") || isSneaking);
        if (showShearability && (block instanceof IShearable || block == Blocks.field_150330_I || block == Blocks.field_150398_cm && block.func_149650_a(meta, new Random(), 0) == null)) {
            ItemStack itemHeld = player.func_70694_bm();
            boolean isHoldingShears = itemHeld != null && itemHeld.func_77973_b() instanceof ItemShears;
            boolean isShearable = isHoldingShears && ((IShearable)block).isShearable(itemHeld, (IBlockAccess)player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return ColorHelper.getBooleanColor(isShearable, !isShearable && isHoldingShears) + Config.SHEARABILITY_STRING;
        }
        return "";
    }

    public String getSilkTouchabilityString(EntityPlayer player, Block block, int meta, MovingObjectPosition position, IWailaConfigHandler config) {
        boolean showSilkTouchability;
        boolean isSneaking = player.func_70093_af();
        boolean bl = showSilkTouchability = config.getConfig("harvestability.silktouchability") && (!config.getConfig("harvestability.silktouchability.sneakingonly") || isSneaking);
        if (showSilkTouchability && block.canSilkHarvest(player.field_70170_p, player, position.field_72311_b, position.field_72312_c, position.field_72309_d, meta)) {
            boolean silkTouchMatters;
            Item itemDropped = block.func_149650_a(meta, new Random(), 0);
            boolean bl2 = silkTouchMatters = itemDropped instanceof ItemBlock && itemDropped != Item.func_150898_a((Block)block) || block.func_149745_a(new Random()) <= 0;
            if (silkTouchMatters) {
                boolean hasSilkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
                return ColorHelper.getBooleanColor(hasSilkTouch) + Config.SILK_TOUCHABILITY_STRING;
            }
        }
        return "";
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> toolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return toolTip;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        WailaHandler instance = new WailaHandler();
        for (Map.Entry<String, Boolean> entry : configOptions.entrySet()) {
            ConfigHandler.instance().getConfig(entry.getKey(), entry.getValue().booleanValue());
            registrar.addConfig("Harvestability", entry.getKey(), "option." + entry.getKey());
        }
        registrar.registerBodyProvider((IWailaDataProvider)instance, Block.class);
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    static {
        configOptions.put("harvestability.harvestlevel", true);
        configOptions.put("harvestability.harvestlevelnum", false);
        configOptions.put("harvestability.effectivetool", true);
        configOptions.put("harvestability.currentlyharvestable", true);
        configOptions.put("harvestability.harvestlevel.sneakingonly", false);
        configOptions.put("harvestability.harvestlevelnum.sneakingonly", false);
        configOptions.put("harvestability.effectivetool.sneakingonly", false);
        configOptions.put("harvestability.currentlyharvestable.sneakingonly", false);
        configOptions.put("harvestability.oresonly", false);
        configOptions.put("harvestability.minimal", false);
        configOptions.put("harvestability.unharvestableonly", false);
        configOptions.put("harvestability.toolrequiredonly", true);
        configOptions.put("harvestability.shearability", true);
        configOptions.put("harvestability.shearability.sneakingonly", false);
        configOptions.put("harvestability.silktouchability", true);
        configOptions.put("harvestability.silktouchability.sneakingonly", false);
    }
}

