/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import shukaro.warptheory.entity.EntityDropParticleFX;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.NameMetaPair;

public class MiscHelper {
    public static EntityPlayer getPlayerByName(String name) {
        for (EntityPlayer serverPlayer : (ArrayList)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!serverPlayer.func_70005_c_().equals(name)) continue;
            return serverPlayer;
        }
        return null;
    }

    public static EntityPlayer getPlayerByEntityID(int id) {
        for (EntityPlayer serverPlayer : (ArrayList)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (serverPlayer.func_145782_y() != id) continue;
            return serverPlayer;
        }
        return null;
    }

    public static boolean isOp(String name) {
        for (String n : MinecraftServer.func_71276_C().func_71203_ab().func_152606_n()) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static NBTTagCompound getWarpTag(EntityPlayer player) {
        if (!player.getEntityData().func_74764_b("WarpTheory")) {
            NBTTagCompound tag = new NBTTagCompound();
            player.getEntityData().func_74782_a("WarpTheory", (NBTBase)tag);
            return tag;
        }
        return player.getEntityData().func_74775_l("WarpTheory");
    }

    public static NBTTagCompound modEventInt(EntityPlayer player, String tagName, int amount) {
        NBTTagCompound tag = MiscHelper.getWarpTag(player);
        tag.func_74768_a(tagName, tag.func_74762_e(tagName) + amount);
        return tag;
    }

    public static boolean hasNonSolidNeighbor(World world, BlockCoord coord) {
        for (BlockCoord n : coord.getNearby()) {
            if (!n.isAir((IBlockAccess)world) && n.getBlock(world).func_149662_c()) continue;
            return true;
        }
        return false;
    }

    public static boolean canTurnToSwampWater(World world, BlockCoord coord) {
        NameMetaPair pair = new NameMetaPair(coord.getBlock(world), coord.getMeta(world));
        boolean contained = true;
        for (int i = 0; i < 6; ++i) {
            if (i == 1 || coord.copy().offset(i).getBlock(world).func_149662_c() || coord.copy().offset(i).getBlock(world) == Blocks.field_150355_j) continue;
            contained = false;
        }
        BlockCoord cover = coord.copy().offset(1);
        return !(!contained || !coord.isAir((IBlockAccess)world) && !WarpHandler.decayMappings.containsKey(pair) || !cover.isAir((IBlockAccess)world) && cover.getBlock(world) != Blocks.field_150364_r && cover.getBlock(world) != Blocks.field_150363_s && !(cover.getBlock(world) instanceof IPlantable));
    }

    public static ArrayList<IInventory> getNearbyTileInventories(EntityPlayer player, int range) {
        ArrayList<IInventory> nearby = new ArrayList<IInventory>();
        for (TileEntity te : (ArrayList)player.field_70170_p.field_147482_g) {
            BlockCoord teCoord = new BlockCoord(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            BlockCoord playerCoord = new BlockCoord((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            if (!(te instanceof IInventory) || !(teCoord.getDistance(playerCoord) <= (float)range)) continue;
            nearby.add((IInventory)te);
        }
        return nearby;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnDripParticle(World world, int x, int y, int z, float r, float g, float b) {
        if (world.func_147437_c(x, y - 2, z) && !world.func_147437_c(x, y - 1, z) && world.func_147439_a(x, y - 1, z).func_149688_o().func_76230_c()) {
            double px = (float)x + world.field_73012_v.nextFloat();
            double py = (double)y - 1.05;
            double pz = (float)z + world.field_73012_v.nextFloat();
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, r, g, b);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }
}

