/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;

public class WarpChests
extends IWarpEvent {
    private final int _mMinWarpLevel;

    public WarpChests(int pMinWarpLevel) {
        this._mMinWarpLevel = pMinWarpLevel;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return "chests";
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.chests"));
        MiscHelper.modEventInt(player, "chests", 15 + world.field_73012_v.nextInt(30));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER || e.world.func_82737_E() % 10L != 0L) {
            return;
        }
        for (EntityPlayer player : (ArrayList)e.world.field_73010_i) {
            if (!MiscHelper.getWarpTag(player).func_74764_b("chests")) continue;
            int chests = MiscHelper.getWarpTag(player).func_74762_e("chests");
            ArrayList<IInventory> inventories = MiscHelper.getNearbyTileInventories(player, 8);
            ArrayList<TileEntityChest> chestInventories = new ArrayList<TileEntityChest>();
            for (IInventory i : inventories) {
                if (!(i instanceof TileEntityChest)) continue;
                chestInventories.add((TileEntityChest)i);
            }
            if (chestInventories.size() <= 0) {
                return;
            }
            TileEntityChest inv1 = (TileEntityChest)chestInventories.get(e.world.field_73012_v.nextInt(chestInventories.size()));
            TileEntityChest inv2 = (TileEntityChest)chestInventories.get(e.world.field_73012_v.nextInt(chestInventories.size()));
            if (e.world.field_73012_v.nextInt(10) == 0) {
                if (e.world.field_73012_v.nextBoolean()) {
                    e.world.func_72908_a((double)inv1.field_145851_c, (double)inv1.field_145848_d + 0.5, (double)inv1.field_145849_e, "random.chestopen", 0.5f, e.world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                } else {
                    e.world.func_72908_a((double)inv2.field_145851_c, (double)inv2.field_145848_d + 0.5, (double)inv2.field_145849_e, "random.chestclosed", 0.5f, e.world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                MiscHelper.getWarpTag(player).func_74768_a("chests", --chests);
            }
            if (!this.shuffle(e.world.field_73012_v, (IInventory)inv1, (IInventory)inv2)) {
                this.shuffle(e.world.field_73012_v, (IInventory)inv1, (IInventory)inv2);
            }
            if (chests > 0) continue;
            MiscHelper.getWarpTag(player).func_82580_o("chests");
        }
    }

    private boolean shuffle(Random rand, IInventory inv1, IInventory inv2) {
        int firstSlot = rand.nextInt(inv1.func_70302_i_());
        int secondSlot = rand.nextInt(inv2.func_70302_i_());
        ItemStack firstContents = inv1.func_70301_a(firstSlot);
        ItemStack secondContents = inv2.func_70301_a(secondSlot);
        if (inv1.func_94041_b(firstSlot, secondContents) && inv2.func_94041_b(secondSlot, firstContents)) {
            inv1.func_70299_a(firstSlot, secondContents);
            inv2.func_70299_a(secondSlot, firstContents);
        }
        return inv1.func_94041_b(firstSlot, secondContents) && inv2.func_94041_b(secondSlot, firstContents) && (firstContents != null || secondContents != null);
    }
}

