/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import shukaro.warptheory.handlers.ConfigHandler;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.NameMetaPair;

public class WarpDecay
extends IWarpEvent {
    private final int _mMinWarpLevel;

    public WarpDecay(int pMinWarpLevel) {
        this._mMinWarpLevel = pMinWarpLevel;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return "biomeDecay";
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean canDo(EntityPlayer player) {
        for (String n : MiscHelper.getWarpTag(player).func_150296_c()) {
            if (!n.startsWith("biome") || n.equals(this.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.decay"));
        MiscHelper.modEventInt(player, this.getName(), 512 + world.field_73012_v.nextInt(256));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (!ConfigHandler.allowGlobalWarpEffects) {
            return;
        }
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        for (EntityPlayer player : (ArrayList)e.world.field_73010_i) {
            if (!MiscHelper.getWarpTag(player).func_74764_b("biomeDecay")) continue;
            int decay = MiscHelper.getWarpTag(player).func_74762_e("biomeDecay");
            int targetX = (int)player.field_70165_t + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8);
            int targetY = (int)player.field_70163_u + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8);
            int targetZ = (int)player.field_70161_v + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8);
            BlockCoord target = new BlockCoord(targetX, targetY, targetZ);
            NameMetaPair pair = new NameMetaPair(target.getBlock(e.world), target.getMeta(e.world));
            if (!MiscHelper.hasNonSolidNeighbor(e.world, target)) {
                return;
            }
            if (!WarpHandler.decayMappings.containsKey(pair) && !(pair.getBlock() instanceof IPlantable) && pair.getBlock().func_149688_o() != Material.field_151584_j) continue;
            NameMetaPair decayed = WarpHandler.decayMappings.get(pair);
            if (decayed == null) {
                decayed = new NameMetaPair(Blocks.field_150350_a, 0);
            }
            if (!e.world.func_147465_d(target.x, target.y, target.z, decayed.getBlock(), decayed.getMetadata(), 3)) continue;
            if (target.isAir((IBlockAccess)e.world)) {
                e.world.func_72889_a(null, 2001, target.x, target.y, target.z, Block.func_149682_b((Block)pair.getBlock()) + (pair.getMetadata() << 12));
            }
            MiscHelper.getWarpTag(player).func_74768_a("biomeDecay", --decay);
            if (decay > 0) continue;
            MiscHelper.getWarpTag(player).func_82580_o("biomeDecay");
        }
    }
}

