/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.ConfigHandler;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;

public class WarpWither
extends IWarpEvent {
    private final int _mMinWarpLevel;

    public WarpWither(int pMinWarpLevel) {
        this._mMinWarpLevel = pMinWarpLevel;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return "wither";
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.wither"));
        MiscHelper.modEventInt(player, "wither", 1);
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (!ConfigHandler.allowGlobalWarpEffects) {
            return;
        }
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        block0: for (EntityPlayer player : (ArrayList)e.world.field_73010_i) {
            if (!MiscHelper.getWarpTag(player).func_74764_b("wither")) continue;
            int wither = MiscHelper.getWarpTag(player).func_74762_e("wither");
            for (int i = 0; i < 6; ++i) {
                int targetZ;
                int targetY;
                int targetX = (int)player.field_70165_t + e.world.field_73012_v.nextInt(4) - e.world.field_73012_v.nextInt(4);
                if (!e.world.func_147439_a(targetX, (targetY = (int)player.field_70163_u + e.world.field_73012_v.nextInt(4) - e.world.field_73012_v.nextInt(4)) - 1, targetZ = (int)player.field_70161_v + e.world.field_73012_v.nextInt(4) - e.world.field_73012_v.nextInt(4)).func_149688_o().func_76230_c()) {
                    return;
                }
                for (int xb = targetX - 1; xb < targetX + 1; ++xb) {
                    for (int yb = targetY; yb < targetY + 2; ++yb) {
                        for (int zb = targetZ - 1; zb < targetZ + 1; ++zb) {
                            if (!e.world.func_147439_a(xb, yb, zb).func_149688_o().func_76230_c()) continue;
                            return;
                        }
                    }
                }
                EntityLightningBolt bolt = new EntityLightningBolt(e.world, (double)targetX, (double)targetY, (double)targetZ);
                e.world.func_72942_c((Entity)bolt);
                e.world.func_72908_a((double)targetX, (double)targetY, (double)targetZ, "random.explode", 4.0f, (1.0f + (e.world.field_73012_v.nextFloat() - e.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                e.world.func_72869_a("hugeexplosion", (double)targetX, (double)targetY, (double)targetZ, 1.0, 0.0, 0.0);
                EntityWither ew = new EntityWither(e.world);
                ew.func_70012_b((double)targetX + 0.5, (double)targetY - 0.5, (double)targetZ + 0.5, e.world.field_73012_v.nextFloat(), e.world.field_73012_v.nextFloat());
                ew.func_82206_m();
                if (!e.world.func_72838_d((Entity)ew)) continue;
                MiscHelper.getWarpTag(player).func_74768_a("wither", --wither);
                if (wither > 0) continue block0;
                MiscHelper.getWarpTag(player).func_82580_o("wither");
                continue block0;
            }
        }
    }
}

