/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import shukaro.warptheory.WarpTheory;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.net.PacketDispatcher;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;

public class WarpEars
extends IWarpEvent {
    private final int _mMinWarpLevel;

    public WarpEars(int pMinWarpLevel) {
        this._mMinWarpLevel = pMinWarpLevel;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getName() {
        return "ears";
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.ears"));
        int amount = 10 + world.field_73012_v.nextInt(30);
        if (!world.field_72995_K) {
            MiscHelper.modEventInt(player, "ears", amount);
            PacketDispatcher.sendEarStartEvent(player, amount);
        }
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMessageReceived(ClientChatReceivedEvent e) {
        EntityPlayer player = WarpTheory.proxy.getPlayer();
        if (player == null || ChatHelper.getUsername(e.message).length() == 0 || player.func_70005_c_().equals(ChatHelper.getUsername(e.message))) {
            return;
        }
        if (MiscHelper.getWarpTag(player).func_74764_b("ears")) {
            e.message = new ChatComponentText(ChatHelper.getFormattedUsername(e.message) + " " + ChatHelper.garbleMessage(e.message));
            PacketDispatcher.sendEarDecrementEvent(player);
            int ears = MiscHelper.getWarpTag(player).func_74762_e("ears");
            MiscHelper.getWarpTag(player).func_74768_a("ears", --ears);
            if (ears <= 0) {
                MiscHelper.getWarpTag(player).func_82580_o("ears");
            }
        }
    }
}

