/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.warptheory.handlers.ConfigHandler;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.NameMetaPair;

public class WarpSwamp
extends IWarpEvent {
    private final int _mMinWarpLevel;

    public WarpSwamp(int pMinWarpLevel) {
        this._mMinWarpLevel = pMinWarpLevel;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public String getName() {
        return "biomeSwamp";
    }

    @Override
    public int getSeverity() {
        return this._mMinWarpLevel;
    }

    @Override
    public boolean canDo(EntityPlayer player) {
        for (String n : MiscHelper.getWarpTag(player).func_150296_c()) {
            if (!n.startsWith("biome") || n.equals(this.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        ChatHelper.sendToPlayer(player, FormatCodes.Purple.code + FormatCodes.Italic.code + StatCollector.func_74838_a((String)"chat.warptheory.swamp"));
        MiscHelper.modEventInt(player, "biomeSwamp", 256 + world.field_73012_v.nextInt(256));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (!ConfigHandler.allowGlobalWarpEffects) {
            return;
        }
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        for (EntityPlayer player : (ArrayList)e.world.field_73010_i) {
            int targetZ;
            int targetY;
            if (!MiscHelper.getWarpTag(player).func_74764_b("biomeSwamp")) continue;
            int biomeSwamp = MiscHelper.getWarpTag(player).func_74762_e("biomeSwamp");
            int targetX = (int)player.field_70165_t + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8);
            BlockCoord target = new BlockCoord(targetX, targetY = (int)player.field_70163_u + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8), targetZ = (int)player.field_70161_v + e.world.field_73012_v.nextInt(8) - e.world.field_73012_v.nextInt(8));
            if (!MiscHelper.hasNonSolidNeighbor(e.world, target)) break;
            boolean grown = false;
            if (target.getBlock(e.world) == Blocks.field_150355_j) {
                if (target.offset(1).isAir((IBlockAccess)e.world) && e.world.func_147465_d(target.x, target.y, target.z, Blocks.field_150392_bi, 0, 3)) {
                    grown = true;
                }
            } else if (target.getBlock(e.world) == Blocks.field_150345_g) {
                ((BlockSapling)target.getBlock(e.world)).func_149878_d(e.world, target.x, target.y, target.z, e.world.field_73012_v);
                grown = true;
            } else if (target.getBlock(e.world).func_149688_o() == Material.field_151584_j || target.getBlock(e.world) == Blocks.field_150364_r || target.getBlock(e.world) == Blocks.field_150363_s) {
                for (int j = 0; j < 6; ++j) {
                    int side = 2 + e.world.field_73012_v.nextInt(4);
                    if (!Blocks.field_150395_bd.func_149707_d(e.world, target.x, target.y, target.z, side) || !target.offset(side).isAir((IBlockAccess)e.world)) continue;
                    e.world.func_147465_d(target.x, target.y, target.z, Blocks.field_150395_bd, 1 << Direction.field_71579_d[Facing.field_71588_a[side]], 3);
                    grown = true;
                    break;
                }
            } else if (e.world.field_73012_v.nextBoolean() && target.getBlock(e.world).canSustainPlant((IBlockAccess)e.world, target.x, target.y, target.z, ForgeDirection.UP, (IPlantable)Blocks.field_150345_g)) {
                if (e.world.field_73012_v.nextBoolean()) {
                    if (target.offset(1).isAir((IBlockAccess)e.world) || target.getBlock(e.world) instanceof IPlantable && target.getBlock(e.world) != Blocks.field_150345_g) {
                        e.world.func_147465_d(target.x, target.y, target.z, Blocks.field_150345_g, e.world.field_73012_v.nextInt(6), 3);
                    }
                } else if (e.world.field_73012_v.nextBoolean()) {
                    if (target.offset(1).isAir((IBlockAccess)e.world) && target.offset(0).getBlock(e.world) instanceof IGrowable) {
                        ((IGrowable)target.getBlock(e.world)).func_149853_b(e.world, e.world.field_73012_v, target.x, target.y, target.z);
                    }
                } else if (target.offset(1).isAir((IBlockAccess)e.world) && target.offset(0).getBlock(e.world) == Blocks.field_150349_c) {
                    e.world.func_147465_d(target.x, target.y, target.z, Blocks.field_150346_d, 2, 3);
                }
                grown = true;
            } else if (e.world.field_73012_v.nextBoolean() && MiscHelper.canTurnToSwampWater(e.world, target)) {
                if (target.copy().offset(1).getBlock(e.world) == Blocks.field_150364_r || target.copy().offset(1).getBlock(e.world) == Blocks.field_150363_s) {
                    e.world.func_147465_d(target.x, target.y, target.z, target.copy().offset(1).getBlock(e.world), target.copy().offset(1).getMeta(e.world), 3);
                } else {
                    e.world.func_147465_d(target.x, target.y, target.z, Blocks.field_150355_j, 0, 3);
                }
                grown = true;
            } else if (WarpHandler.decayMappings.containsKey(new NameMetaPair(target.getBlock(e.world), target.getMeta(e.world))) && target.getBlock(e.world).func_149662_c() && target.getBlock(e.world) != Blocks.field_150364_r && target.getBlock(e.world) != Blocks.field_150363_s && target.getBlock(e.world) != Blocks.field_150346_d && target.getBlock(e.world) != Blocks.field_150349_c) {
                if (target.copy().offset(1).getBlock(e.world).func_149662_c()) {
                    e.world.func_147465_d(target.x, target.y, target.z, Blocks.field_150346_d, 0, 3);
                } else if (e.world.field_73012_v.nextBoolean()) {
                    e.world.func_147465_d(target.x, target.y, target.z, (Block)Blocks.field_150349_c, 0, 3);
                } else {
                    e.world.func_147465_d(target.x, target.y, target.z, Blocks.field_150346_d, 2, 3);
                }
                grown = true;
            }
            if (!grown) continue;
            MiscHelper.getWarpTag(player).func_74768_a("biomeSwamp", --biomeSwamp);
            if (biomeSwamp > 0) continue;
            MiscHelper.getWarpTag(player).func_82580_o("biomeSwamp");
        }
    }
}

