/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.net;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.net.ClientProxy;
import shukaro.warptheory.net.CommonProxy;
import shukaro.warptheory.net.packets.BloodPacket;
import shukaro.warptheory.net.packets.ClearPacket;
import shukaro.warptheory.net.packets.ClientEventPacket;
import shukaro.warptheory.net.packets.DecrementPacket;
import shukaro.warptheory.net.packets.EnderParticlesPacket;
import shukaro.warptheory.net.packets.IWarpPacket;
import shukaro.warptheory.net.packets.VelocityPacket;

public class PacketDispatcher {
    public static void sendBlinkEvent(World world, double x, double y, double z) {
        try {
            int dim = world.field_73011_w.field_76574_g;
            PacketDispatcher.sendToAllAround(new EnderParticlesPacket(x, y, z), dim, (int)x, (int)y, (int)z, 128);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendWindEvent(EntityPlayer player, double x, double y, double z) {
        try {
            PacketDispatcher.sendToPlayer(new VelocityPacket(x, y, z), player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendBloodEvent(EntityPlayer player, int x, int y, int z) {
        try {
            PacketDispatcher.sendToPlayer(new BloodPacket(player.field_70170_p.field_73011_w.field_76574_g, x, y, z), player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendBloodClearEvent(EntityPlayer player) {
        try {
            PacketDispatcher.sendToPlayer(new ClearPacket(0), player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendEarDecrementEvent(EntityPlayer player) {
        try {
            PacketDispatcher.sendToServer(new DecrementPacket(0, player.func_145782_y()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendEarStartEvent(EntityPlayer player, int amount) {
        try {
            PacketDispatcher.sendToPlayer(new ClientEventPacket(0, amount), player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static FMLEmbeddedChannel getClientOutboundChannel() {
        return (FMLEmbeddedChannel)ClientProxy.warpChannel.get(Side.CLIENT);
    }

    private static FMLEmbeddedChannel getServerOutboundChannel() {
        return CommonProxy.warpChannel.get(Side.SERVER);
    }

    private static void sendToServer(IWarpPacket packet) {
        PacketDispatcher.getClientOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        PacketDispatcher.getClientOutboundChannel().writeOutbound(new Object[]{packet});
    }

    private static void sendToPlayer(IWarpPacket packet, EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketDispatcher.getServerOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            PacketDispatcher.getServerOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            PacketDispatcher.getServerOutboundChannel().writeOutbound(new Object[]{packet});
        }
    }

    private static void sendToAll(IWarpPacket packet) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketDispatcher.getServerOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            PacketDispatcher.getServerOutboundChannel().writeOutbound(new Object[]{packet});
        }
    }

    private static void sendToAllAround(IWarpPacket packet, int dim, int x, int y, int z, int range) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(dim, (double)x, (double)y, (double)z, (double)range);
            PacketDispatcher.getServerOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            PacketDispatcher.getServerOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)tp);
            PacketDispatcher.getServerOutboundChannel().writeOutbound(new Object[]{packet});
        }
    }

    private static void sendToAllInDim(IWarpPacket packet, int dim) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketDispatcher.getServerOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            PacketDispatcher.getServerOutboundChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dim);
            PacketDispatcher.getServerOutboundChannel().writeOutbound(new Object[]{packet});
        }
    }
}

