/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers;

import baubles.api.BaublesApi;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import shukaro.warptheory.handlers.ConfigHandler;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.handlers.warpevents.WarpAcceleration;
import shukaro.warptheory.handlers.warpevents.WarpBats;
import shukaro.warptheory.handlers.warpevents.WarpBlink;
import shukaro.warptheory.handlers.warpevents.WarpBlood;
import shukaro.warptheory.handlers.warpevents.WarpBuff;
import shukaro.warptheory.handlers.warpevents.WarpChests;
import shukaro.warptheory.handlers.warpevents.WarpDecay;
import shukaro.warptheory.handlers.warpevents.WarpEars;
import shukaro.warptheory.handlers.warpevents.WarpFakeSound;
import shukaro.warptheory.handlers.warpevents.WarpFakeSoundBehind;
import shukaro.warptheory.handlers.warpevents.WarpFall;
import shukaro.warptheory.handlers.warpevents.WarpFriend;
import shukaro.warptheory.handlers.warpevents.WarpLightning;
import shukaro.warptheory.handlers.warpevents.WarpLivestockRain;
import shukaro.warptheory.handlers.warpevents.WarpRain;
import shukaro.warptheory.handlers.warpevents.WarpSwamp;
import shukaro.warptheory.handlers.warpevents.WarpTongue;
import shukaro.warptheory.handlers.warpevents.WarpWind;
import shukaro.warptheory.handlers.warpevents.WarpWither;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.MiscHelper;
import shukaro.warptheory.util.NameMetaPair;
import thaumcraft.api.IWarpingGear;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.PlayerKnowledge;

public class WarpHandler {
    public static final PlayerKnowledge Knowledge = Thaumcraft.proxy.getPlayerKnowledge();
    private static HashMap<UUID, Integer> Unavoidable = new HashMap();
    public static ArrayList<IWarpEvent> warpEvents = new ArrayList();
    public static Map<NameMetaPair, NameMetaPair> decayMappings = new THashMap();

    public static void addDecayMapping(Block start, Block end) {
        WarpHandler.addDecayMapping(start, 0, end, 0);
    }

    public static void addDecayMapping(Block start, int startMeta, Block end, int endMeta) {
        decayMappings.put(new NameMetaPair(start, startMeta), new NameMetaPair(end, endMeta));
    }

    public static void addDecayMapping(Block start, int startMeta, Block end) {
        decayMappings.put(new NameMetaPair(start, startMeta), new NameMetaPair(end, 0));
    }

    public static void initEvents() {
        if (ConfigHandler.allowWarpEffect1) {
            warpEvents.add(new WarpBats(ConfigHandler.minimumWarpForEffect1));
        }
        if (ConfigHandler.allowWarpEffect2) {
            warpEvents.add(new WarpBlink(ConfigHandler.minimumWarpForEffect2));
        }
        if (ConfigHandler.allowWarpEffect3) {
            warpEvents.add(new WarpBuff(ConfigHandler.minimumWarpForEffect3, "poison", new PotionEffect(Potion.field_76436_u.field_76415_H, 400)));
        }
        if (ConfigHandler.allowWarpEffect4) {
            warpEvents.add(new WarpBuff(ConfigHandler.minimumWarpForEffect4, "nausea", new PotionEffect(Potion.field_76431_k.field_76415_H, 400)));
        }
        if (ConfigHandler.allowWarpEffect5) {
            warpEvents.add(new WarpBuff(ConfigHandler.minimumWarpForEffect5, "jump", new PotionEffect(Potion.field_76430_j.field_76415_H, 400, 20)));
        }
        if (ConfigHandler.allowWarpEffect6) {
            warpEvents.add(new WarpBuff(ConfigHandler.minimumWarpForEffect6, "blind", new PotionEffect(Potion.field_76440_q.field_76415_H, 400)));
        }
        if (ConfigHandler.allowGlobalWarpEffects && ConfigHandler.allowWarpEffect7) {
            warpEvents.add(new WarpDecay(ConfigHandler.minimumWarpForEffect7));
        }
        if (ConfigHandler.allowWarpEffect8) {
            warpEvents.add(new WarpEars(ConfigHandler.minimumWarpForEffect8));
        }
        if (ConfigHandler.allowGlobalWarpEffects && ConfigHandler.allowWarpEffect9) {
            warpEvents.add(new WarpSwamp(ConfigHandler.minimumWarpForEffect9));
        }
        if (ConfigHandler.allowWarpEffect10) {
            warpEvents.add(new WarpTongue(ConfigHandler.minimumWarpForEffect10));
        }
        if (ConfigHandler.allowWarpEffect11) {
            warpEvents.add(new WarpFriend(ConfigHandler.minimumWarpForEffect11));
        }
        if (ConfigHandler.allowWarpEffect12) {
            warpEvents.add(new WarpLivestockRain(ConfigHandler.minimumWarpForEffect12));
        }
        if (ConfigHandler.allowWarpEffect13) {
            warpEvents.add(new WarpWind(ConfigHandler.minimumWarpForEffect13));
        }
        if (ConfigHandler.allowWarpEffect14) {
            warpEvents.add(new WarpChests(ConfigHandler.minimumWarpForEffect14));
        }
        if (ConfigHandler.allowWarpEffect15) {
            warpEvents.add(new WarpBlood(ConfigHandler.minimumWarpForEffect15));
        }
        if (ConfigHandler.allowWarpEffect16) {
            warpEvents.add(new WarpAcceleration(ConfigHandler.minimumWarpForEffect16));
        }
        if (ConfigHandler.allowWarpEffect17) {
            warpEvents.add(new WarpLightning(ConfigHandler.minimumWarpForEffect17));
        }
        if (ConfigHandler.allowGlobalWarpEffects && ConfigHandler.allowWarpEffect18 && ConfigHandler.allowServerKickWarpEffects) {
            warpEvents.add(new WarpFall(ConfigHandler.minimumWarpForEffect18));
        }
        if (ConfigHandler.allowGlobalWarpEffects && ConfigHandler.allowWarpEffect19) {
            warpEvents.add(new WarpRain(ConfigHandler.minimumWarpForEffect19));
        }
        if (ConfigHandler.allowGlobalWarpEffects && ConfigHandler.allowWarpEffect20) {
            warpEvents.add(new WarpWither(ConfigHandler.minimumWarpForEffect20));
        }
        if (ConfigHandler.allowWarpEffect21) {
            warpEvents.add(new WarpFakeSound(ConfigHandler.minimumWarpForEffect21, "fakeexplosion", "random.explode", 8));
        }
        if (ConfigHandler.allowWarpEffect22) {
            warpEvents.add(new WarpFakeSoundBehind(ConfigHandler.minimumWarpForEffect22, "fakecreeper", "creeper.primed", 2));
        }
        WarpHandler.addDecayMapping((Block)Blocks.field_150349_c, Blocks.field_150346_d);
        WarpHandler.addDecayMapping(Blocks.field_150346_d, 0, (Block)Blocks.field_150354_m);
        WarpHandler.addDecayMapping(Blocks.field_150346_d, 1, (Block)Blocks.field_150354_m);
        WarpHandler.addDecayMapping(Blocks.field_150346_d, 2, Blocks.field_150346_d);
        WarpHandler.addDecayMapping(Blocks.field_150348_b, Blocks.field_150347_e);
        WarpHandler.addDecayMapping(Blocks.field_150347_e, Blocks.field_150351_n);
        WarpHandler.addDecayMapping(Blocks.field_150322_A, (Block)Blocks.field_150354_m);
        WarpHandler.addDecayMapping(Blocks.field_150351_n, (Block)Blocks.field_150354_m);
        WarpHandler.addDecayMapping((Block)Blocks.field_150354_m, Blocks.field_150350_a);
        WarpHandler.addDecayMapping(Blocks.field_150353_l, Blocks.field_150347_e);
        WarpHandler.addDecayMapping((Block)Blocks.field_150356_k, Blocks.field_150347_e);
        WarpHandler.addDecayMapping(Blocks.field_150355_j, Blocks.field_150350_a);
        WarpHandler.addDecayMapping(Blocks.field_150433_aE, Blocks.field_150355_j);
        WarpHandler.addDecayMapping(Blocks.field_150431_aC, Blocks.field_150350_a);
        WarpHandler.addDecayMapping(Blocks.field_150432_aD, Blocks.field_150355_j);
        WarpHandler.addDecayMapping(Blocks.field_150435_aG, (Block)Blocks.field_150354_m);
        WarpHandler.addDecayMapping((Block)Blocks.field_150391_bh, (Block)Blocks.field_150349_c);
        WarpHandler.addDecayMapping(Blocks.field_150406_ce, Blocks.field_150405_ch);
        WarpHandler.addDecayMapping(Blocks.field_150405_ch, Blocks.field_150435_aG);
        WarpHandler.addDecayMapping(Blocks.field_150365_q, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150482_ag, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150412_bA, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150352_o, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150366_p, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150369_x, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150439_ay, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150450_ax, Blocks.field_150348_b);
        WarpHandler.addDecayMapping(Blocks.field_150449_bY, Blocks.field_150424_aL);
        WarpHandler.addDecayMapping(Blocks.field_150424_aL, Blocks.field_150347_e);
        WarpHandler.addDecayMapping(Blocks.field_150425_aM, (Block)Blocks.field_150354_m);
        WarpHandler.addDecayMapping(Blocks.field_150426_aN, Blocks.field_150347_e);
        WarpHandler.addDecayMapping(Blocks.field_150364_r, Blocks.field_150346_d);
        WarpHandler.addDecayMapping(Blocks.field_150363_s, Blocks.field_150346_d);
        WarpHandler.addDecayMapping(Blocks.field_150420_aW, Blocks.field_150346_d);
        WarpHandler.addDecayMapping(Blocks.field_150419_aX, Blocks.field_150346_d);
        WarpHandler.addDecayMapping(Blocks.field_150377_bs, Blocks.field_150347_e);
        WarpHandler.addDecayMapping(Blocks.field_150343_Z, Blocks.field_150347_e);
    }

    public static void purgeWarp(EntityPlayer player) {
        int count = WarpHandler.queueMultipleEvents(player, WarpHandler.getTotalWarp(player));
        WarpHandler.addUnavoidableCount(player, count);
        WarpHandler.removeWarp(player, WarpHandler.getTotalWarp(player));
    }

    public static void purgeWarpMinor(EntityPlayer player) {
        int[] warp = WarpHandler.getIndividualWarps(player);
        if (warp[0] + warp[1] + warp[2] >= 50) {
            WarpHandler.removeWarp(player, 5);
            ChatHelper.sendToPlayer(player, StatCollector.func_74838_a((String)"chat.warptheory.purgeminor"));
        } else {
            ChatHelper.sendToPlayer(player, StatCollector.func_74838_a((String)"chat.warptheory.purgefailed"));
        }
    }

    public static void removeWarp(EntityPlayer player, int amount) {
        if (amount <= 0) {
            return;
        }
        String name = player.getDisplayName();
        int wp = Knowledge.getWarpPerm(name);
        int wn = Knowledge.getWarpSticky(name);
        int wt = Knowledge.getWarpTemp(name);
        Knowledge.setWarpCounter(name, wp + wn + wt - amount);
        Knowledge.addWarpTemp(name, -amount);
        if ((amount -= wt) <= 0) {
            return;
        }
        Knowledge.addWarpSticky(name, -amount);
        if ((amount -= wn) <= 0) {
            return;
        }
        if (ConfigHandler.allowPermWarpRemoval) {
            amount = (int)Math.ceil(amount / ConfigHandler.permWarpMult);
            Knowledge.addWarpPerm(name, -amount);
        }
    }

    public static int getTotalWarp(EntityPlayer player) {
        String name = player.getDisplayName();
        int innerWarp = Knowledge.getWarpTotal(name);
        int extraPerm = Knowledge.getWarpPerm(name) * Math.max(0, ConfigHandler.permWarpMult - 1);
        int outerWarp = WarpHandler.getWarpFromGear(player);
        return innerWarp + extraPerm + outerWarp;
    }

    public static int[] getIndividualWarps(EntityPlayer player) {
        String userName = player.getDisplayName();
        int[] totals = new int[]{Knowledge.getWarpPerm(userName), Knowledge.getWarpSticky(userName), Knowledge.getWarpTemp(userName)};
        return totals;
    }

    public static int queueMultipleEvents(EntityPlayer player, int amount) {
        int w = amount;
        int count = 0;
        while (w > 0) {
            IWarpEvent event = WarpHandler.queueOneEvent(player, w);
            if (event == null) {
                return w;
            }
            w -= event.getCost();
            ++count;
        }
        return count;
    }

    public static IWarpEvent queueOneEvent(EntityPlayer player, int maxSeverity) {
        IWarpEvent event = WarpHandler.getAppropriateEvent(player, maxSeverity);
        if (event != null) {
            WarpHandler.queueEvent(player, event);
        }
        return event;
    }

    public static IWarpEvent getAppropriateEvent(EntityPlayer player, int maxSeverity) {
        ArrayList shuffled = (ArrayList)warpEvents.clone();
        Collections.shuffle(shuffled);
        for (IWarpEvent e : shuffled) {
            if (e.getSeverity() > maxSeverity) continue;
            return e;
        }
        return null;
    }

    public static int getWarpFromGear(EntityPlayer player) {
        int w = WarpHandler.getFinalWarp(player.func_71045_bC(), player);
        for (int a = 0; a < 4; ++a) {
            w += WarpHandler.getFinalWarp(player.field_71071_by.func_70440_f(a), player);
        }
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (int i = 0; i < 4; ++i) {
            w += WarpHandler.getFinalWarp(baubles.func_70301_a(i), player);
        }
        return w;
    }

    public static int getFinalWarp(ItemStack stack, EntityPlayer player) {
        if (stack == null || !(stack.func_77973_b() instanceof IWarpingGear)) {
            return 0;
        }
        IWarpingGear armor = (IWarpingGear)stack.func_77973_b();
        return armor.getWarp(stack, player);
    }

    public static IWarpEvent getEventFromName(String name) {
        for (IWarpEvent event : warpEvents) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public static void queueEvent(EntityPlayer player, IWarpEvent event) {
        String queue = !MiscHelper.getWarpTag(player).func_74764_b("queuedEvents") ? "" : MiscHelper.getWarpTag(player).func_74779_i("queuedEvents");
        queue = queue + event.getName() + " ";
        MiscHelper.getWarpTag(player).func_74778_a("queuedEvents", queue);
    }

    public static IWarpEvent dequeueEvent(EntityPlayer player) {
        String queue = !MiscHelper.getWarpTag(player).func_74764_b("queuedEvents") ? "" : MiscHelper.getWarpTag(player).func_74779_i("queuedEvents");
        if (queue.length() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (String n : queue.split(" ")) {
                names.add(n);
            }
            Collections.shuffle(names);
            String todo = (String)names.remove(player.field_70170_p.field_73012_v.nextInt(names.size()));
            queue = "";
            for (String n : names) {
                queue = queue + n + " ";
            }
            MiscHelper.getWarpTag(player).func_74778_a("queuedEvents", queue);
            return WarpHandler.getEventFromName(todo);
        }
        return null;
    }

    public static void setUnavoidableCount(EntityPlayer player, int count) {
        if (ConfigHandler.disableRebound) {
            return;
        }
        UUID uuid = player.func_110124_au();
        Unavoidable.put(uuid, Math.max(0, count));
    }

    public static void addUnavoidableCount(EntityPlayer player, int count) {
        if (ConfigHandler.disableRebound) {
            return;
        }
        UUID uuid = player.func_110124_au();
        if (!Unavoidable.containsKey(uuid)) {
            Unavoidable.put(uuid, 0);
        }
        count = Math.max(0, count + Unavoidable.get(uuid));
        Unavoidable.put(uuid, count);
    }

    public static int getUnavoidableCount(EntityPlayer player) {
        if (ConfigHandler.disableRebound) {
            return 0;
        }
        UUID uuid = player.func_110124_au();
        if (!Unavoidable.containsKey(uuid)) {
            Unavoidable.put(uuid, 0);
        }
        return Unavoidable.get(uuid);
    }
}

