/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IMultiWarpEvent;
import shukaro.warptheory.util.BlockCoord;
import shukaro.warptheory.util.RandomBlockHelper;
import thaumcraft.common.entities.monster.EntityTaintChicken;
import thaumcraft.common.entities.monster.EntityTaintCow;
import thaumcraft.common.entities.monster.EntityTaintPig;
import thaumcraft.common.entities.monster.EntityTaintSheep;

public class WarpLivestockRain
extends IMultiWarpEvent {
    public WarpLivestockRain(int minWarp) {
        super("livestock", minWarp, 3, world -> 5 + world.field_73012_v.nextInt(10));
    }

    @Override
    public int triggerEvent(int eventLevel, int eventAmount, World world, EntityPlayer player) {
        int successful = 0;
        for (int i = 0; i < 6; ++i) {
            EntitySquid victim;
            BlockCoord target = RandomBlockHelper.randomBlock(world, player, 8, block -> WarpLivestockRain.isValid(world, block));
            if (target == null) continue;
            target.y += 25;
            block0 : switch (eventLevel) {
                case 2: {
                    switch (world.field_73012_v.nextInt(3)) {
                        case 0: {
                            victim = new EntityTaintCow(world);
                            victim.func_70606_j(20.0f);
                            break block0;
                        }
                        case 1: {
                            victim = new EntityTaintPig(world);
                            break block0;
                        }
                        case 2: {
                            victim = new EntityTaintSheep(world);
                            break block0;
                        }
                    }
                    victim = new EntityTaintChicken(world);
                    break;
                }
                case 1: {
                    victim = new EntitySquid(world);
                    break;
                }
                default: {
                    switch (world.field_73012_v.nextInt(3)) {
                        case 0: {
                            victim = new EntityCow(world);
                            break block0;
                        }
                        case 1: {
                            victim = new EntityPig(world);
                            break block0;
                        }
                        case 2: {
                            victim = new EntitySheep(world);
                            break block0;
                        }
                    }
                    victim = new EntityChicken(world);
                }
            }
            victim.func_70642_aH();
            RandomBlockHelper.setLocation(world, (Entity)victim, target);
            if (world.func_72838_d((Entity)victim) && ++successful >= eventAmount) break;
        }
        return successful;
    }

    private static boolean isValid(World world, BlockCoord block) {
        for (int i = 0; i <= 25; ++i) {
            if (world.func_147437_c(block.x, block.y + i, block.z)) continue;
            return false;
        }
        return true;
    }
}

