/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.integration.modules;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.integration.modules.NEIHelpers.NEIAEShapelessRecipeHandler;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.p455w0rd.wirelesscraftingterminal.client.gui.GuiWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingMatrix;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotFakeCraftingMatrix;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketNEIRecipe;
import net.p455w0rd.wirelesscraftingterminal.integration.IIntegrationModule;
import net.p455w0rd.wirelesscraftingterminal.integration.IntegrationHelper;
import net.p455w0rd.wirelesscraftingterminal.integration.abstraction.INEI;
import net.p455w0rd.wirelesscraftingterminal.integration.modules.NEIHelpers.NEIAEShapedRecipeHandler;
import net.p455w0rd.wirelesscraftingterminal.integration.modules.NEIHelpers.NEIGUIHandler;

public class NEI
implements INEI,
IContainerTooltipHandler,
IIntegrationModule {
    public static NEI instance;
    private final Class<?> apiClass;
    static final int NEI_REGULAR_SLOT_OFFSET_X = 25;
    static final int NEI_REGULAR_SLOT_OFFSET_Y = 6;

    public NEI() throws ClassNotFoundException {
        IntegrationHelper.testClassExistence(this, API.class);
        IntegrationHelper.testClassExistence(this, IStackPositioner.class);
        IntegrationHelper.testClassExistence(this, GuiContainerManager.class);
        IntegrationHelper.testClassExistence(this, PositionedStack.class);
        IntegrationHelper.testClassExistence(this, IRecipeHandler.class);
        this.apiClass = Class.forName("codechicken.nei.api.API");
    }

    @Override
    public void init() throws Throwable {
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)this);
        API.registerGuiOverlay(GuiWirelessCraftingTerminal.class, (String)"crafting", (IStackPositioner)new WCTSlotPositioner());
        API.registerGuiOverlayHandler(GuiWirelessCraftingTerminal.class, (IOverlayHandler)new WCTOverlayHandler(), (String)"crafting");
        API.registerRecipeHandler((ICraftingHandler)new NEIAEShapedRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIAEShapelessRecipeHandler());
        API.registerNEIGuiHandler((INEIGuiHandler)new NEIGUIHandler());
    }

    @Override
    public void postInit() {
    }

    @Override
    public void drawSlot(Slot s) {
        if (s == null) {
            return;
        }
        ItemStack stack = s.func_75211_c();
        if (stack == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        int x = s.field_75223_e;
        int y = s.field_75221_f;
        GuiContainerManager.drawItems.func_82406_b(fontRenderer, mc.func_110434_K(), stack, x, y);
        GuiContainerManager.drawItems.func_94148_a(fontRenderer, mc.func_110434_K(), stack, x, y, String.valueOf(stack.field_77994_a));
    }

    @Override
    public RenderItem setItemRender(RenderItem renderItem) {
        try {
            RenderItem ri = GuiContainerManager.drawItems;
            GuiContainerManager.drawItems = renderItem;
            return ri;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Invalid version of NEI, please update", t);
        }
    }

    public List<String> handleTooltip(GuiContainer arg0, int arg1, int arg2, List<String> current) {
        return current;
    }

    public List<String> handleItemDisplayName(GuiContainer arg0, ItemStack arg1, List<String> current) {
        return current;
    }

    public List<String> handleItemTooltip(GuiContainer guiScreen, ItemStack stack, int mouseX, int mouseY, List<String> currentToolTip) {
        if (guiScreen instanceof GuiWirelessCraftingTerminal) {
            return ((GuiWirelessCraftingTerminal)guiScreen).handleItemTooltip(stack, mouseX, mouseY, currentToolTip);
        }
        return currentToolTip;
    }

    public class WCTOverlayHandler
    implements IOverlayHandler {
        private static final int REGULAR_SLOT_INDEX_DIVISOR = 18;

        private boolean addCraftingItems(PositionedStack ingredient, IAEItemStack[] overlayItems) {
            int slotX = (ingredient.relx - 25) / 18;
            int slotY = (ingredient.rely - 6) / 18;
            int slotIndex = slotX + slotY * 3;
            overlayItems[slotIndex] = AEApi.instance().storage().createItemStack(ingredient.item);
            return true;
        }

        protected boolean addIngredientToItems(PositionedStack ingredient, IAEItemStack[] overlayItems) {
            return this.addCraftingItems(ingredient, overlayItems);
        }

        protected void addItemsToGUI(IAEItemStack[] overlayItems) {
        }

        public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
            try {
                List ingredients = recipe.getIngredientStacks(recipeIndex);
                this.overlayRecipe(gui, ingredients, shift);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }

        private void overlayRecipe(GuiContainer gui, List<PositionedStack> ingredients, boolean shift) {
            try {
                NBTTagCompound recipe = new NBTTagCompound();
                if (gui instanceof GuiWirelessCraftingTerminal) {
                    block3: for (PositionedStack positionedStack : ingredients) {
                        int col = (positionedStack.relx - 25) / 18;
                        int row = (positionedStack.rely - 6) / 18;
                        if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
                        for (Slot slot : gui.field_147002_h.field_75151_b) {
                            if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) || slot.getSlotIndex() != col + row * 3) continue;
                            NBTTagList tags = new NBTTagList();
                            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                            for (int x = 0; x < positionedStack.items.length; ++x) {
                                if (!Platform.isRecipePrioritized((ItemStack)positionedStack.items[x])) {
                                    list.add(0, positionedStack.items[x]);
                                    continue;
                                }
                                list.add(positionedStack.items[x]);
                            }
                            for (ItemStack is : list) {
                                NBTTagCompound tag = new NBTTagCompound();
                                is.func_77955_b(tag);
                                tags.func_74742_a((NBTBase)tag);
                            }
                            recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                            continue block3;
                        }
                    }
                    NetworkHandler.instance.sendToServer(new PacketNEIRecipe(recipe));
                }
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public class WCTSlotPositioner
    implements IStackPositioner {
        public ArrayList<PositionedStack> positionStacks(ArrayList<PositionedStack> stacks) {
            for (PositionedStack positionedStack : stacks) {
                if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
                positionedStack.relx += ContainerWirelessCraftingTerminal.CRAFTING_SLOT_X_POS - 25;
                positionedStack.rely += ContainerWirelessCraftingTerminal.CRAFTING_SLOT_Y_POS - 6;
            }
            return stacks;
        }
    }
}

