/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import alkalus.main.core.crafting.OvenRecipes;
import alkalus.main.core.util.ReflectionUtils;
import alkalus.main.core.util.Utils;
import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockWitchesOven;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Log;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class WitchesOvenUtils {
    private static final int COOK_TIME = 180;
    private static final double FUNNEL_CHANCE = 0.25;
    private static final double FILTERED_FUNNEL_CHANCE = 0.3;
    private static final double DOUBLED_FILTERED_FUNNEL_CHANCE = 0.8;
    private static final int SLOT_TO_COOK = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_COOKED = 2;
    private static final int SLOT_BY_PRODUCT = 3;
    private static final int SLOT_JARS = 4;
    private static final int[] slots_top = new int[]{0, 4};
    private static final int[] slots_bottom = new int[]{4, 1};
    private static final int[] slots_sides = new int[]{3, 2, 4, 1};

    public static ItemStack[] getFurnaceItemStacks(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (ItemStack[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "furnaceItemStacks"), aTile);
    }

    public static int[] getSlotsTop(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (int[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "slots_top"), aTile);
    }

    public static int[] getSlotsBottom(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (int[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "slots_bottom"), aTile);
    }

    public static int[] getSlotsSides(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (int[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "slots_sides"), aTile);
    }

    public static void updateEntity(BlockWitchesOven.TileEntityWitchesOven aTile) {
        boolean flag = aTile.furnaceBurnTime > 0;
        boolean aDoBlockUpdate = false;
        if (aTile.furnaceBurnTime > 0) {
            --aTile.furnaceBurnTime;
        }
        if (!aTile.func_145831_w().field_72995_K) {
            if (WitchesOvenUtils.canSmelt(aTile)) {
                if (aTile.furnaceBurnTime == 0) {
                    int itemBurnTime;
                    aTile.furnaceBurnTime = itemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)WitchesOvenUtils.getFuelSlot(aTile));
                    aTile.currentItemBurnTime = itemBurnTime;
                    if (aTile.furnaceBurnTime > 0) {
                        aDoBlockUpdate = true;
                        if (WitchesOvenUtils.getFuelSlot(aTile) != null) {
                            ItemStack itemStack = WitchesOvenUtils.getFuelSlot(aTile);
                            --itemStack.field_77994_a;
                            if (WitchesOvenUtils.getFuelSlot((BlockWitchesOven.TileEntityWitchesOven)aTile).field_77994_a == 0) {
                                WitchesOvenUtils.setFuelSlot(aTile, WitchesOvenUtils.getFuelSlot(aTile).func_77973_b().getContainerItem(WitchesOvenUtils.getFuelSlot(aTile)));
                            }
                        }
                    }
                }
                if (aTile.isBurning()) {
                    ++aTile.furnaceCookTime;
                    if (aTile.furnaceCookTime >= WitchesOvenUtils.getCookTime(aTile)) {
                        aTile.furnaceCookTime = 0;
                        WitchesOvenUtils.smeltItem(aTile);
                        aDoBlockUpdate = true;
                    }
                } else {
                    aTile.furnaceCookTime = 0;
                }
            }
            if (flag != aTile.furnaceBurnTime > 0) {
                aDoBlockUpdate = true;
                BlockWitchesOven.updateWitchesOvenBlockState((aTile.furnaceBurnTime > 0 ? 1 : 0) != 0, (World)aTile.func_145831_w(), (int)aTile.field_145851_c, (int)aTile.field_145848_d, (int)aTile.field_145849_e);
            }
        }
        if (aDoBlockUpdate) {
            aTile.func_70296_d();
            aTile.func_145831_w().func_147471_g(aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e);
        }
    }

    public static int getEmptyJarCount(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getEmptyJarSlot(aTile);
        return aJarStack != null ? aJarStack.field_77994_a : 0;
    }

    public static ItemStack getInputSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[0];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getFuelSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[1];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[2];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getFumeOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[3];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getEmptyJarSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[4];
        return aJarStack != null ? aJarStack : null;
    }

    public static void setInputSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[0] = aNewVal;
    }

    public static void setFuelSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[1] = aNewVal;
    }

    public static void setOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[2] = aNewVal;
    }

    public static void setFumeOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[3] = aNewVal;
    }

    public static void setEmptyJarSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[4] = aNewVal;
    }

    public static boolean canSmelt(BlockWitchesOven.TileEntityWitchesOven aTile) {
        if (WitchesOvenUtils.getInputSlot(aTile) == null) {
            return false;
        }
        OvenRecipes.OvenRecipe aValidRecipe = null;
        int aJarCount = WitchesOvenUtils.getEmptyJarCount(aTile);
        if (aJarCount == 0) {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > 0 || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        } else {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > aJarCount || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        }
        if (aValidRecipe == null) {
            return false;
        }
        ItemStack itemstack = aValidRecipe.output;
        if (!WitchesOvenUtils.getOutputSlot(aTile).func_77969_a(itemstack)) {
            return false;
        }
        int result = WitchesOvenUtils.getOutputSlot((BlockWitchesOven.TileEntityWitchesOven)aTile).field_77994_a + itemstack.field_77994_a;
        return result <= aTile.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public static void smeltItem(BlockWitchesOven.TileEntityWitchesOven aTile) {
        OvenRecipes.OvenRecipe aValidRecipe = null;
        int aJarCount = WitchesOvenUtils.getEmptyJarCount(aTile);
        if (aJarCount == 0) {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > 0 || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        } else {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > aJarCount || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        }
        if (aValidRecipe == null) {
            return;
        }
    }

    public static int getFumeFunnels(BlockWitchesOven.TileEntityWitchesOven aTile) {
        int funnels = 0;
        int meta = aTile.func_145831_w().func_72805_g(aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e);
        switch (meta) {
            case 2: 
            case 3: {
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.field_145851_c - 1, aTile.field_145848_d, aTile.field_145849_e, meta) ? 1 : 0;
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.field_145851_c + 1, aTile.field_145848_d, aTile.field_145849_e, meta) ? 1 : 0;
                break;
            }
            case 4: 
            case 5: {
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e - 1, meta) ? 1 : 0;
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e + 1, meta) ? 1 : 0;
            }
        }
        return funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.field_145851_c, aTile.field_145848_d + 1, aTile.field_145849_e, meta) ? 1 : 0;
    }

    public static boolean isFumeFunnel(BlockWitchesOven.TileEntityWitchesOven aTile, int xCoord, int yCoord, int zCoord, int meta) {
        Block block = aTile.func_145831_w().func_147439_a(xCoord, yCoord, zCoord);
        return (block == Witchery.Blocks.OVEN_FUMEFUNNEL || block == Witchery.Blocks.OVEN_FUMEFUNNEL_FILTERED) && aTile.func_145831_w().func_72805_g(xCoord, yCoord, zCoord) == meta;
    }

    public static double getFumeFunnelsChance(BlockWitchesOven.TileEntityWitchesOven aTile) {
        double funnels = 0.0;
        switch (aTile.func_145831_w().func_72805_g(aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e)) {
            case 2: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c + 1, aTile.field_145848_d, aTile.field_145849_e, 2);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c - 1, aTile.field_145848_d, aTile.field_145849_e, 2);
                break;
            }
            case 3: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c + 1, aTile.field_145848_d, aTile.field_145849_e, 3);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c - 1, aTile.field_145848_d, aTile.field_145849_e, 3);
                break;
            }
            case 4: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e + 1, 4);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e - 1, 4);
                break;
            }
            case 5: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e + 1, 5);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.field_145851_c, aTile.field_145848_d, aTile.field_145849_e - 1, 5);
            }
        }
        return funnels;
    }

    public static double getFumeFunnelChance(BlockWitchesOven.TileEntityWitchesOven aTile, int x, int y, int z, int meta) {
        Block block = aTile.func_145831_w().func_147439_a(x, y, z);
        if (block == Witchery.Blocks.OVEN_FUMEFUNNEL) {
            if (aTile.func_145831_w().func_72805_g(x, y, z) == meta) {
                return 0.25;
            }
        } else if (block == Witchery.Blocks.OVEN_FUMEFUNNEL_FILTERED && aTile.func_145831_w().func_72805_g(x, y, z) == meta) {
            return Config.instance().doubleFumeFilterChance ? 0.8 : 0.3;
        }
        return 0.0;
    }

    public static int getCookTime(BlockWitchesOven.TileEntityWitchesOven aTile) {
        int time = 180 - 20 * WitchesOvenUtils.getFumeFunnels(aTile);
        return time;
    }

    public static void generateByProduct(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack itemstack) {
        try {
            double BASE_CHANCE = 0.3;
            double funnels = WitchesOvenUtils.getFumeFunnelsChance(aTile);
            Log.instance().debug("" + WitchesOvenUtils.getInputSlot(aTile) + ": " + WitchesOvenUtils.getInputSlot(aTile).func_77973_b().func_77658_a());
            if (aTile.func_145831_w().field_73012_v.nextDouble() <= Math.min(0.3 + funnels, 1.0) && WitchesOvenUtils.getEmptyJarSlot(aTile) != null) {
                if (WitchesOvenUtils.getInputSlot(aTile).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150345_g) && WitchesOvenUtils.getInputSlot(aTile).func_77960_j() != 3) {
                    switch (WitchesOvenUtils.getInputSlot(aTile).func_77960_j()) {
                        case 0: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemExhaleOfTheHornedOne.createStack(1));
                            break;
                        }
                        case 1: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
                            break;
                        }
                        case 2: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemBreathOfTheGoddess.createStack(1));
                        }
                    }
                } else if (WitchesOvenUtils.getInputSlot(aTile).func_77973_b() == Item.func_150898_a((Block)Witchery.Blocks.SAPLING)) {
                    switch (WitchesOvenUtils.getInputSlot(aTile).func_77960_j()) {
                        case 0: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemWhiffOfMagic.createStack(1));
                            break;
                        }
                        case 1: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemReekOfMisfortune.createStack(1));
                            break;
                        }
                        case 2: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemOdourOfPurity.createStack(1));
                        }
                    }
                } else if (WitchesOvenUtils.getInputSlot(aTile).func_77977_a().equals("tile.bop.saplings") && WitchesOvenUtils.getInputSlot(aTile).func_77960_j() == 6) {
                    WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
                } else if (WitchesOvenUtils.isForestrySapling(WitchesOvenUtils.getInputSlot(aTile))) {
                    String treeType;
                    NBTTagCompound chromosome;
                    NBTTagCompound chromoBase;
                    NBTTagList list;
                    NBTTagCompound compound;
                    NBTBase tag = WitchesOvenUtils.getInputSlot(aTile).func_77978_p().func_74781_a("Genome");
                    if (tag != null && tag instanceof NBTTagCompound && (compound = (NBTTagCompound)tag).func_74764_b("Chromosomes") && compound.func_74781_a("Chromosomes") instanceof NBTTagList && (list = compound.func_150295_c("Chromosomes", 10)) != null && list.func_74745_c() > 0 && (chromoBase = list.func_150305_b(0)) != null && chromoBase instanceof NBTTagCompound && (chromosome = chromoBase).func_74764_b("UID0") && (treeType = chromosome.func_74779_i("UID0")) != null) {
                        Log.instance().debug("Forestry tree: " + treeType);
                        if (treeType.equals("forestry.treeOak")) {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemExhaleOfTheHornedOne.createStack(1));
                        } else if (treeType.equals("forestry.treeSpruce")) {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
                        } else if (treeType.equals("forestry.treeBirch")) {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemBreathOfTheGoddess.createStack(1));
                        }
                    }
                } else {
                    WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemFoulFume.createStack(1));
                }
            }
        }
        catch (Throwable e) {
            Log.instance().warning(e, "Exception occured while generating a by product from a witches oven");
        }
    }

    public static void createByProduct(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack byProduct) {
        int BY_PRODUCT_INDEX = 3;
        if (WitchesOvenUtils.getFumeOutputSlot(aTile) == null) {
            WitchesOvenUtils.setFumeOutputSlot(aTile, byProduct);
            ItemStack itemStack = WitchesOvenUtils.getEmptyJarSlot(aTile);
            if (--itemStack.field_77994_a <= 0) {
                WitchesOvenUtils.setEmptyJarSlot(aTile, null);
            }
        } else if (WitchesOvenUtils.getFumeOutputSlot(aTile).func_77969_a(byProduct) && WitchesOvenUtils.getFumeOutputSlot((BlockWitchesOven.TileEntityWitchesOven)aTile).field_77994_a + byProduct.field_77994_a < WitchesOvenUtils.getFumeOutputSlot(aTile).func_77976_d()) {
            ItemStack itemStack2 = WitchesOvenUtils.getFumeOutputSlot(aTile);
            itemStack2.field_77994_a += byProduct.field_77994_a;
            ItemStack itemStack3 = WitchesOvenUtils.getEmptyJarSlot(aTile);
            if (--itemStack3.field_77994_a <= 0) {
                WitchesOvenUtils.setEmptyJarSlot(aTile, null);
            }
        }
    }

    private static boolean isForestrySapling(ItemStack aSap) {
        return aSap != null && aSap.func_77942_o() && aSap.func_77978_p().func_74764_b("Genome");
    }

    public static ItemStack getVanillaEquivForForestrySapling(ItemStack aSap) {
        String treeType;
        NBTTagCompound chromosome;
        NBTTagCompound chromoBase;
        NBTTagList list;
        NBTTagCompound compound;
        NBTBase tag;
        if (WitchesOvenUtils.isForestrySapling(aSap) && (tag = aSap.func_77978_p().func_74781_a("Genome")) != null && tag instanceof NBTTagCompound && (compound = (NBTTagCompound)tag).func_74764_b("Chromosomes") && compound.func_74781_a("Chromosomes") instanceof NBTTagList && (list = compound.func_150295_c("Chromosomes", 10)) != null && list.func_74745_c() > 0 && (chromoBase = list.func_150305_b(0)) != null && chromoBase instanceof NBTTagCompound && (chromosome = chromoBase).func_74764_b("UID0") && (treeType = chromosome.func_74779_i("UID0")) != null) {
            Log.instance().debug("Forestry tree: " + treeType);
            if (treeType.equals("forestry.treeOak")) {
                return new ItemStack(Blocks.field_150345_g, 1, 0);
            }
            if (treeType.equals("forestry.treeSpruce")) {
                return new ItemStack(Blocks.field_150345_g, 1, 1);
            }
            if (treeType.equals("forestry.treeBirch")) {
                return new ItemStack(Blocks.field_150345_g, 1, 2);
            }
        }
        return null;
    }
}

