/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.entities;

import alkalus.main.api.RecipeManager;
import alkalus.main.config.AsmConfig;
import alkalus.main.core.WitcheryExtras;
import alkalus.main.core.util.ReflectionUtils;
import com.emoniph.witchery.predictions.Prediction;
import com.emoniph.witchery.predictions.PredictionAlwaysForced;
import com.emoniph.witchery.predictions.PredictionArrow;
import com.emoniph.witchery.predictions.PredictionBuriedTreasure;
import com.emoniph.witchery.predictions.PredictionFall;
import com.emoniph.witchery.predictions.PredictionFallInLove;
import com.emoniph.witchery.predictions.PredictionFight;
import com.emoniph.witchery.predictions.PredictionMultiMine;
import com.emoniph.witchery.predictions.PredictionNetherTrip;
import com.emoniph.witchery.predictions.PredictionRescue;
import com.emoniph.witchery.predictions.PredictionWet;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class PredictionHandler {
    private static final Field mSelfFulfillmentProbabilityPerSec = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.Prediction"), "selfFulfillmentProbabilityPerSec");
    private static final Field mRegularFulfillmentDurationInTicks = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionAlwaysForced"), "regularFulfillmentDurationInTicks");
    private static final Field mRegularFulfillmentProbability = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionAlwaysForced"), "regularFulfillmentProbability");
    private static final Field mRescueEntityClass = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionRescue"), "entityClass");
    private static final Field mChestGenHook = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionBuriedTreasure"), "chestGenHook");
    private static final Field mBlock = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionMultiMine"), "block");
    private static final Field mItem = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionMultiMine"), "itemPrototype");
    private static final Field mMinExtra = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionMultiMine"), "minExtra");
    private static final Field mMaxExtra = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionMultiMine"), "maxExtra");
    private static final Field mFightEntityClass = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionFight"), "entityClass");
    private static final Field mBindTameable = ReflectionUtils.getField(ReflectionUtils.getClass("com.emoniph.witchery.predictions.PredictionFight"), "bindTameable");

    public static void adjustPredictions() {
        int[] aNewValues = new int[]{AsmConfig.chancePredictionSpawnZombie, AsmConfig.chancePredictionSpawnSkeleton, AsmConfig.chancePredictionSpawnEnt, AsmConfig.chancePredictionStumbleAndFall, AsmConfig.chancePredictionExtraIron, AsmConfig.chancePredictionFindShinies, AsmConfig.chancePredictionFindShinies, AsmConfig.chancePredictionSpawnBuriedTreasure, AsmConfig.chancePredictionVillagerLove, AsmConfig.chancePredictionSpawnBabaYagaBad, AsmConfig.chancePredictionSpawnBabaYagaGood, AsmConfig.chancePredictionSpawnFriendlyWolf, AsmConfig.chancePredictionSpawnProtectiveAnimal, AsmConfig.chancePredictionSpawnProtectiveAnimal, AsmConfig.chancePredictionGetWet, AsmConfig.chancePredictionTeleportNether, AsmConfig.chancePredictionExtraCoal};
        for (int i = 0; i < 18; ++i) {
            Prediction aOld = RecipeManager.Predictions.getPrediction(i);
            if (aOld == null || aOld.itemWeight == (double)aNewValues[i - 1]) continue;
            RecipeManager.Predictions.remove(aOld);
            WitcheryExtras.log(0, "Adjusting weight of " + aOld.getTranslationKey() + " from " + aOld.itemWeight + " to " + aNewValues[i - 1] + ".");
            RecipeManager.Predictions.add(PredictionHandler.generateNewPrediction(aOld, aNewValues[i - 1]));
        }
    }

    private static Prediction generateNewPrediction(Prediction aOldPrediction, int aNewWeight) {
        PredictionArrow aNewPrediction = null;
        int predictionID = aOldPrediction.predictionID;
        String translationKey = aOldPrediction.getTranslationKey();
        double selfFulfillmentProbabilityPerSec = (Double)ReflectionUtils.getFieldValue(mSelfFulfillmentProbabilityPerSec, aOldPrediction);
        if (aOldPrediction instanceof PredictionAlwaysForced) {
            int regularFulfillmentDurationInTicks = (Integer)ReflectionUtils.getFieldValue(mRegularFulfillmentDurationInTicks, aOldPrediction);
            double regularFulfillmentProbability = (Double)ReflectionUtils.getFieldValue(mRegularFulfillmentProbability, aOldPrediction);
            if (aOldPrediction instanceof PredictionMultiMine) {
                Block block = (Block)ReflectionUtils.getFieldValue(mBlock, aOldPrediction);
                ItemStack itemPrototype = (ItemStack)ReflectionUtils.getFieldValue(mItem, aOldPrediction);
                int minExtra = (Integer)ReflectionUtils.getFieldValue(mMinExtra, aOldPrediction);
                int maxExtra = (Integer)ReflectionUtils.getFieldValue(mMaxExtra, aOldPrediction);
                aNewPrediction = new PredictionMultiMine(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey, regularFulfillmentDurationInTicks, regularFulfillmentProbability, block, itemPrototype, minExtra, maxExtra);
            } else if (aOldPrediction instanceof PredictionBuriedTreasure) {
                String chestGenHook = (String)ReflectionUtils.getFieldValue(mChestGenHook, aOldPrediction);
                aNewPrediction = new PredictionBuriedTreasure(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey, regularFulfillmentDurationInTicks, regularFulfillmentProbability, chestGenHook);
            } else if (aOldPrediction instanceof PredictionFallInLove) {
                aNewPrediction = new PredictionFallInLove(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey, regularFulfillmentDurationInTicks, regularFulfillmentProbability);
            } else if (aOldPrediction instanceof PredictionRescue) {
                Class aEntityClass = (Class)ReflectionUtils.getFieldValue(mRescueEntityClass, aOldPrediction);
                aNewPrediction = new PredictionRescue(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey, regularFulfillmentDurationInTicks, regularFulfillmentProbability, aEntityClass);
            }
        } else if (aOldPrediction instanceof PredictionFight) {
            Class aEntityClass = (Class)ReflectionUtils.getFieldValue(mFightEntityClass, aOldPrediction);
            boolean aBindTameable = (Boolean)ReflectionUtils.getFieldValue(mBindTameable, aOldPrediction);
            aNewPrediction = new PredictionFight(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey, aEntityClass, aBindTameable);
        } else if (aOldPrediction instanceof PredictionArrow) {
            aNewPrediction = new PredictionArrow(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey);
        } else if (aOldPrediction instanceof PredictionFall) {
            aNewPrediction = new PredictionFall(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey);
        } else if (aOldPrediction instanceof PredictionWet) {
            aNewPrediction = new PredictionWet(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey);
        } else if (aOldPrediction instanceof PredictionNetherTrip) {
            aNewPrediction = new PredictionNetherTrip(predictionID, aNewWeight, selfFulfillmentProbabilityPerSec, translationKey);
        }
        return aNewPrediction;
    }
}

