/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.api;

import alkalus.main.api.plugin.base.BasePluginWitchery;
import alkalus.main.core.WitcheryExtras;
import alkalus.main.core.crafting.OvenRecipes;
import alkalus.main.core.types.Witchery_CreaturePower;
import alkalus.main.core.types.Witchery_Distillery;
import alkalus.main.core.types.Witchery_Infusion;
import alkalus.main.core.types.Witchery_Kettle;
import alkalus.main.core.types.Witchery_Oven;
import alkalus.main.core.types.Witchery_Predictions;
import alkalus.main.core.types.Witchery_Rite;
import alkalus.main.core.types.Witchery_SpinningWheel;
import alkalus.main.core.util.AutoMap;
import alkalus.main.core.util.WitcheryRecipeHandlerInternal;
import com.emoniph.witchery.crafting.DistilleryRecipes;
import com.emoniph.witchery.crafting.KettleRecipes;
import com.emoniph.witchery.crafting.SpinningRecipes;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePower;
import com.emoniph.witchery.predictions.Prediction;
import com.emoniph.witchery.ritual.Circle;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.RitualTraits;
import com.emoniph.witchery.ritual.Sacrifice;
import java.util.EnumSet;
import java.util.Hashtable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class RecipeManager {

    public static class Infusions {
        public static synchronized boolean add(Infusion infusion) {
            return WitcheryRecipeHandlerInternal.addNewInfusion(infusion);
        }

        public static synchronized boolean remove(Infusion infusion) {
            return WitcheryRecipeHandlerInternal.removeInfusion(infusion);
        }

        public static Infusion getInfusion(int i) {
            return Witchery_Infusion.getInfusion(i);
        }

        public static Infusion getInfusionOnPlayer(EntityPlayer player) {
            return Witchery_Infusion.getInfusionOnPlayer(player);
        }

        public static int getLastUsedInfusionID() {
            return Witchery_Infusion.getLastUsedInfusionID();
        }
    }

    public static class Predictions {
        public static synchronized boolean add(Prediction prediction) {
            return WitcheryRecipeHandlerInternal.addNewPrediction(prediction);
        }

        public static synchronized boolean remove(Prediction prediction) {
            return WitcheryRecipeHandlerInternal.removePrediction(prediction);
        }

        public static synchronized Hashtable<Integer, Prediction> getPredictions() {
            return Witchery_Predictions.getPredictions();
        }

        public static synchronized Prediction getPrediction(int aID) {
            return Predictions.getPredictions().get(aID);
        }
    }

    public static class RitesAndRituals {
        public static synchronized boolean add(int ritualID, int bookIndex, Rite rite, Sacrifice initialSacrifice, EnumSet<RitualTraits> traits, Circle ... circles) {
            return WitcheryRecipeHandlerInternal.addNewRiteToRiteRegistry(ritualID, bookIndex, rite, initialSacrifice, traits, circles);
        }

        public static synchronized boolean remove(int ritualID) {
            return WitcheryRecipeHandlerInternal.removeRiteFromRiteRegistry(ritualID);
        }

        public static int getLastUsedRitualID() {
            return Witchery_Rite.getLastUsedRiteID();
        }
    }

    public static class CreaturePowers {
        public static synchronized boolean add(CreaturePower power) {
            return WitcheryRecipeHandlerInternal.addNewCreaturePower(power);
        }

        public static synchronized boolean remove(CreaturePower power) {
            return WitcheryRecipeHandlerInternal.removeCreaturePower(power);
        }

        public static synchronized CreaturePower getCreaturePower(EntityLiving entity) {
            return Witchery_CreaturePower.getCreaturePower(entity);
        }

        public static synchronized CreaturePower getCreaturePower(int entityID) {
            return Witchery_CreaturePower.getCreaturePower(entityID);
        }
    }

    public static class Kettle {
        public static synchronized boolean addRecipe(ItemStack output, int hatBonus, int familiarType, float powerRequired, int color, int dimension, boolean inBook, ItemStack ... inputs) {
            return WitcheryRecipeHandlerInternal.addKettleRecipe(output, hatBonus, familiarType, powerRequired, color, dimension, inBook, inputs);
        }

        public static synchronized boolean removeRecipe(ItemStack mOutput) {
            return WitcheryRecipeHandlerInternal.removeKettleRecipe(mOutput);
        }

        public static KettleRecipes.KettleRecipe findRecipeWithSomeInputsAndAnOutput(ItemStack[] inputs, ItemStack output) {
            return Witchery_Kettle.findRecipeWithSomeInputsAndAnOutput(inputs, output);
        }

        public static AutoMap<KettleRecipes.KettleRecipe> findRecipesFor(ItemStack result) {
            return Witchery_Kettle.findRecipesFor(result);
        }
    }

    public static class Distillery {
        public static synchronized boolean addRecipe(ItemStack input1, ItemStack input2, int jars, ItemStack output1, ItemStack output2, ItemStack output3, ItemStack output4) {
            return WitcheryRecipeHandlerInternal.addDistilleryRecipe(input1, input2, jars, output1, output2, output3, output4);
        }

        public static synchronized boolean removeRecipe(DistilleryRecipes.DistilleryRecipe mRecipe) {
            return WitcheryRecipeHandlerInternal.removeDistilleryRecipe(mRecipe);
        }

        public static synchronized DistilleryRecipes.DistilleryRecipe getDistillingResult(ItemStack input1, ItemStack input2, ItemStack jars) {
            return Witchery_Distillery.getDistillingResult(input1, input2, jars);
        }

        public static synchronized DistilleryRecipes.DistilleryRecipe findRecipeForOutput(ItemStack result) {
            return Witchery_Distillery.findRecipeFor(result);
        }

        public static synchronized DistilleryRecipes.DistilleryRecipe findRecipeUsingIngredient(ItemStack ingredient) {
            return Witchery_Distillery.findRecipeUsing(ingredient);
        }
    }

    public static class SpinningWheel {
        public static boolean addRecipe(ItemStack aInputFibre, ItemStack aOutput, ItemStack[] aModifiers) {
            return WitcheryRecipeHandlerInternal.addSpinningWheelRecipe(aOutput, aInputFibre, aModifiers);
        }

        public static boolean removeRecipe(ItemStack result, ItemStack fibre, ItemStack ... modifiers) {
            return WitcheryRecipeHandlerInternal.removeSpinningWheelRecipe(result, fibre, modifiers);
        }

        public static synchronized boolean removeRecipe(SpinningRecipes.SpinningRecipe mRecipe) {
            return WitcheryRecipeHandlerInternal.removeSpinningRecipe(mRecipe);
        }

        public static synchronized SpinningRecipes.SpinningRecipe getRecipe(ItemStack fibre, ItemStack[] modifiers) {
            return Witchery_SpinningWheel.getRecipe(fibre, modifiers);
        }

        public static synchronized SpinningRecipes.SpinningRecipe findRecipeFor(ItemStack result) {
            return Witchery_SpinningWheel.findRecipeFor(result);
        }

        public static synchronized SpinningRecipes.SpinningRecipe findRecipeUsing(ItemStack ingredient) {
            return Witchery_SpinningWheel.findRecipeUsing(ingredient);
        }

        public static synchronized SpinningRecipes.SpinningRecipe findRecipeUsingFibre(ItemStack ingredient) {
            return Witchery_SpinningWheel.findRecipeUsingFibre(ingredient);
        }
    }

    public static class WitchesOven {
        public static synchronized boolean addRecipe(ItemStack input1, String inputString1, int jars, ItemStack customOutput, int amt1, ItemStack outputJarStack, int amt2) {
            return WitcheryRecipeHandlerInternal.addOvenRecipe(input1, inputString1, jars, customOutput, amt1, outputJarStack, amt2);
        }

        public static synchronized boolean removeRecipe(OvenRecipes.OvenRecipe mRecipe) {
            return WitcheryRecipeHandlerInternal.removeOvenRecipe(mRecipe);
        }

        public static synchronized OvenRecipes.OvenRecipe getOvenResult(ItemStack input1, int jars) {
            return Witchery_Oven.getOvenResult(input1, jars);
        }

        public static synchronized OvenRecipes.OvenRecipe findRecipeForOutput(ItemStack result) {
            return Witchery_Oven.findRecipeFor(result);
        }

        public static synchronized OvenRecipes.OvenRecipe findRecipeUsingIngredient(ItemStack ingredient) {
            return Witchery_Oven.findRecipeUsing(ingredient);
        }
    }

    public static class PluginManager {
        public static boolean loadPluginForPreInit(BasePluginWitchery basePluginWitchery) {
            WitcheryExtras.addEventPreInit(basePluginWitchery);
            return true;
        }

        public static boolean loadPluginForInit(BasePluginWitchery plugin) {
            WitcheryExtras.addEventInit(plugin);
            return true;
        }

        public static boolean loadPluginForPostInit(BasePluginWitchery plugin) {
            WitcheryExtras.addEventPostInit(plugin);
            return true;
        }
    }
}

