/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.item;

import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.InventoryCoalJetpack;
import com.darkona.adventurebackpack.item.ItemAdventure;
import com.darkona.adventurebackpack.network.GUIPacket;
import com.darkona.adventurebackpack.network.PlayerActionPacket;
import com.darkona.adventurebackpack.network.messages.EntityParticlePacket;
import com.darkona.adventurebackpack.network.messages.EntitySoundPacket;
import com.darkona.adventurebackpack.proxy.ClientProxy;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.TipUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ItemCoalJetpack
extends ItemAdventure {
    public ItemCoalJetpack() {
        this.func_77655_b("coalJetpack");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(BackpackUtils.createJetpackStack());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltips, boolean advanced) {
        FluidTank waterTank = new FluidTank(6000);
        FluidTank steamTank = new FluidTank(12000);
        NBTTagCompound jetpackTag = BackpackUtils.getWearableCompound(stack);
        if (GuiScreen.func_146272_n()) {
            NBTTagList itemList = jetpackTag.func_150295_c("inventory", 10);
            tooltips.add(TipUtils.l10n("jetpack.fuel") + ": " + TipUtils.slotStackTooltip(itemList, 2));
            waterTank.readFromNBT(jetpackTag.func_74775_l("waterTank"));
            tooltips.add(TipUtils.l10n("jetpack.tank.water") + ": " + TipUtils.tankTooltip(waterTank));
            steamTank.readFromNBT(jetpackTag.func_74775_l("steamTank"));
            String theSteam = steamTank.getFluidAmount() > 0 ? EnumChatFormatting.AQUA + TipUtils.l10n("steam") : "";
            tooltips.add(TipUtils.l10n("jetpack.tank.steam") + ": " + TipUtils.tankTooltip(steamTank, false) + theSteam);
            TipUtils.shiftFooter(tooltips);
        } else if (!GuiScreen.func_146271_m()) {
            tooltips.add(TipUtils.holdShift());
        }
        if (GuiScreen.func_146271_m()) {
            tooltips.add(TipUtils.l10n("max.altitude") + ": " + TipUtils.whiteFormat("185 ") + TipUtils.l10n("meters"));
            tooltips.add(TipUtils.pressShiftKeyFormat(TipUtils.actionKeyFormat()) + TipUtils.l10n("jetpack.key.onoff1"));
            tooltips.add(TipUtils.l10n("jetpack.key.onoff2") + " " + TipUtils.l10n("on"));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            ModNetwork.net.sendToServer((IMessage)new GUIPacket.GUImessage(3, 1));
        }
        return stack;
    }

    @Override
    public void onEquipped(World world, EntityPlayer player, ItemStack stack) {
        InventoryCoalJetpack inv = new InventoryCoalJetpack(stack);
        if (inv.getTemperature() == 0) {
            inv.setTemperature(this.getBiomeMinTemp(player, world));
        }
    }

    @Override
    public void onEquippedUpdate(World world, EntityPlayer player, ItemStack stack) {
        boolean canUse;
        InventoryCoalJetpack inv = new InventoryCoalJetpack(stack);
        inv.func_70295_k_();
        boolean mustFizzz = !inv.isInUse();
        int CoalConsumed = 13;
        boolean bl = canUse = inv.getSteamTank().drain(CoalConsumed, false) != null;
        if (inv.getStatus()) {
            this.runFirebox(inv);
        }
        this.runHeater(inv, world, player);
        this.runBoiler(inv, world, player);
        inv.dirtyBoiler();
        if (player.func_70090_H()) {
            inv.getWaterTank().fill(new FluidStack(FluidRegistry.WATER, 2), true);
        }
        if (world.field_72995_K) {
            if (inv.getStatus() && canUse && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
                inv.setInUse(true);
                ModNetwork.net.sendToServer((IMessage)new PlayerActionPacket.ActionMessage(1));
                if (mustFizzz) {
                    ModNetwork.net.sendToServer((IMessage)new EntitySoundPacket.Message(2, (Entity)player));
                }
            } else {
                inv.setInUse(false);
                ModNetwork.net.sendToServer((IMessage)new PlayerActionPacket.ActionMessage(2));
            }
        }
        if (inv.isInUse() && canUse) {
            ItemCoalJetpack.elevate(player);
            inv.getSteamTank().drain(CoalConsumed, true);
            if (inv.getSteamTank().getFluidAmount() == 0) {
                inv.setInUse(false);
            }
            player.func_70060_a(player.field_70702_br, player.field_70701_bs, 0.02f);
            if (player.field_70143_R > 1.0f) {
                player.field_70143_R -= 1.0f;
            }
            if (player.field_70181_x >= 0.0) {
                player.field_70143_R = 0.0f;
            }
            if (!world.field_72995_K) {
                ModNetwork.sendToNearby(new EntityParticlePacket.Message(3, (Entity)player), player);
            }
        }
        inv.func_70305_f();
    }

    private static void elevate(EntityPlayer player) {
        if (player.field_70163_u < 135.0) {
            player.field_70181_x = player.field_70181_x <= 0.32 ? (player.field_70181_x += 0.1) : Math.max(player.field_70181_x, 0.32);
        } else if (player.field_70163_u < 185.0) {
            player.field_70181_x = 0.32 - (player.field_70163_u - 135.0) / 160.0;
        } else if (player.field_70163_u >= 185.0) {
            player.field_70181_x += 0.0;
        }
    }

    private void runBoiler(InventoryCoalJetpack inv, World world, EntityPlayer player) {
        int temperature = inv.getTemperature();
        boolean mustSSSSS = !inv.isLeaking();
        boolean mustBlublub = !inv.isBoiling();
        boolean boiling = inv.isBoiling();
        boolean leaking = inv.isLeaking();
        if (temperature >= 100 && inv.getWaterTank().getFluidAmount() > 0) {
            if (!boiling) {
                boiling = true;
            }
            if (!world.field_72995_K && mustBlublub) {
                ModNetwork.net.sendTo((IMessage)new EntitySoundPacket.Message(3, (Entity)player), (EntityPlayerMP)player);
            }
        } else if (boiling) {
            boiling = false;
        }
        if (boiling && inv.getSteamTank().getFluidAmount() < inv.getSteamTank().getCapacity() && inv.getWaterTank().getFluid() != null) {
            int water = inv.getWaterTank().drain((int)(temperature / 100), (boolean)true).amount;
            inv.getSteamTank().fill(new FluidStack(FluidRegistry.getFluid((String)"water"), water * 4), true);
            inv.dirtyTanks();
        }
        if (inv.getSteamTank().getFluidAmount() < inv.getSteamTank().getCapacity() - 100) {
            if (leaking) {
                leaking = false;
            }
        } else if (!leaking) {
            leaking = true;
            if (!world.field_72995_K && mustSSSSS) {
                ModNetwork.net.sendTo((IMessage)new EntitySoundPacket.Message(4, (Entity)player), (EntityPlayerMP)player);
            }
        }
        inv.setBoiling(boiling);
        inv.setLeaking(leaking);
        inv.setTemperature(temperature);
    }

    private void runFirebox(InventoryCoalJetpack inv) {
        if (inv.getBurnTicks() <= 0) {
            inv.setBurnTicks(inv.consumeFuel());
            inv.setCurrentItemBurnTime(inv.getBurnTicks());
        }
        inv.dirtyInventory();
    }

    private void runHeater(InventoryCoalJetpack inv, World world, EntityPlayer player) {
        int temperature = inv.getTemperature();
        int burnTicks = inv.getBurnTicks() - 1;
        int coolTicks = inv.getCoolTicks() - 1;
        if (burnTicks > 0) {
            if (temperature < 200 && burnTicks % inv.getIncreasingFactor() == 0) {
                ++temperature;
                coolTicks = coolTicks < 5000 ? coolTicks + 100 : coolTicks;
            }
        } else {
            inv.setCurrentItemBurnTime(0);
            if (coolTicks % inv.getDecreasingFactor() == 0) {
                temperature = temperature - 1 >= this.getBiomeMinTemp(player, world) ? temperature - 1 : 0;
            }
        }
        inv.setTemperature(temperature);
        inv.setCoolTicks(coolTicks);
        inv.setBurnTicks(burnTicks <= 0 ? 0 : burnTicks);
    }

    @Override
    public void onUnequipped(World world, EntityPlayer player, ItemStack stack) {
        InventoryCoalJetpack inv = new InventoryCoalJetpack(stack);
        inv.setBoiling(false);
        inv.setInUse(false);
        inv.setLeaking(false);
        inv.setStatus(false);
        inv.func_70296_d();
    }

    @Override
    public void onPlayerDeath(World world, EntityPlayer player, ItemStack stack) {
        this.onUnequipped(world, player, stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getTemperature(stack) / 200.0f + 50.0f;
    }

    private int getTemperature(ItemStack jetpack) {
        return BackpackUtils.getWearableCompound(jetpack).func_74762_e("temperature");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ConfigHandler.enableTemperatureBar && this.getTemperature(stack) > 50;
    }

    private int getBiomeMinTemp(EntityPlayer player, World world) {
        BiomeDictionary.Type[] thisBiomeTypes;
        for (BiomeDictionary.Type type : thisBiomeTypes = BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_72807_a((int)player.field_70165_t, (int)player.field_70161_v))) {
            if (type == BiomeDictionary.Type.COLD || type == BiomeDictionary.Type.SNOWY) {
                return 0;
            }
            if (type == BiomeDictionary.Type.HOT || type == BiomeDictionary.Type.BEACH) {
                return 30;
            }
            if (type != BiomeDictionary.Type.NETHER) continue;
            return 40;
        }
        return 25;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getWearableModel(ItemStack wearable) {
        return ClientProxy.modelCoalJetpack.setWearable(wearable);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getWearableTexture(ItemStack wearable) {
        return Resources.modelTextures("coalJetpack");
    }
}

