/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.network;

import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.config.ConfigHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class SleepingBagPacket
implements IMessageHandler<SleepingBagMessage, IMessage> {
    public IMessage onMessage(SleepingBagMessage message, MessageContext ctx) {
        if (ctx.side.isServer() && (message.isTile || ConfigHandler.portableSleepingBag)) {
            ServerActions.toggleSleepingBag((EntityPlayer)ctx.getServerHandler().field_147369_b, message.isTile, message.cX, message.cY, message.cZ);
        }
        return null;
    }

    public static class SleepingBagMessage
    implements IMessage {
        private boolean isTile;
        private int cX;
        private int cY;
        private int cZ;

        public SleepingBagMessage() {
        }

        public SleepingBagMessage(boolean isTile, int cX, int cY, int cZ) {
            this.isTile = isTile;
            this.cX = cX;
            this.cY = cY;
            this.cZ = cZ;
        }

        public void fromBytes(ByteBuf buf) {
            this.isTile = buf.readBoolean();
            this.cX = buf.readInt();
            this.cY = buf.readInt();
            this.cZ = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.isTile);
            buf.writeInt(this.cX);
            buf.writeInt(this.cY);
            buf.writeInt(this.cZ);
        }
    }
}

