/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client.gui;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.client.gui.GuiImageButtonNormal;
import com.darkona.adventurebackpack.client.gui.GuiTank;
import com.darkona.adventurebackpack.client.gui.GuiWithTanks;
import com.darkona.adventurebackpack.common.Constants;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.ContainerBackpack;
import com.darkona.adventurebackpack.inventory.IInventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.network.PlayerActionPacket;
import com.darkona.adventurebackpack.network.SleepingBagPacket;
import com.darkona.adventurebackpack.reference.LoadedMods;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.TinkersUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAdvBackpack
extends GuiWithTanks {
    private static final ResourceLocation TEXTURE = Resources.guiTextures("guiBackpackNew");
    private static final int TINKERS_SLOT = 38;
    private static GuiImageButtonNormal bedButton = new GuiImageButtonNormal(5, 91, 18, 18);
    private static GuiImageButtonNormal equipButton = new GuiImageButtonNormal(5, 91, 18, 18);
    private static GuiImageButtonNormal unequipButton = new GuiImageButtonNormal(5, 91, 18, 18);
    private static GuiTank tankLeft = new GuiTank(25, 7, 100, 16, ConfigHandler.typeTankRender);
    private static GuiTank tankRight = new GuiTank(207, 7, 100, 16, ConfigHandler.typeTankRender);
    private IInventoryBackpack inventory;
    private boolean isHoldingSpace;

    public GuiAdvBackpack(EntityPlayer player, TileAdventureBackpack tileBackpack, Constants.Source source) {
        super(new ContainerBackpack(player, tileBackpack, source));
        this.player = player;
        this.inventory = tileBackpack;
        this.source = source;
        this.field_146999_f = 248;
        this.field_147000_g = 207;
    }

    public GuiAdvBackpack(EntityPlayer player, InventoryBackpack inventoryBackpack, Constants.Source source) {
        super(new ContainerBackpack(player, inventoryBackpack, source));
        this.player = player;
        this.inventory = inventoryBackpack;
        this.source = source;
        this.field_146999_f = 248;
        this.field_147000_g = 207;
    }

    private boolean isBedButtonCase() {
        return this.source == Constants.Source.TILE || ConfigHandler.portableSleepingBag && this.source == Constants.Source.WEARING && GuiScreen.func_146272_n();
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.isBedButtonCase()) {
            if (bedButton.inButton(this, mouseX, mouseY)) {
                bedButton.draw(this, 20, 227);
            } else {
                bedButton.draw(this, 1, 227);
            }
        } else if (this.source == Constants.Source.WEARING) {
            if (unequipButton.inButton(this, mouseX, mouseY)) {
                unequipButton.draw(this, 96, 227);
            } else {
                unequipButton.draw(this, 77, 227);
            }
        } else if (this.source == Constants.Source.HOLDING) {
            if (equipButton.inButton(this, mouseX, mouseY)) {
                equipButton.draw(this, 96, 208);
            } else {
                equipButton.draw(this, 77, 208);
            }
        }
        if (ConfigHandler.tanksHoveringText) {
            if (tankLeft.inTank(this, mouseX, mouseY)) {
                this.drawHoveringText(tankLeft.getTankTooltip(), mouseX, mouseY, this.field_146289_q);
            }
            if (tankRight.inTank(this, mouseX, mouseY)) {
                this.drawHoveringText(tankRight.getTankTooltip(), mouseX, mouseY, this.field_146289_q);
            }
        }
        if (LoadedMods.TCONSTRUCT && ConfigHandler.tinkerToolsMaintenance && this.inventory.func_70301_a(38) == null) {
            this.field_146297_k.func_110434_K().func_110577_a(TinkersUtils.GUI_ICONS);
            this.func_73729_b(this.field_147003_i + 169, this.field_147009_r + 77, 0, 233, 18, 18);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.inventory.func_70295_k_();
        FluidTank lft = this.inventory.getLeftTank();
        FluidTank rgt = this.inventory.getRightTank();
        tankLeft.draw(this, lft);
        tankRight.draw(this, rgt);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
    }

    @Override
    protected GuiImageButtonNormal getEquipButton() {
        return equipButton;
    }

    @Override
    protected GuiImageButtonNormal getUnequipButton() {
        return unequipButton;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.isBedButtonCase() && bedButton.inButton(this, mouseX, mouseY)) {
            if (this.source == Constants.Source.TILE) {
                TileAdventureBackpack te = (TileAdventureBackpack)this.inventory;
                ModNetwork.net.sendToServer((IMessage)new SleepingBagPacket.SleepingBagMessage(true, te.field_145851_c, te.field_145848_d, te.field_145849_e));
            } else {
                int posX = MathHelper.func_76128_c((double)this.player.field_70165_t);
                int posY = MathHelper.func_76128_c((double)this.player.field_70163_u) - 1;
                int posZ = MathHelper.func_76128_c((double)this.player.field_70161_v);
                ModNetwork.net.sendToServer((IMessage)new SleepingBagPacket.SleepingBagMessage(false, posX, posY, posZ));
            }
        } else {
            super.func_73864_a(mouseX, mouseY, button);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.isHoldingSpace) {
            if (Keyboard.isKeyDown((int)57)) {
                this.isHoldingSpace = true;
                ModNetwork.net.sendToServer((IMessage)new PlayerActionPacket.ActionMessage(3));
                this.inventory.getExtendedProperties().func_74757_a("holdingSpace", true);
            }
        } else if (!Keyboard.isKeyDown((int)57)) {
            this.isHoldingSpace = false;
            ModNetwork.net.sendToServer((IMessage)new PlayerActionPacket.ActionMessage(4));
            this.inventory.getExtendedProperties().func_82580_o("holdingSpace");
        }
    }
}

