/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.entity;

import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.Wearing;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIControlledByPlayer;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityFriendlySpider
extends EntityCreature {
    private float prevRearingAmount;
    private int jumpTicks;
    private EntityPlayer owner;
    private boolean tamed = false;
    private final EntityAIControlledByPlayer aiControlledByPlayer;

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    public EntityFriendlySpider(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.aiControlledByPlayer = new EntityAIControlledByPlayer((EntityLiving)this, 0.3f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiControlledByPlayer);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public int func_70627_aG() {
        return 300;
    }

    protected String func_70639_aQ() {
        return "mob.spider.say";
    }

    protected String func_70621_aR() {
        return "mob.spider.say";
    }

    protected String func_70673_aS() {
        return "mob.spider.death";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected String func_145776_H() {
        return "game.hostile.swim";
    }

    protected String func_145777_O() {
        return "game.hostile.swim.splash";
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (super.func_70097_a(damageSource, amount)) {
            Entity entity = damageSource.func_76346_g();
            if (this.field_70153_n != entity && this.field_70154_o != entity) {
                if (entity != this) {
                    this.field_70789_a = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public float func_70783_a(int p_70783_1_, int p_70783_2_, int p_70783_3_) {
        return 0.5f - this.field_70170_p.func_72801_o(p_70783_1_, p_70783_2_, p_70783_3_);
    }

    public boolean func_70601_bi() {
        return false;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public ItemStack func_70694_bm() {
        return null;
    }

    public ItemStack func_71124_b(int slot) {
        return null;
    }

    public void func_70062_b(int slot, ItemStack stack) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    public boolean canRiderInteract() {
        return false;
    }

    protected boolean func_70085_c(EntityPlayer player) {
        try {
            if (!this.field_70170_p.field_72995_K && Wearing.isWearingTheRightBackpack(player, BackpackTypes.SPIDER)) {
                player.func_70078_a((Entity)this);
                return true;
            }
        }
        catch (Exception oops) {
            return false;
        }
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    protected Entity func_70782_k() {
        if (this.field_70153_n != null) {
            return null;
        }
        float f = this.func_70013_c(1.0f);
        if (f < 0.5f) {
            double d0 = 16.0;
            return this.field_70170_p.func_72856_b((Entity)this, d0);
        }
        return null;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean shouldRiderFaceForward(EntityPlayer player) {
        return true;
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean p_70839_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_75684_a()) {
            this.field_70180_af.func_111144_e();
        }
        if (this.field_70153_n instanceof EntityPlayer) {
            // empty if block
        }
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    private void normalLivingUpdateWithNoAI() {
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.field_70716_bi > 0) {
            double d0 = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
            double d1 = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
            double d2 = this.field_70161_v + (this.field_110152_bk - this.field_70161_v) / (double)this.field_70716_bi;
            double d3 = MathHelper.func_76138_g((double)(this.field_70712_bm - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70705_bn - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        if (Math.abs(this.field_70159_w) < 0.005) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.005) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.005) {
            this.field_70179_y = 0.0;
        }
        this.field_70170_p.field_72984_F.func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            this.field_70704_bt = 0.0f;
        } else if (this.func_70613_aW()) {
            // empty if block
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("jump");
        if (this.field_70703_bu) {
            if (!this.func_70090_H() && !this.func_70058_J()) {
                if (this.field_70122_E && this.jumpTicks == 0) {
                    this.func_70664_aZ();
                    this.jumpTicks = 10;
                }
            } else {
                this.field_70181_x += (double)0.04f;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.func_70637_d(false);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("travel");
        this.field_70702_br *= 0.98f;
        this.field_70701_bs *= 0.98f;
        this.field_70704_bt *= 0.9f;
        this.func_70612_e(this.field_70702_br, this.field_70701_bs);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("push");
        if (!this.field_70170_p.field_72995_K) {
            this.func_85033_bc();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public void func_70636_d() {
        if (this.field_70153_n != null) {
            this.normalLivingUpdateWithNoAI();
        } else {
            super.func_70636_d();
        }
        this.func_82168_bl();
    }

    public double func_70042_X() {
        return super.func_70042_X();
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n != null) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.2f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.prevRearingAmount > 0.0f) {
            float f = MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f2 = 0.7f * this.prevRearingAmount;
            float f3 = 0.15f * this.prevRearingAmount;
            this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
            if (this.field_70153_n instanceof EntityLivingBase) {
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    public void spiderJump() {
        this.func_70683_ar().func_75660_a();
    }

    protected void func_70785_a(Entity p_70785_1_, float p_70785_2_) {
        float f1 = this.func_70013_c(1.0f);
        if (f1 > 0.5f && this.field_70146_Z.nextInt(100) == 0) {
            this.field_70789_a = null;
        } else if (p_70785_2_ > 2.0f && p_70785_2_ < 6.0f && this.field_70146_Z.nextInt(10) == 0) {
            if (this.field_70122_E) {
                double d0 = p_70785_1_.field_70165_t - this.field_70165_t;
                double d1 = p_70785_1_.field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f2 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.4f;
            }
        } else {
            super.func_70785_a(p_70785_1_, p_70785_2_);
        }
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        super.func_70628_a(p_70628_1_, p_70628_2_);
        if (p_70628_1_ && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect p_70687_1_) {
        return p_70687_1_.func_76456_a() == Potion.field_76436_u.field_76415_H ? false : super.func_70687_e(p_70687_1_);
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_111105_a;
        private static final String __OBFID = "CL_00001700";

        public void func_111104_a(Random p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.field_111105_a = Potion.field_76424_c.field_76415_H;
            } else if (i <= 2) {
                this.field_111105_a = Potion.field_76420_g.field_76415_H;
            } else if (i <= 3) {
                this.field_111105_a = Potion.field_76428_l.field_76415_H;
            } else if (i <= 4) {
                this.field_111105_a = Potion.field_76441_p.field_76415_H;
            }
        }
    }
}

