/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.reference.BackpackTypes;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;

public class Utils {
    private static final EnumChatFormatting[] RAINBOW_SEQUENCE = new EnumChatFormatting[]{EnumChatFormatting.RED, EnumChatFormatting.GOLD, EnumChatFormatting.YELLOW, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.BLUE, EnumChatFormatting.DARK_PURPLE};

    public static boolean inServer() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public static boolean inClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static float degreesToRadians(float degrees) {
        return degrees / 57.29578f;
    }

    public static float radiansToDegrees(float radians) {
        return radians * 57.29578f;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int[] createSlotArray(int first, int count) {
        int[] slots = new int[count];
        for (int i = first; i < first + count; ++i) {
            slots[i - first] = i;
        }
        return slots;
    }

    public static String makeItRainbow(String stringIn) {
        StringBuilder rainbowed = new StringBuilder(stringIn.length() * 3);
        for (int i = 0; i < stringIn.length(); ++i) {
            rainbowed.append(RAINBOW_SEQUENCE[i % RAINBOW_SEQUENCE.length]).append(stringIn.charAt(i));
        }
        return rainbowed.toString();
    }

    public static String getColoredSkinName(BackpackTypes type) {
        String result;
        String name = BackpackTypes.getLocalizedName(type);
        switch (type) {
            case BAT: {
                result = EnumChatFormatting.DARK_PURPLE + name;
                break;
            }
            case EMERALD: {
                result = Utils.animateString(name, EnumChatFormatting.GREEN);
                break;
            }
            case DIAMOND: {
                result = Utils.animateString(name, EnumChatFormatting.AQUA);
                break;
            }
            case DRAGON: {
                result = EnumChatFormatting.LIGHT_PURPLE + name;
                break;
            }
            case GOLD: {
                result = Utils.animateString(name, EnumChatFormatting.YELLOW);
                break;
            }
            case IRON_GOLEM: {
                result = EnumChatFormatting.WHITE + name;
                break;
            }
            case OBSIDIAN: {
                result = Utils.animateString(name, EnumChatFormatting.DARK_PURPLE);
                break;
            }
            case PIGMAN: {
                result = EnumChatFormatting.RED + name;
                break;
            }
            case QUARTZ: {
                result = Utils.animateString(name, EnumChatFormatting.WHITE);
                break;
            }
            case RAINBOW: {
                result = Utils.makeItRainbow(name);
                break;
            }
            case SQUID: {
                result = EnumChatFormatting.DARK_AQUA + name;
                break;
            }
            default: {
                result = name;
            }
        }
        return result;
    }

    private static String animateString(String stringIn, EnumChatFormatting bold) {
        return Utils.animateString(stringIn, EnumChatFormatting.GRAY, bold);
    }

    private static String animateString(String stringIn, EnumChatFormatting regular, EnumChatFormatting bold) {
        int len = stringIn.length();
        int time = Math.abs((int)Minecraft.func_71410_x().field_71441_e.func_72820_D());
        int k = 1;
        int charID = time / k % len;
        int n = 100 / len;
        int phaseFactor = time / k % (len * n);
        int phase = 1 + phaseFactor / len;
        if (phase == 1) {
            return Utils.decorateCharInString(stringIn, charID, regular, bold, phase % 2 != 0);
        }
        return stringIn;
    }

    private static String decorateCharInString(String stringIn, int charID, EnumChatFormatting regular, EnumChatFormatting bold, boolean dir) {
        int i;
        int len = stringIn.length();
        StringBuilder decorated = new StringBuilder();
        int n = i = dir ? 0 : len - 1;
        while (dir ? i < len : i >= 0) {
            if (i == charID) {
                decorated.append(bold);
            } else if (i == (dir ? charID + 1 : charID - 1) && regular != null) {
                decorated.append(regular);
            }
            decorated.append(stringIn.charAt(dir ? i : len - 1 - i));
            i = dir ? ++i : --i;
        }
        return decorated.toString();
    }
}

