/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.config.Keybindings;
import com.darkona.adventurebackpack.reference.GeneralReference;
import cpw.mods.fml.common.registry.GameData;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public final class TipUtils {
    private TipUtils() {
    }

    public static String l10n(String tip) {
        return StatCollector.func_74838_a((String)("adventurebackpack:tooltips." + tip));
    }

    public static void shiftFooter(List<String> eventTips) {
        if (GuiScreen.func_146271_m()) {
            eventTips.add("");
        } else {
            eventTips.add(TipUtils.holdCtrl());
        }
    }

    public static String holdShift() {
        return TipUtils.holdThe(true);
    }

    public static String holdCtrl() {
        return TipUtils.holdThe(false);
    }

    private static String holdThe(boolean button) {
        return TipUtils.whiteFormat(EnumChatFormatting.ITALIC + "<" + (button ? TipUtils.l10n("hold.shift") : TipUtils.l10n("hold.ctrl")) + ">");
    }

    public static String whiteFormat(String stringIn) {
        return EnumChatFormatting.WHITE + stringIn + EnumChatFormatting.GRAY;
    }

    public static String actionKeyFormat() {
        return TipUtils.whiteFormat(Keybindings.getActionKeyName());
    }

    public static String pressKeyFormat(String button) {
        return TipUtils.l10n("press") + " '" + button + "' ";
    }

    public static String pressShiftKeyFormat(String button) {
        return TipUtils.l10n("press") + " Shift+'" + button + "' ";
    }

    public static String inventoryTooltip(NBTTagList itemList) {
        int slotAtI;
        int itemCount = itemList.func_74745_c();
        boolean toolSlotU = false;
        boolean toolSlotL = false;
        for (int i = itemCount - 1; i >= 0 && (slotAtI = itemList.func_150305_b(i).func_74762_e("Slot")) >= 48; --i) {
            if (slotAtI == 48) {
                toolSlotU = true;
                continue;
            }
            if (slotAtI == 49) {
                toolSlotL = true;
                continue;
            }
            --itemCount;
        }
        return TipUtils.toolSlotFormat(toolSlotU) + TipUtils.toolSlotFormat(toolSlotL) + " " + TipUtils.mainSlotsFormat(itemCount -= (toolSlotU ? 1 : 0) + (toolSlotL ? 1 : 0));
    }

    private static String toolSlotFormat(boolean isTool) {
        return (isTool ? EnumChatFormatting.WHITE : EnumChatFormatting.DARK_GRAY) + "[]";
    }

    private static String mainSlotsFormat(int slotsUsed) {
        String slotsFormatted = Integer.toString(slotsUsed);
        slotsFormatted = slotsUsed == 0 ? EnumChatFormatting.DARK_GRAY + slotsFormatted : (slotsUsed == 48 ? EnumChatFormatting.WHITE + slotsFormatted : EnumChatFormatting.GRAY + slotsFormatted);
        return slotsFormatted + "/" + 48;
    }

    public static String tankTooltip(FluidTank tank) {
        return TipUtils.tankTooltip(tank, true);
    }

    public static String tankTooltip(FluidTank tank, boolean attachName) {
        String fluidAmount = TipUtils.fluidAmountFormat(tank.getFluidAmount(), tank.getCapacity());
        String fluidName = tank.getFluid() == null ? "" : (attachName ? TipUtils.fluidNameFormat(tank.getFluid()) : " ");
        return fluidAmount + (tank.getFluidAmount() > 0 ? "/" + tank.getCapacity() : "") + fluidName;
    }

    private static String fluidAmountFormat(int fluidAmount, int tankCapacity) {
        String amountFormatted = Integer.toString(fluidAmount);
        if (fluidAmount == tankCapacity) {
            amountFormatted = EnumChatFormatting.WHITE + amountFormatted;
        } else if (fluidAmount == 0) {
            amountFormatted = TipUtils.emptyFormat();
        }
        return amountFormatted;
    }

    private static String fluidNameFormat(FluidStack fluid) {
        String nameUnlocalized = fluid.getUnlocalizedName().toLowerCase();
        String nameFormatted = " ";
        nameFormatted = nameUnlocalized.contains("lava") || nameUnlocalized.contains("fire") ? nameFormatted + EnumChatFormatting.RED : (nameUnlocalized.contains("water") ? nameFormatted + EnumChatFormatting.BLUE : (nameUnlocalized.contains("oil") ? nameFormatted + EnumChatFormatting.DARK_GRAY : (nameUnlocalized.contains("fuel") || nameUnlocalized.contains("creosote") ? nameFormatted + EnumChatFormatting.YELLOW : (nameUnlocalized.contains("milk") ? nameFormatted + EnumChatFormatting.WHITE : (nameUnlocalized.contains("xpjuice") ? nameFormatted + EnumChatFormatting.GREEN : nameFormatted + EnumChatFormatting.GRAY)))));
        return nameFormatted + fluid.getLocalizedName();
    }

    public static String switchTooltip(boolean status, boolean doFormat) {
        return doFormat ? TipUtils.switchFormat(status) : (status ? TipUtils.l10n("on") : TipUtils.l10n("off"));
    }

    private static String switchFormat(boolean status) {
        String switchFormatted = status ? EnumChatFormatting.WHITE + TipUtils.l10n("on") : EnumChatFormatting.DARK_GRAY + TipUtils.l10n("off");
        return "[" + switchFormatted + EnumChatFormatting.GRAY + "]";
    }

    public static String slotStackTooltip(NBTTagList itemList, int slot) {
        int slotMeta = 0;
        int slotID = 0;
        int slotCount = 0;
        for (int i = 0; i <= slot; ++i) {
            int slotAtI = itemList.func_150305_b(i).func_74762_e("Slot");
            if (slotAtI != slot) continue;
            slotID = itemList.func_150305_b(i).func_74762_e("id");
            slotMeta = itemList.func_150305_b(i).func_74762_e("Damage");
            slotCount = itemList.func_150305_b(i).func_74762_e("Count");
            break;
        }
        return TipUtils.stackDataFormat(slotID, slotMeta, slotCount);
    }

    private static String stackDataFormat(int id, int meta, int count) {
        String dataFormatted;
        if (count == 0) {
            return TipUtils.emptyFormat();
        }
        try {
            ItemStack iStack = new ItemStack((Item)GameData.getItemRegistry().func_148754_a(id), 0, meta);
            dataFormatted = iStack.func_82833_r() + " (" + TipUtils.stackSizeFormat(iStack, count) + ")";
        }
        catch (Exception e) {
            dataFormatted = EnumChatFormatting.RED + TipUtils.l10n("error");
        }
        return dataFormatted;
    }

    private static String stackSizeFormat(ItemStack stack, int count) {
        return stack.func_77976_d() == count ? TipUtils.whiteFormat(Integer.toString(count)) : Integer.toString(count);
    }

    public static String fuelConsumptionTooltip(FluidTank tank) {
        return tank.getFluid() != null ? String.format("x%.2f", GeneralReference.getFuelRate(tank.getFluid().getFluid().getName())) : EnumChatFormatting.DARK_GRAY + "-";
    }

    private static String emptyFormat() {
        return EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + TipUtils.l10n("empty");
    }
}

