/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.handlers;

import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.entity.ai.EntityAIHorseFollowOwner;
import com.darkona.adventurebackpack.fluids.FluidEffectRegistry;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.network.messages.EntitySoundPacket;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemAppleGold;
import net.minecraft.item.ItemPotion;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.fluids.FluidRegistry;

public class GeneralEventHandler {
    @SubscribeEvent
    public void eatGoldenApple(PlayerUseItemEvent.Finish event) {
        EntityPlayer player = event.entityPlayer;
        if (ConfigHandler.backpackAbilities && event.item.func_77973_b() instanceof ItemAppleGold && Wearing.isWearingTheRightBackpack(player, BackpackTypes.RAINBOW)) {
            InventoryBackpack inv = new InventoryBackpack(Wearing.getWearingBackpack(player));
            if (inv.getLastTime() > 0) {
                return;
            }
            inv.setLastTime(Utils.secondsToTicks(150));
            inv.dirtyTime();
            if (!player.field_70170_p.field_72995_K) {
                String nyanString = Utils.makeItRainbow("NYANCAT");
                player.func_146105_b((IChatComponent)new ChatComponentText(nyanString));
                ModNetwork.sendToNearby(new EntitySoundPacket.Message(0, (Entity)player), player);
            }
        }
        if (event.item.func_77973_b() instanceof ItemPotion && event.item.func_77973_b().getDamage(event.item) == 0 && !player.field_70170_p.field_72995_K) {
            FluidEffectRegistry.executeFluidEffectsForFluid(FluidRegistry.WATER, (Entity)player, player.func_130014_f_());
        }
    }

    @SubscribeEvent
    public void detectBow(ArrowNockEvent event) {
        InventoryBackpack backpack;
        if (!ConfigHandler.backpackAbilities) {
            return;
        }
        if (Wearing.isWearingTheRightBackpack(event.entityPlayer, BackpackTypes.SKELETON) && (backpack = new InventoryBackpack(Wearing.getWearingBackpack(event.entityPlayer))).hasItem(Items.field_151032_g)) {
            event.entityPlayer.func_71008_a(event.result, event.result.func_77988_m());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void detectArrow(ArrowLooseEvent event) {
        InventoryBackpack backpack;
        if (!ConfigHandler.backpackAbilities) {
            return;
        }
        if (Wearing.isWearingTheRightBackpack(event.entityPlayer, BackpackTypes.SKELETON) && (backpack = new InventoryBackpack(Wearing.getWearingBackpack(event.entityPlayer))).hasItem(Items.field_151032_g)) {
            ServerActions.leakArrow(event.entityPlayer, event.bow, event.charge);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void detectLightning(EntityStruckByLightningEvent event) {
        if (event.entity instanceof EntityPlayer) {
            ServerActions.electrify((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void makeHorsesFollowOwner(EntityJoinWorldEvent event) {
        if (!ConfigHandler.backpackAbilities) {
            return;
        }
        if (event.entity instanceof EntityHorse) {
            String ownerUUIDstring;
            EntityHorse horse = (EntityHorse)event.entity;
            if (!horse.field_70128_L && horse.func_110248_bS() && horse.func_94056_bM() && (ownerUUIDstring = horse.func_152119_ch()) != null && !ownerUUIDstring.isEmpty()) {
                boolean set = true;
                if (horse.field_70170_p.func_152378_a(UUID.fromString(ownerUUIDstring)) != null) {
                    for (Object entry : horse.field_70714_bg.field_75782_a) {
                        if (!(((EntityAITasks.EntityAITaskEntry)entry).field_75733_a instanceof EntityAIHorseFollowOwner)) continue;
                        set = false;
                    }
                }
                if (set) {
                    horse.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIHorseFollowOwner(horse, 1.5, 2.0f, 20.0f));
                    if (horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b) != null) {
                        horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
                    }
                }
            }
        }
    }
}

