/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.block;

import com.darkona.adventurebackpack.block.TileAdventure;
import com.darkona.adventurebackpack.common.BackpackAbilities;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.inventory.IInventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.SlotBackpack;
import com.darkona.adventurebackpack.inventory.SlotTool;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.reference.GeneralReference;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.CoordsUtils;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.Wearing;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public class TileAdventureBackpack
extends TileAdventure
implements IInventoryBackpack,
ISidedInventory {
    private static final int[] MAIN_INVENTORY_SLOTS = Utils.createSlotArray(0, 48);
    private BackpackTypes type = BackpackTypes.STANDARD;
    private FluidTank leftTank = new FluidTank(4000);
    private FluidTank rightTank = new FluidTank(4000);
    private NBTTagCompound extendedProperties = new NBTTagCompound();
    private NBTTagList ench;
    private boolean disableCycling;
    private boolean disableNVision;
    private int lastTime = 0;
    private boolean sleepingBagDeployed;
    private int sbdir;
    private int sbx;
    private int sby;
    private int sbz;
    private int checkTime = 0;
    private int luminosity = 0;

    public TileAdventureBackpack() {
        super(54);
    }

    @Override
    public BackpackTypes getType() {
        return this.type;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public FluidTank[] getTanksArray() {
        return new FluidTank[]{this.leftTank, this.rightTank};
    }

    @Override
    public int[] getSlotsOnClosing() {
        return new int[]{50, 52, 51, 53};
    }

    @Override
    public NBTTagCompound getExtendedProperties() {
        return this.extendedProperties;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.loadFromNBT(compound);
        this.sleepingBagDeployed = compound.func_74767_n("sleepingbag");
        this.sbx = compound.func_74762_e("sbx");
        this.sby = compound.func_74762_e("sby");
        this.sbz = compound.func_74762_e("sbz");
        this.sbdir = compound.func_74762_e("sbdir");
        this.luminosity = compound.func_74762_e("lumen");
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("backpackData")) {
            this.convertFromOldNBTFormat(compound);
        }
        if (compound.func_74764_b("ench")) {
            this.ench = compound.func_150295_c("ench", 10);
        }
        NBTTagCompound backpackTag = compound.func_74775_l("wearableData");
        this.type = BackpackTypes.getType(backpackTag.func_74771_c("type"));
        this.setInventoryFromTagList(backpackTag.func_150295_c("inventory", 10));
        this.leftTank.readFromNBT(backpackTag.func_74775_l("leftTank"));
        this.rightTank.readFromNBT(backpackTag.func_74775_l("rightTank"));
        this.extendedProperties = backpackTag.func_74775_l("extendedProperties");
        this.disableCycling = backpackTag.func_74767_n("disableCycling");
        this.disableNVision = backpackTag.func_74767_n("disableNVision");
        this.lastTime = backpackTag.func_74762_e("lastTime");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.saveToNBT(compound);
        compound.func_74757_a("sleepingbag", this.sleepingBagDeployed);
        compound.func_74768_a("sbx", this.sbx);
        compound.func_74768_a("sby", this.sby);
        compound.func_74768_a("sbz", this.sbz);
        compound.func_74768_a("sbdir", this.sbdir);
        compound.func_74768_a("lumen", this.luminosity);
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        if (this.ench != null) {
            compound.func_74782_a("ench", (NBTBase)this.ench);
        }
        NBTTagCompound backpackTag = new NBTTagCompound();
        backpackTag.func_74774_a("type", BackpackTypes.getMeta(this.type));
        backpackTag.func_74782_a("inventory", (NBTBase)this.getInventoryTagList());
        backpackTag.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        backpackTag.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        backpackTag.func_74782_a("extendedProperties", (NBTBase)this.extendedProperties);
        backpackTag.func_74757_a("disableCycling", this.disableCycling);
        backpackTag.func_74757_a("disableNVision", this.disableNVision);
        backpackTag.func_74768_a("lastTime", this.lastTime);
        compound.func_74782_a("wearableData", (NBTBase)backpackTag);
    }

    @Override
    public boolean updateTankSlots() {
        boolean changesMade = false;
        while (InventoryActions.transferContainerTank(this, this.getLeftTank(), 50)) {
            changesMade = true;
        }
        while (InventoryActions.transferContainerTank(this, this.getRightTank(), 52)) {
            changesMade = true;
        }
        return changesMade;
    }

    @Override
    @Deprecated
    public void dirtyExtended() {
        this.dirtyInventory();
    }

    @Override
    @Deprecated
    public void dirtyTime() {
        this.dirtyInventory();
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int lastTime) {
        this.lastTime = lastTime;
    }

    @Override
    public boolean hasItem(Item item) {
        return InventoryActions.hasItem(this, item);
    }

    @Override
    public void consumeInventoryItem(Item item) {
        InventoryActions.consumeItemInInventory(this, item);
    }

    public boolean equip(World world, EntityPlayer player, int x, int y, int z) {
        this.removeSleepingBag(world);
        ItemStack stacky = BackpackUtils.createBackpackStack(this.type);
        this.transferCompoundToStack(stacky);
        if (BackpackUtils.equipWearable(stacky, player) != BackpackUtils.Reasons.SUCCESSFUL) {
            Wearing.WearableType wtype = Wearing.getWearingWearableType(player);
            if (wtype != Wearing.WearableType.UNKNOWN) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.already.equipped." + wtype.name().toLowerCase(), new Object[0]));
            }
            if (!player.field_71071_by.func_70441_a(stacky)) {
                return this.drop(world, player, x, y, z);
            }
        }
        return true;
    }

    public boolean drop(World world, EntityPlayer player, int x, int y, int z) {
        this.removeSleepingBag(world);
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stacky = BackpackUtils.createBackpackStack(this.type);
        this.transferCompoundToStack(stacky);
        float spawnX = (float)x + world.field_73012_v.nextFloat();
        float spawnY = (float)y + world.field_73012_v.nextFloat();
        float spawnZ = (float)z + world.field_73012_v.nextFloat();
        EntityItem droppedItem = new EntityItem(world, (double)spawnX, (double)spawnY, (double)spawnZ, stacky);
        float mult = 0.05f;
        droppedItem.field_70159_w = (-0.3f + world.field_73012_v.nextFloat()) * mult;
        droppedItem.field_70181_x = (3.0f + world.field_73012_v.nextFloat()) * mult;
        droppedItem.field_70179_y = (-0.3f + world.field_73012_v.nextFloat()) * mult;
        return world.func_72838_d((Entity)droppedItem);
    }

    private void transferCompoundToStack(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        this.saveToNBT(compound);
        stack.func_77982_d(compound);
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.sleepingBagDeployed;
    }

    public void setSleepingBagDeployed(boolean state) {
        this.sleepingBagDeployed = state;
    }

    public boolean deploySleepingBag(EntityPlayer player, World world, int meta, int cX, int cY, int cZ) {
        if (world.field_72995_K) {
            return false;
        }
        this.sleepingBagDeployed = CoordsUtils.spawnSleepingBag(player, world, meta, cX, cY, cZ);
        if (this.sleepingBagDeployed) {
            this.sbx = cX;
            this.sby = cY;
            this.sbz = cZ;
            this.sbdir = meta;
            world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.sleepingBagDeployed;
    }

    public void removeSleepingBag(World world) {
        if (this.sleepingBagDeployed && world.func_147439_a(this.sbx, this.sby, this.sbz) == ModBlocks.blockSleepingBag) {
            world.func_147480_a(this.sbx, this.sby, this.sbz, false);
        }
        this.sleepingBagDeployed = false;
        this.func_70296_d();
    }

    public int[] func_94128_d(int side) {
        if (GeneralReference.isDimensionAllowed(this.field_145850_b.field_73011_w.field_76574_g)) {
            return (int[])MAIN_INVENTORY_SLOTS.clone();
        }
        return null;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot <= 47) {
            return SlotBackpack.isValidItem(stack);
        }
        return (slot == 48 || slot == 49) && SlotTool.isValidTool(stack);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145845_h() {
        if (ConfigHandler.backpackAbilities && BackpackTypes.hasProperty(this.type, BackpackTypes.Props.TILE)) {
            BackpackAbilities.backpackAbilities.executeTileAbility(this.field_145850_b, this);
        }
        if (this.checkTime == 0) {
            int lastLumen = this.luminosity;
            int left = this.leftTank.getFluid() != null ? this.leftTank.getFluid().getFluid().getLuminosity() : 0;
            int right = this.rightTank.getFluid() != null ? this.rightTank.getFluid().getFluid().getLuminosity() : 0;
            this.luminosity = Math.max(left, right);
            if (this.luminosity != lastLumen) {
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ModBlocks.blockBackpack, meta, 3);
                this.field_145850_b.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.luminosity);
            }
            if (this.sleepingBagDeployed && this.field_145850_b.func_147439_a(this.sbx, this.sby, this.sbz) != ModBlocks.blockSleepingBag) {
                this.sleepingBagDeployed = false;
            }
            this.checkTime = 20;
        } else {
            --this.checkTime;
        }
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    private void convertFromOldNBTFormat(NBTTagCompound compound) {
        NBTTagCompound oldBackpackTag = compound.func_74775_l("backpackData");
        NBTTagList oldItems = oldBackpackTag.func_150295_c("ABPItems", 10);
        this.leftTank.readFromNBT(oldBackpackTag.func_74775_l("leftTank"));
        this.rightTank.readFromNBT(oldBackpackTag.func_74775_l("rightTank"));
        this.type = BackpackTypes.getType(oldBackpackTag.func_74779_i("colorName"));
        NBTTagCompound newBackpackTag = new NBTTagCompound();
        newBackpackTag.func_74782_a("inventory", (NBTBase)oldItems);
        newBackpackTag.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        newBackpackTag.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        newBackpackTag.func_74774_a("type", BackpackTypes.getMeta(this.type));
        compound.func_74782_a("wearableData", (NBTBase)newBackpackTag);
        compound.func_82580_o("backpackData");
    }
}

