/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client.gui;

import codechicken.lib.render.TextureUtils;
import com.darkona.adventurebackpack.client.gui.GuiWithTanks;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.TipUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class GuiTank {
    private int height;
    private int width;
    private int startX;
    private int startY;
    private int offsetX = 0;
    private int offsetY = 0;
    private int resolution;
    private int liquidPerPixel;
    private float zLevel;
    private FluidTank tank;

    public GuiTank(int X, int Y, int H, int W, int resolution) {
        this.startX = X;
        this.startY = Y;
        this.height = H;
        this.width = W;
        this.resolution = resolution > 0 ? W / resolution : W;
    }

    public List<String> getTankTooltip() {
        FluidStack fluid = this.tank.getFluid();
        String fluidName = fluid != null ? fluid.getLocalizedName() : TipUtils.l10n("empty");
        String fluidAmount = (fluid != null ? fluid.amount : 0) + "/" + 4000;
        ArrayList<String> tankTips = new ArrayList<String>();
        tankTips.add(fluidName);
        tankTips.add(fluidAmount);
        return tankTips;
    }

    public void draw(GuiWithTanks gui, FluidTank theFluid) {
        this.tank = theFluid;
        this.liquidPerPixel = this.tank.getCapacity() / this.height;
        this.zLevel = gui.getZLevel() + 1.0f;
        switch (ConfigHandler.typeTankRender) {
            case 1: {
                this.drawMethodOne(gui);
                break;
            }
            case 2: {
                this.drawMethodTwo();
                break;
            }
            case 3: {
                this.drawMethodThree();
                break;
            }
            default: {
                this.drawMethodThree();
            }
        }
    }

    public void draw(GuiWithTanks gui, FluidTank theFluid, int X, int Y) {
        this.offsetX = X;
        this.offsetY = Y;
        this.draw(gui, theFluid);
    }

    private void drawMethodOne(GuiWithTanks gui) {
        if (this.tank.getFluid() != null) {
            FluidStack fluid = this.tank.getFluid();
            IIcon icon = fluid.getFluid().getStillIcon();
            int pixelsY = fluid.amount / this.liquidPerPixel;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            int maxY = this.startY + this.offsetY + this.height;
            for (int i = this.startX + this.offsetX; i < this.startX + this.offsetX + this.width; i += this.resolution) {
                for (int j = maxY - this.resolution; j >= maxY - pixelsY; j -= this.resolution) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    gui.func_94065_a(i, j, icon, this.resolution, this.resolution);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    private void drawMethodTwo() {
        if (this.tank.getFluid() != null) {
            FluidStack fluid = this.tank.getFluid();
            IIcon icon = fluid.getFluid().getStillIcon();
            int pixelsY = fluid.amount / this.liquidPerPixel;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            int top = this.startY + this.offsetY + this.height - pixelsY;
            int maxY = this.startY + this.offsetY + this.height - 1;
            for (int i = this.startX + this.offsetX; i < this.startX + this.offsetX + this.width; i += this.resolution) {
                int iconY = 7;
                for (int j = maxY; j >= top; --j) {
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GuiTank.drawFluidPixelFromIcon(i, j, icon, this.resolution, 1, 0, iconY, this.resolution, 0, this.zLevel);
                    iconY = iconY == 0 ? 7 : iconY - 1;
                    GL11.glPopMatrix();
                }
            }
        }
    }

    private void drawMethodThree() {
        if (this.tank.getFluid() != null) {
            FluidStack fluid = this.tank.getFluid();
            try {
                IIcon icon = fluid.getFluid().getStillIcon();
                TextureUtils.bindAtlas((int)fluid.getFluid().getSpriteNumber());
                int top = this.startY + this.offsetY + this.height - fluid.amount / this.liquidPerPixel;
                for (int j = this.startY + this.offsetY + this.height - 1; j >= top; --j) {
                    for (int i = this.startX + this.offsetX; i <= this.startX + this.offsetX + this.width - 1; ++i) {
                        GL11.glPushMatrix();
                        if (j >= top + 5) {
                            GL11.glColor4f((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        GuiTank.drawFluidPixelFromIcon(i, j, icon, 1, 1, 0, 0, 0, 0, this.zLevel);
                        GL11.glPopMatrix();
                    }
                }
            }
            catch (Exception oops) {
                LogHelper.error("Exception while trying to render the fluid in the GUI");
            }
        }
    }

    public boolean inTank(GuiWithTanks gui, int mouseX, int mouseY) {
        return this.startX <= (mouseX -= gui.getLeft()) && mouseX <= this.startX + this.offsetX + this.width && this.startY + this.offsetY <= (mouseY -= gui.getTop()) && mouseY <= this.startY + this.offsetY + this.height;
    }

    public static void drawFluidPixelFromIcon(int x, int y, IIcon icon, int w, int h, int srcX, int srcY, int srcW, int srcH, float zLevel) {
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        double singleU = (maxU - minU) / (double)icon.func_94216_b();
        double singleV = (maxV - minV) / (double)icon.func_94211_a();
        double newMinU = minU + singleU * (double)srcX;
        double newMinV = minV + singleV * (double)srcY;
        double newMaxU = newMinU + singleU * (double)srcW;
        double newMaxV = newMinV + singleV * (double)srcH;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + h), (double)zLevel, newMinU, newMaxV);
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)zLevel, newMaxU, newMaxV);
        tessellator.func_78374_a((double)(x + w), (double)y, (double)zLevel, newMaxU, newMinV);
        tessellator.func_78374_a((double)x, (double)y, (double)zLevel, newMinU, newMinV);
        tessellator.func_78381_a();
    }
}

