/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.events.WearableEvent;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;

public class BackpackUtils {
    private static Timer timer = new Timer();

    public static Reasons equipWearable(ItemStack backpack, EntityPlayer player) {
        BackpackProperty prop = BackpackProperty.get(player);
        if (prop.getWearable() == null) {
            player.field_71070_bA.func_75134_a(player);
            prop.setWearable(backpack.func_77946_l());
            BackpackProperty.get(player).executeWearableEquipProtocol();
            --backpack.field_77994_a;
            WearableEvent.EquipWearableEvent event = new WearableEvent.EquipWearableEvent(player, prop.getWearable());
            MinecraftForge.EVENT_BUS.post((Event)event);
            BackpackProperty.sync(player);
            return Reasons.SUCCESSFUL;
        }
        return Reasons.ALREADY_EQUIPPED;
    }

    public static void unequipWearable(EntityPlayer player) {
        DelayUnequipTask unequipTask = new DelayUnequipTask(player);
        timer.schedule((TimerTask)unequipTask, 200L);
    }

    public static NBTTagCompound getWearableCompound(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.field_77990_d.func_74764_b("wearableData")) {
            BackpackUtils.createWearableCompound(stack);
        }
        return stack.field_77990_d.func_74775_l("wearableData");
    }

    private static void createWearableCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74782_a("wearableData", (NBTBase)new NBTTagCompound());
    }

    public static NBTTagList getWearableInventory(ItemStack stack) {
        if (!BackpackUtils.getWearableCompound(stack).func_74764_b("inventory")) {
            BackpackUtils.createWearableInventory(stack);
        }
        return BackpackUtils.getWearableCompound(stack).func_150295_c("inventory", 10);
    }

    private static void createWearableInventory(ItemStack stack) {
        BackpackUtils.getWearableCompound(stack).func_74782_a("inventory", (NBTBase)new NBTTagList());
    }

    public static ItemStack createBackpackStack(BackpackTypes type) {
        ItemStack backpackStack = new ItemStack((Item)ModItems.adventureBackpack, 1, (int)BackpackTypes.getMeta(type));
        BackpackUtils.setBackpackType(backpackStack, type);
        return backpackStack;
    }

    public static void setBackpackType(ItemStack stack, BackpackTypes type) {
        BackpackUtils.getWearableCompound(stack).func_74774_a("type", BackpackTypes.getMeta(type));
    }

    public static ItemStack createCopterStack() {
        ItemStack copterStack = new ItemStack((Item)ModItems.copterPack, 1, 0);
        BackpackUtils.createWearableCompound(copterStack);
        return copterStack;
    }

    public static ItemStack createJetpackStack() {
        ItemStack jetpackStack = new ItemStack((Item)ModItems.coalJetpack, 1, 0);
        BackpackUtils.createWearableCompound(jetpackStack);
        return jetpackStack;
    }

    private static class DelayUnequipTask
    extends TimerTask {
        private EntityPlayer player;

        DelayUnequipTask(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public void run() {
            BackpackProperty prop = BackpackProperty.get(this.player);
            if (prop.getWearable() != null) {
                this.player.field_71070_bA.func_75134_a(this.player);
                ItemStack gimme = prop.getWearable().func_77946_l();
                BackpackProperty.get(this.player).executeWearableUnequipProtocol();
                prop.setWearable(null);
                if (!this.player.field_71071_by.func_70441_a(gimme)) {
                    this.player.func_71019_a(gimme, false);
                }
                WearableEvent.UnequipWearableEvent event = new WearableEvent.UnequipWearableEvent(this.player, gimme);
                MinecraftForge.EVENT_BUS.post((Event)event);
                BackpackProperty.sync(this.player);
            } else {
                this.player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.already.impossibru", new Object[0]));
            }
        }
    }

    public static enum Reasons {
        SUCCESSFUL,
        ALREADY_EQUIPPED;

    }
}

