/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.CraftingCPURecord;
import appeng.core.AELog;
import appeng.util.Platform;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.ItemBaseWirelessTerminal;
import com.glodblock.github.common.parts.PartFluidPatternTerminal;
import com.glodblock.github.common.parts.PartFluidPatternTerminalEx;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.network.SPacketMEInventoryUpdate;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.BlockPos;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerFluidCraftConfirm
extends AEBaseContainer {
    private final ArrayList<CraftingCPURecord> cpus = new ArrayList();
    private Future<ICraftingJob> job;
    private ICraftingJob result;
    @GuiSync(value=0)
    public long bytesUsed;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=4)
    public boolean simulation = true;
    @GuiSync(value=5)
    public int selectedCpu = -1;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public String myName = "";

    public ContainerFluidCraftConfirm(InventoryPlayer ip, ITerminalHost te) {
        super(ip, (Object)te);
    }

    public void cycleCpu(boolean next) {
        if (next) {
            this.setSelectedCpu(this.getSelectedCpu() + 1);
        } else {
            this.setSelectedCpu(this.getSelectedCpu() - 1);
        }
        if (this.getSelectedCpu() < -1) {
            this.setSelectedCpu(this.cpus.size() - 1);
        } else if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
        }
        if (this.getSelectedCpu() == -1) {
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
        } else {
            this.setName(Ae2Reflect.getName(this.cpus.get(this.getSelectedCpu())));
            this.setCpuAvailableBytes(Ae2Reflect.getSize(this.cpus.get(this.getSelectedCpu())));
            this.setCpuCoProcessors(Ae2Reflect.getProcessors(this.cpus.get(this.getSelectedCpu())));
        }
    }

    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        if (this.getGrid() == null) {
            return;
        }
        ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
        ImmutableSet cpuSet = cc.getCpus();
        int matches = 0;
        boolean changed = false;
        for (ICraftingCPU c : cpuSet) {
            boolean found = false;
            for (CraftingCPURecord ccr : this.cpus) {
                if (Ae2Reflect.getCPU(ccr) != c) continue;
                found = true;
            }
            boolean matched = this.cpuMatches(c);
            if (matched) {
                ++matches;
            }
            if (found != !matched) continue;
            changed = true;
        }
        if (changed || this.cpus.size() != matches) {
            this.cpus.clear();
            for (ICraftingCPU c : cpuSet) {
                if (!this.cpuMatches(c)) continue;
                this.cpus.add(new CraftingCPURecord(c.getAvailableStorage(), c.getCoProcessors(), c));
            }
            this.sendCPUs();
        }
        this.setNoCPU(this.cpus.isEmpty());
        super.func_75142_b();
        if (this.getJob() != null && this.getJob().isDone()) {
            try {
                this.result = this.getJob().get();
                if (!this.result.isSimulation()) {
                    this.setSimulation(false);
                    if (this.isAutoStart()) {
                        this.startJob();
                        return;
                    }
                } else {
                    this.setSimulation(true);
                }
                SPacketMEInventoryUpdate a = new SPacketMEInventoryUpdate(0);
                SPacketMEInventoryUpdate b = new SPacketMEInventoryUpdate(1);
                SPacketMEInventoryUpdate c = this.result.isSimulation() ? new SPacketMEInventoryUpdate(2) : null;
                IItemList plan = AEApi.instance().storage().createItemList();
                this.result.populatePlan(plan);
                this.setUsedBytes(this.result.getByteTotal());
                for (IAEItemStack out : plan) {
                    IAEItemStack o = out.copy();
                    o.reset();
                    o.setStackSize(out.getStackSize());
                    IAEItemStack p = out.copy();
                    p.reset();
                    p.setStackSize(out.getCountRequestable());
                    IStorageGrid sg = (IStorageGrid)this.getGrid().getCache(IStorageGrid.class);
                    IMEMonitor items = sg.getItemInventory();
                    IAEItemStack m = null;
                    if (c != null && this.result.isSimulation()) {
                        m = o.copy();
                        if ((o = (IAEItemStack)items.extractItems((IAEStack)o, Actionable.SIMULATE, this.getActionSource())) == null) {
                            o = m.copy();
                            o.setStackSize(0L);
                        }
                        m.setStackSize(m.getStackSize() - o.getStackSize());
                    }
                    if (o.getStackSize() > 0L) {
                        a.appendItem(o);
                    }
                    if (p.getStackSize() > 0L) {
                        b.appendItem(p);
                    }
                    if (c == null || m == null || m.getStackSize() <= 0L) continue;
                    c.appendItem(m);
                }
                for (Object g : this.field_75149_d) {
                    if (!(g instanceof EntityPlayer)) continue;
                    FluidCraft.proxy.netHandler.sendTo((IMessage)a, (EntityPlayerMP)g);
                    FluidCraft.proxy.netHandler.sendTo((IMessage)b, (EntityPlayerMP)g);
                    if (c == null) continue;
                    FluidCraft.proxy.netHandler.sendTo((IMessage)c, (EntityPlayerMP)g);
                }
            }
            catch (Throwable e) {
                this.getPlayerInv().field_70458_d.func_145747_a((IChatComponent)new ChatComponentText("Error: " + e.toString()));
                AELog.debug((Throwable)e);
                this.setValidContainer(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    private IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        if (h == null || h.getActionableNode() == null) {
            return null;
        }
        return h.getActionableNode().getGrid();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.getAvailableStorage() >= this.getUsedBytes() && !c.isBusy();
    }

    private void sendCPUs() {
        Collections.sort(this.cpus);
        if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
        } else if (this.getSelectedCpu() != -1) {
            this.setName(Ae2Reflect.getName(this.cpus.get(this.getSelectedCpu())));
            this.setCpuAvailableBytes(Ae2Reflect.getSize(this.cpus.get(this.getSelectedCpu())));
            this.setCpuCoProcessors(Ae2Reflect.getProcessors(this.cpus.get(this.getSelectedCpu())));
        }
    }

    public void startJob() {
        ItemStack terminal;
        GuiType originalGui = null;
        IActionHost ah = this.getActionHost();
        if (ah instanceof PartFluidPatternTerminal) {
            originalGui = GuiType.FLUID_PATTERN_TERMINAL;
        }
        if (ah instanceof PartFluidPatternTerminalEx) {
            originalGui = GuiType.FLUID_PATTERN_TERMINAL_EX;
        }
        if (ah instanceof IWirelessTerminal && (terminal = ((IWirelessTerminal)ah).getItemStack()).func_77973_b() instanceof ItemBaseWirelessTerminal) {
            originalGui = ((ItemBaseWirelessTerminal)terminal.func_77973_b()).guiGuiType(terminal);
        }
        if (this.result != null && !this.isSimulation() && this.getGrid() != null) {
            ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
            ICraftingLink g = cc.submitJob(this.result, null, this.getSelectedCpu() == -1 ? null : Ae2Reflect.getCPU(this.cpus.get(this.getSelectedCpu())), true, this.getActionSrc());
            this.setAutoStart(false);
            if (g != null && originalGui != null) {
                if (ah instanceof IWirelessTerminal) {
                    InventoryHandler.openGui(this.getInventoryPlayer().field_70458_d, this.getWorld(), new BlockPos(((IWirelessTerminal)ah).getInventorySlot(), 0, 0), ForgeDirection.UNKNOWN, originalGui);
                } else if (this.getOpenContext() != null) {
                    InventoryHandler.openGui(this.getInventoryPlayer().field_70458_d, this.getWorld(), new BlockPos(this.getOpenContext().getTile()), Objects.requireNonNull(this.getOpenContext().getSide()), originalGui);
                }
            }
        }
    }

    private BaseActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInv().field_70458_d, (IActionHost)this.getTarget());
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public World getWorld() {
        return this.getPlayerInv().field_70458_d.field_70170_p;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public long getUsedBytes() {
        return this.bytesUsed;
    }

    private void setUsedBytes(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public long getCpuAvailableBytes() {
        return this.cpuBytesAvail;
    }

    private void setCpuAvailableBytes(long cpuBytesAvail) {
        this.cpuBytesAvail = cpuBytesAvail;
    }

    public int getCpuCoProcessors() {
        return this.cpuCoProcessors;
    }

    private void setCpuCoProcessors(int cpuCoProcessors) {
        this.cpuCoProcessors = cpuCoProcessors;
    }

    public int getSelectedCpu() {
        return this.selectedCpu;
    }

    private void setSelectedCpu(int selectedCpu) {
        this.selectedCpu = selectedCpu;
    }

    public String getName() {
        return this.myName;
    }

    private void setName(@Nonnull String myName) {
        this.myName = myName;
    }

    public boolean hasNoCPU() {
        return this.noCPU;
    }

    private void setNoCPU(boolean noCPU) {
        this.noCPU = noCPU;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    private void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    private Future<ICraftingJob> getJob() {
        return this.job;
    }

    public void setJob(Future<ICraftingJob> job) {
        this.job = job;
    }
}

