/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.FCBaseItem;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.loader.ItemAndBlockHolder;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidDrop
extends FCBaseItem {
    @SideOnly(value=Side.CLIENT)
    public IIcon shape;

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (CreativeTabs.field_78026_f.equals(tab)) {
            list.add(ItemFluidDrop.newStack(new FluidStack(FluidRegistry.WATER, 1)));
            list.add(ItemFluidDrop.newStack(new FluidStack(FluidRegistry.LAVA, 1)));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = ItemFluidDrop.getFluidStack(stack);
        if (ItemFluidPacket.isDisplay(stack)) {
            return fluid != null ? fluid.getLocalizedName() : StatCollector.func_74837_a((String)"error.unknown", (Object[])new Object[0]);
        }
        return StatCollector.func_74837_a((String)"item.fluid_drop.name", (Object[])new Object[]{fluid == null ? "???" : fluid.getLocalizedName()});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean flag) {
        FluidStack fluid = ItemFluidDrop.getFluidStack(stack);
        if (ItemFluidPacket.isDisplay(stack)) {
            return;
        }
        if (fluid != null) {
            tooltip.add(String.format(EnumChatFormatting.GRAY + "%s, 1 mB", fluid.getLocalizedName()));
        } else {
            tooltip.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"ae2fc.tooltip.invalid_fluid", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        super.func_94581_a(aIconRegister);
        this.shape = aIconRegister.func_94245_a("ae2fc:fluid_drop");
    }

    public static ItemStack newStack(@Nullable FluidStack fluid) {
        if (fluid == null || fluid.amount <= 0) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)ItemAndBlockHolder.DROP, fluid.amount);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Fluid", fluid.getFluid().getName());
        stack.func_77982_d(tag);
        return stack;
    }

    public static ItemStack newDisplayStack(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)ItemAndBlockHolder.DROP, fluid.amount);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Fluid", fluid.getFluid().getName());
        tag.func_74757_a("DisplayOnly", true);
        stack.func_77982_d(tag);
        return stack;
    }

    public static boolean isFluidStack(ItemStack stack) {
        return ItemFluidDrop.getFluidStack(stack) != null;
    }

    public static boolean isFluidStack(@Nullable IAEItemStack stack) {
        if (stack == null) {
            return false;
        }
        return ItemFluidDrop.getFluidStack(stack.getItemStack()) != null;
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != ItemAndBlockHolder.DROP || !stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
        if (!tag.func_150297_b("Fluid", 8)) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)tag.func_74779_i("Fluid").toLowerCase());
        if (fluid == null) {
            return null;
        }
        FluidStack fluidStack = new FluidStack(fluid, stack.field_77994_a);
        if (tag.func_150297_b("FluidTag", 10)) {
            fluidStack.tag = tag.func_74775_l("FluidTag");
        }
        return fluidStack;
    }

    public static IAEFluidStack getAeFluidStack(@Nullable IAEItemStack stack) {
        if (stack == null) {
            return null;
        }
        AEFluidStack fluidStack = AEFluidStack.create((Object)ItemFluidDrop.getFluidStack(stack.getItemStack()));
        if (fluidStack == null) {
            return null;
        }
        fluidStack.setStackSize(stack.getStackSize());
        return fluidStack;
    }

    public static IAEItemStack newAeStack(@Nullable FluidStack fluid) {
        if (fluid == null || fluid.amount <= 0) {
            return null;
        }
        AEItemStack stack = AEItemStack.create((ItemStack)ItemFluidDrop.newStack(fluid));
        if (stack == null) {
            return null;
        }
        stack.setStackSize((long)fluid.amount);
        return stack;
    }

    public static IAEItemStack newAeStack(@Nullable IAEFluidStack fluid) {
        if (fluid == null || fluid.getStackSize() <= 0L) {
            return null;
        }
        AEItemStack stack = AEItemStack.create((ItemStack)ItemFluidDrop.newStack(fluid.getFluidStack()));
        if (stack == null) {
            return null;
        }
        stack.setStackSize(fluid.getStackSize());
        return stack;
    }

    @Override
    public ItemFluidDrop register() {
        GameRegistry.registerItem((Item)this, (String)"fluid_drop", (String)"ae2fc");
        return this;
    }
}

