/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.FCBaseItem;
import com.glodblock.github.loader.ItemAndBlockHolder;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidPacket
extends FCBaseItem {
    public ItemFluidPacket() {
        this.func_77655_b("fluid_packet");
        this.func_77625_d(1);
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return null;
        }
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)Objects.requireNonNull(stack.func_77978_p()).func_74775_l("FluidStack"));
        return fluid != null && fluid.amount > 0 ? fluid : null;
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = ItemFluidPacket.getFluidStack(stack);
        boolean display = ItemFluidPacket.isDisplay(stack);
        if (display) {
            return fluid != null ? fluid.getLocalizedName() : super.func_77653_i(stack);
        }
        return fluid != null ? String.format("%s, %,d mB", fluid.getLocalizedName(), fluid.amount) : super.func_77653_i(stack);
    }

    public static boolean isDisplay(ItemStack stack) {
        if (stack == null || !stack.func_77942_o() || stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("DisplayOnly");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean flags) {
        FluidStack fluid = ItemFluidPacket.getFluidStack(stack);
        boolean display = ItemFluidPacket.isDisplay(stack);
        if (display) {
            return;
        }
        if (fluid != null) {
            for (String line : StatCollector.func_74837_a((String)"ae2fc.tooltip.fluid_packet", (Object[])new Object[0]).split("\\\\n")) {
                tooltip.add(EnumChatFormatting.GRAY + line);
            }
        } else {
            tooltip.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"ae2fc.tooltip.invalid_fluid", (Object[])new Object[0]));
        }
    }

    public static FluidStack getFluidStack(@Nullable IAEItemStack stack) {
        return stack != null ? ItemFluidPacket.getFluidStack(stack.getItemStack()) : null;
    }

    public static ItemStack newStack(@Nullable FluidStack fluid) {
        if (fluid == null || fluid.amount == 0) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)ItemAndBlockHolder.PACKET);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound fluidTag = new NBTTagCompound();
        fluid.writeToNBT(fluidTag);
        tag.func_74782_a("FluidStack", (NBTBase)fluidTag);
        stack.func_77982_d(tag);
        return stack;
    }

    public static ItemStack newStack(@Nullable IAEFluidStack fluid) {
        if (fluid == null || fluid.getStackSize() == 0L) {
            return null;
        }
        return ItemFluidPacket.newStack(fluid.getFluidStack());
    }

    public static ItemStack newDisplayStack(@Nullable FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        FluidStack copy = fluid.copy();
        copy.amount = 1000;
        ItemStack stack = new ItemStack((Item)ItemAndBlockHolder.PACKET);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound fluidTag = new NBTTagCompound();
        copy.writeToNBT(fluidTag);
        tag.func_74782_a("FluidStack", (NBTBase)fluidTag);
        tag.func_74757_a("DisplayOnly", true);
        stack.func_77982_d(tag);
        return stack;
    }

    @Nullable
    public static IAEItemStack newAeStack(@Nullable FluidStack fluid) {
        return AEItemStack.create((ItemStack)ItemFluidPacket.newStack(fluid));
    }

    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int p_77617_1_) {
        return FluidRegistry.WATER.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack aStack, int aRenderPass) {
        Fluid tFluid = FluidRegistry.getFluid((int)aStack.func_77960_j());
        return tFluid == null ? 0xFFFFFF : tFluid.getColor();
    }

    @Override
    public ItemFluidPacket register() {
        GameRegistry.registerItem((Item)this, (String)"fluid_packet", (String)"ae2fc");
        return this;
    }
}

